import deskbar.core.Utils
import cgi
import gtk.gdk

"""
Represents a match returned by handlers
"""

class Match:
	def __init__(self, **args):
		"""
		You can pass the named paramter "icon" as a string being an
		absolute path or name of an icon.
		"""
		self._name = ""
		self._icon = None
		self._pixbuf = None
		self._category = "default"
		self._priority = 0
		if "name" in args:
			self._name = args["name"]
		if "icon" in args:
			self._icon = args["icon"]
		if "pixbuf" in args and isinstance(args["pixbuf"], gtk.gdk.Pixbuf):
			# WARNING: Only set a pixbuf if skip_history() always returns True
			# Otherwise saving to history won't work
			self._pixbuf = args["pixbuf"]
		if "category" in args:
			self._category = args["category"]
		if "priority" in args:
			self._priority = args["priority"]
	
	def get_priority(self):
		return self._priority
	
	def set_priority(self, prio):
		self._priority = prio
		
	def get_icon(self):
		"""
		Returns a GdkPixbuf hat represents this match.
		Returns None if there is no associated icon.
		"""
		if self._pixbuf != None:
			# Only for Matches that won't be stored in history
			return self._pixbuf
		elif self._icon != None:
			return deskbar.core.Utils.load_icon(self._icon)
		else:
			return deskbar.core.Utils.load_icon("empty")
	
	def set_icon(self, iconname):
		self._icon = iconname
	
	def get_category(self):
		"""
		Returns a string corresponding to a key in the Categories.py file, indicating
		in which category this match should be put in.
		
		Returning None, uses the default category
		"""
		return self._category
	
	def set_category(self, cat):
		self._category = cat
	
	def get_escaped_name(self, text=None):
		name_dict = {}
		for key, value in self.get_name(text).items():
			name_dict[key] = cgi.escape(value)
		return name_dict
	
	def action(self, text=None):
		"""
		Tell the match to do the associated action.
		This method should not block.
		The optional text is the additional argument entered in the entry
		"""
		raise NotImplementedError
		
	def get_verb(self):
		"""
		Returns the action string associated to this handler.
		
		The string must contain one or more "%(name)s" that will
		be replaced by the match get_name().
		
		The %(text)s will be replaced by the typed text.
		By default the %(name)s will be replaced by the self._name
		
		The string can also contain pango markup.
		
		Examples:
		 Send mail to %(address)s
		 Search <b>%s</b> for %(text)s
		 Execute %(prog)s
		"""
		raise NotImplementedError
		
	def get_name(self, text=None):
		"""
		Returns a dictionary whose entries will be used in the Action
		string returned by get_verb.
		
		The passed string is the complete query string.
		
		The resulting action text will be
		match.get_verb() % match.get_name(query)
		
		Remember to escape pango markup if needed.
		"""
		return {"name": self._name}
		
	def get_hash(self, text=None):
		"""
		Returns a hash used to verify if a query has one or more duplicates.
		Matches that have same hash will be selected based on the handler priority.
		text is the entered query string.
		By default, if the handler does not override this, it will return None.
		Returning None means no duplication check will be performed.
		"""
		return None
	
	def is_valid(self, text=None):
		"""
		Tests wether the match is still valid, by default it's True.
		For example if a file has moved, the file match is invalid
		The optional text is the additional argument entered in the entry
		"""
		return True
	
	def skip_history(self):
		"""
		Wether the match should appear or not in the history dropdown (and thus be saved as history is saved)
		"""
		return False