#include <gnome.h>
#include "menus.h"
#include "procview.h"
#include "perfview.h"
#include "fsview.h"
#include "sysview.h"

GtkWidget *window;
GtkWidget *notebook;
GtkWidget *mbox;
GtkWidget *menubar;	

GtkAcceleratorTable *accel;

int
delete_event_handler (GtkWidget *widget, gpointer *data)
{
        gtk_widget_destroy (window);
        gtk_main_quit ();

        return TRUE;
}

void
createMainWindow ()
{
	window = gtk_window_new (GTK_WINDOW_TOPLEVEL);
	gtk_widget_set_usize(GTK_WIDGET(window), 780, 480);
	gtk_window_set_title(GTK_WINDOW(window), "gtop");

	gtk_signal_connect (GTK_OBJECT (window), "delete_event",
			    GTK_SIGNAL_FUNC (delete_event_handler), NULL);
        
	mbox = gtk_vbox_new (FALSE, 10);
	notebook = gtk_notebook_new ();

	get_main_menu(&menubar, &accel);
	gtk_window_add_accelerator_table(GTK_WINDOW(window), accel);
	gtk_box_pack_start(GTK_BOX(mbox), menubar, FALSE, TRUE, 0);
	gtk_widget_show(menubar);

        gtk_container_add (GTK_CONTAINER (window), mbox);
	gtk_notebook_set_tab_pos (GTK_NOTEBOOK (notebook), GTK_POS_TOP);
	gtk_box_pack_start (GTK_BOX (mbox), notebook, TRUE, TRUE, 0);

	gtk_widget_show (notebook);
	gtk_widget_show (mbox);
}
        
int main (int argc, char *argv[])
{
	gtk_init (&argc, &argv);
	//gnome_init (&argc, &argv);

	createMainWindow ();

	addProcessView ();
	addPerformanceView ();
	addFilesystemsView ();
	addSystemView ();
        
        gtk_widget_show (window);

        gtk_main ();
        
        return 0;
}
