/* node.c generated by valac, the Vala compiler
 * generated from node.vala, do not modify */

/* node.vala
 *
 * Copyright (C) 2008-2009 Florian Brosch, Didier Villevalois
 * Copyright (C) 20011 Florian Brosch
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Didier 'Ptitjes Villevalois <ptitjes@free.fr>
 */

#include <glib.h>
#include <glib-object.h>
#include "valadoc.h"
#include <stdlib.h>
#include <string.h>
#include <valagee.h>

enum  {
	VALADOC_API_NODE_DUMMY_PROPERTY,
	VALADOC_API_NODE_NAME_PROPERTY,
	VALADOC_API_NODE_NODE_TYPE_PROPERTY,
	VALADOC_API_NODE_NSPACE_PROPERTY,
	VALADOC_API_NODE_PACKAGE_PROPERTY,
	VALADOC_API_NODE_DOCUMENTATION_PROPERTY,
	VALADOC_API_NODE_LAST_PROPERTY
};
static GParamSpec* valadoc_api_node_properties[VALADOC_API_NODE_LAST_PROPERTY];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _vala_map_unref0(var) ((var == NULL) ? NULL : (var = (vala_map_unref (var), NULL)))
#define _vala_iterable_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterable_unref (var), NULL)))
#define _vala_iterator_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterator_unref (var), NULL)))
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))

struct _ValadocApiNodePrivate {
	ValadocApiSourceFile* file;
	gchar* _name;
	ValaMap* per_name_children;
	ValaMap* per_type_children;
	ValadocApiNamespace* _nspace;
	ValadocApiPackage* _package;
	gchar* _full_name;
	ValadocContentComment* _documentation;
};


static gpointer valadoc_api_node_parent_class = NULL;
static ValadocApiBrowsableIface * valadoc_api_node_valadoc_api_browsable_parent_iface = NULL;
static ValadocDocumentationIface * valadoc_api_node_valadoc_documentation_parent_iface = NULL;

#define VALADOC_API_NODE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALADOC_API_TYPE_NODE, ValadocApiNodePrivate))
static gboolean valadoc_api_node_is_keyword (ValadocApiNode* self, const gchar* name);
static void valadoc_api_node_set_name (ValadocApiNode* self, const gchar* value);
static void valadoc_api_node_real_accept (ValadocApiNode* self, ValadocApiVisitor* visitor);
static gboolean valadoc_api_node_real_is_browsable (ValadocApiNode* self, ValadocSettings* settings);
static gchar* valadoc_api_node_real_get_filename (ValadocDocumentation* base);
static void valadoc_api_node_real_parse_comments (ValadocApiItem* base, ValadocSettings* settings, ValadocDocumentationParser* parser);
G_GNUC_INTERNAL void valadoc_api_item_parse_comments (ValadocApiItem* self, ValadocSettings* settings, ValadocDocumentationParser* parser);
static void valadoc_api_node_real_check_comments (ValadocApiItem* base, ValadocSettings* settings, ValadocDocumentationParser* parser);
G_GNUC_INTERNAL void valadoc_api_item_check_comments (ValadocApiItem* self, ValadocSettings* settings, ValadocDocumentationParser* parser);
G_GNUC_INTERNAL void valadoc_api_node_set_documentation (ValadocApiNode* self, ValadocContentComment* value);
static void valadoc_api_node_finalize (GObject * obj);
static void _vala_valadoc_api_node_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_valadoc_api_node_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


ValadocApiSourceFile* valadoc_api_node_get_source_file (ValadocApiNode* self) {
	ValadocApiSourceFile* result = NULL;
	ValadocApiSourceFile* _tmp0_;
	ValadocApiSourceFile* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->file;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	result = _tmp1_;
	return result;
}


static gchar string_get (const gchar* self, glong index) {
	gchar result = '\0';
	glong _tmp0_;
	gchar _tmp1_;
	g_return_val_if_fail (self != NULL, '\0');
	_tmp0_ = index;
	_tmp1_ = ((gchar*) self)[_tmp0_];
	result = _tmp1_;
	return result;
}


ValadocApiNode* valadoc_api_node_construct (GType object_type, ValadocApiNode* parent, ValadocApiSourceFile* file, const gchar* name, void* data) {
	ValadocApiNode * self = NULL;
	void* _tmp0_;
	GHashFunc _tmp1_;
	GEqualFunc _tmp2_;
	GEqualFunc _tmp3_;
	ValaHashMap* _tmp4_;
	GHashFunc _tmp5_;
	GEqualFunc _tmp6_;
	GEqualFunc _tmp7_;
	ValaHashMap* _tmp8_;
	gboolean _tmp9_ = FALSE;
	const gchar* _tmp10_;
	ValadocApiNode* _tmp21_;
	ValadocApiSourceFile* _tmp22_;
	ValadocApiSourceFile* _tmp23_;
	_tmp0_ = data;
	self = (ValadocApiNode*) valadoc_api_item_construct (object_type, _tmp0_);
	_tmp1_ = g_str_hash;
	_tmp2_ = g_str_equal;
	_tmp3_ = g_direct_equal;
	_tmp4_ = vala_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, VALADOC_API_TYPE_NODE, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, _tmp1_, _tmp2_, _tmp3_);
	_vala_map_unref0 (self->priv->per_name_children);
	self->priv->per_name_children = (ValaMap*) _tmp4_;
	_tmp5_ = g_direct_hash;
	_tmp6_ = g_direct_equal;
	_tmp7_ = g_direct_equal;
	_tmp8_ = vala_hash_map_new (VALADOC_API_TYPE_NODE_TYPE, NULL, NULL, VALA_TYPE_LIST, (GBoxedCopyFunc) vala_iterable_ref, (GDestroyNotify) vala_iterable_unref, _tmp5_, _tmp6_, _tmp7_);
	_vala_map_unref0 (self->priv->per_type_children);
	self->priv->per_type_children = (ValaMap*) _tmp8_;
	_tmp10_ = name;
	if (_tmp10_ != NULL) {
		gboolean _tmp11_ = FALSE;
		const gchar* _tmp12_;
		gboolean _tmp13_;
		_tmp12_ = name;
		_tmp13_ = valadoc_api_node_is_keyword (self, _tmp12_);
		if (_tmp13_) {
			_tmp11_ = TRUE;
		} else {
			const gchar* _tmp14_;
			gchar _tmp15_;
			gboolean _tmp16_;
			_tmp14_ = name;
			_tmp15_ = string_get (_tmp14_, (glong) 0);
			_tmp16_ = g_ascii_isdigit (_tmp15_);
			_tmp11_ = _tmp16_;
		}
		_tmp9_ = _tmp11_;
	} else {
		_tmp9_ = FALSE;
	}
	if (_tmp9_) {
		const gchar* _tmp17_;
		gchar* _tmp18_;
		gchar* _tmp19_;
		_tmp17_ = name;
		_tmp18_ = g_strconcat ("@", _tmp17_, NULL);
		_tmp19_ = _tmp18_;
		valadoc_api_node_set_name (self, _tmp19_);
		_g_free0 (_tmp19_);
	} else {
		const gchar* _tmp20_;
		_tmp20_ = name;
		valadoc_api_node_set_name (self, _tmp20_);
	}
	_tmp21_ = parent;
	valadoc_api_item_set_parent ((ValadocApiItem*) self, (ValadocApiItem*) _tmp21_);
	_tmp22_ = file;
	_tmp23_ = _g_object_ref0 (_tmp22_);
	_g_object_unref0 (self->priv->file);
	self->priv->file = _tmp23_;
	return self;
}


/**
 * Visits this node with the specified Visitor.
 *
 * @param visitor the visitor to be called while traversing
 */
static void valadoc_api_node_real_accept (ValadocApiNode* self, ValadocApiVisitor* visitor) {
	g_critical ("Type `%s' does not implement abstract method `valadoc_api_node_accept'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return;
}


void valadoc_api_node_accept (ValadocApiNode* self, ValadocApiVisitor* visitor) {
	g_return_if_fail (self != NULL);
	VALADOC_API_NODE_GET_CLASS (self)->accept (self, visitor);
}


/**
 * {@inheritDoc}
 */
static gboolean valadoc_api_node_real_is_browsable (ValadocApiNode* self, ValadocSettings* settings) {
	gboolean _tmp0_ = FALSE;
	g_critical ("Type `%s' does not implement abstract method `valadoc_api_node_is_browsable'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return _tmp0_;
}


gboolean valadoc_api_node_is_browsable (ValadocApiNode* self, ValadocSettings* settings) {
	g_return_val_if_fail (self != NULL, FALSE);
	return VALADOC_API_NODE_GET_CLASS (self)->is_browsable (self, settings);
}


/**
 * {@inheritDoc}
 */
static gchar* valadoc_api_node_real_get_filename (ValadocDocumentation* base) {
	ValadocApiNode * self;
	gchar* result = NULL;
	ValadocApiSourceFile* _tmp0_;
	ValadocApiSourceFile* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	gchar* _tmp4_;
	self = (ValadocApiNode*) base;
	_tmp0_ = self->priv->file;
	if (_tmp0_ == NULL) {
		result = NULL;
		return result;
	}
	_tmp1_ = self->priv->file;
	_tmp2_ = valadoc_api_source_file_get_relative_path (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = g_strdup (_tmp3_);
	result = _tmp4_;
	return result;
}


void valadoc_api_node_add_child (ValadocApiNode* self, ValadocApiSymbol* child) {
	ValadocApiSymbol* _tmp0_;
	const gchar* _tmp1_;
	ValaList* children = NULL;
	ValaMap* _tmp16_;
	ValadocApiSymbol* _tmp17_;
	ValadocApiNodeType _tmp18_;
	ValadocApiNodeType _tmp19_;
	gpointer _tmp20_;
	ValaList* _tmp21_;
	ValaList* _tmp29_;
	ValadocApiSymbol* _tmp30_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (child != NULL);
	_tmp0_ = child;
	_tmp1_ = ((ValadocApiNode*) _tmp0_)->priv->_name;
	if (_tmp1_ != NULL) {
		ValadocApiSymbol* _tmp2_;
		const gchar* _tmp3_;
		gchar _tmp4_;
		_tmp2_ = child;
		_tmp3_ = ((ValadocApiNode*) _tmp2_)->priv->_name;
		_tmp4_ = string_get (_tmp3_, (glong) 0);
		if (_tmp4_ == '@') {
			ValaMap* _tmp5_;
			ValadocApiSymbol* _tmp6_;
			const gchar* _tmp7_;
			const gchar* _tmp8_;
			ValadocApiSymbol* _tmp9_;
			_tmp5_ = self->priv->per_name_children;
			_tmp6_ = child;
			_tmp7_ = ((ValadocApiNode*) _tmp6_)->priv->_name;
			_tmp8_ = g_utf8_next_char (_tmp7_);
			_tmp9_ = child;
			vala_map_set (_tmp5_, _tmp8_, (ValadocApiNode*) _tmp9_);
		} else {
			ValaMap* _tmp10_;
			ValadocApiSymbol* _tmp11_;
			const gchar* _tmp12_;
			ValadocApiSymbol* _tmp13_;
			_tmp10_ = self->priv->per_name_children;
			_tmp11_ = child;
			_tmp12_ = ((ValadocApiNode*) _tmp11_)->priv->_name;
			_tmp13_ = child;
			vala_map_set (_tmp10_, _tmp12_, (ValadocApiNode*) _tmp13_);
		}
	} else {
		ValaMap* _tmp14_;
		ValadocApiSymbol* _tmp15_;
		_tmp14_ = self->priv->per_name_children;
		_tmp15_ = child;
		vala_map_set (_tmp14_, "", (ValadocApiNode*) _tmp15_);
	}
	_tmp16_ = self->priv->per_type_children;
	_tmp17_ = child;
	_tmp18_ = valadoc_api_node_get_node_type ((ValadocApiNode*) _tmp17_);
	_tmp19_ = _tmp18_;
	_tmp20_ = vala_map_get (_tmp16_, (gpointer) ((gintptr) _tmp19_));
	children = (ValaList*) _tmp20_;
	_tmp21_ = children;
	if (_tmp21_ == NULL) {
		GEqualFunc _tmp22_;
		ValaArrayList* _tmp23_;
		ValaMap* _tmp24_;
		ValadocApiSymbol* _tmp25_;
		ValadocApiNodeType _tmp26_;
		ValadocApiNodeType _tmp27_;
		ValaList* _tmp28_;
		_tmp22_ = g_direct_equal;
		_tmp23_ = vala_array_list_new (VALADOC_API_TYPE_NODE, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, _tmp22_);
		_vala_iterable_unref0 (children);
		children = (ValaList*) _tmp23_;
		_tmp24_ = self->priv->per_type_children;
		_tmp25_ = child;
		_tmp26_ = valadoc_api_node_get_node_type ((ValadocApiNode*) _tmp25_);
		_tmp27_ = _tmp26_;
		_tmp28_ = children;
		vala_map_set (_tmp24_, (gpointer) ((gintptr) _tmp27_), _tmp28_);
	}
	_tmp29_ = children;
	_tmp30_ = child;
	vala_collection_add ((ValaCollection*) _tmp29_, (ValadocApiNode*) _tmp30_);
	_vala_iterable_unref0 (children);
}


/**
 * {@inheritDoc}
 */
static void valadoc_api_node_real_parse_comments (ValadocApiItem* base, ValadocSettings* settings, ValadocDocumentationParser* parser) {
	ValadocApiNode * self;
	self = (ValadocApiNode*) base;
	g_return_if_fail (settings != NULL);
	g_return_if_fail (parser != NULL);
	self->do_document = TRUE;
	{
		ValaIterator* _node_it = NULL;
		ValaMap* _tmp0_;
		ValaCollection* _tmp1_;
		ValaCollection* _tmp2_;
		ValaIterator* _tmp3_;
		ValaIterator* _tmp4_;
		_tmp0_ = self->priv->per_name_children;
		_tmp1_ = vala_map_get_values (_tmp0_);
		_tmp2_ = _tmp1_;
		_tmp3_ = vala_iterable_iterator ((ValaIterable*) _tmp2_);
		_tmp4_ = _tmp3_;
		_vala_iterable_unref0 (_tmp2_);
		_node_it = _tmp4_;
		while (TRUE) {
			ValaIterator* _tmp5_;
			gboolean _tmp6_;
			ValadocApiNode* node = NULL;
			ValaIterator* _tmp7_;
			gpointer _tmp8_;
			ValadocApiNode* _tmp9_;
			ValadocSettings* _tmp10_;
			gboolean _tmp11_;
			_tmp5_ = _node_it;
			_tmp6_ = vala_iterator_next (_tmp5_);
			if (!_tmp6_) {
				break;
			}
			_tmp7_ = _node_it;
			_tmp8_ = vala_iterator_get (_tmp7_);
			node = (ValadocApiNode*) _tmp8_;
			_tmp9_ = node;
			_tmp10_ = settings;
			_tmp11_ = valadoc_api_node_is_browsable (_tmp9_, _tmp10_);
			if (_tmp11_) {
				ValadocApiNode* _tmp12_;
				ValadocSettings* _tmp13_;
				ValadocDocumentationParser* _tmp14_;
				_tmp12_ = node;
				_tmp13_ = settings;
				_tmp14_ = parser;
				valadoc_api_item_parse_comments ((ValadocApiItem*) _tmp12_, _tmp13_, _tmp14_);
			}
			_g_object_unref0 (node);
		}
		_vala_iterator_unref0 (_node_it);
	}
}


/**
 * {@inheritDoc}
 */
static void valadoc_api_node_real_check_comments (ValadocApiItem* base, ValadocSettings* settings, ValadocDocumentationParser* parser) {
	ValadocApiNode * self;
	self = (ValadocApiNode*) base;
	g_return_if_fail (settings != NULL);
	g_return_if_fail (parser != NULL);
	{
		ValaIterator* _node_it = NULL;
		ValaMap* _tmp0_;
		ValaCollection* _tmp1_;
		ValaCollection* _tmp2_;
		ValaIterator* _tmp3_;
		ValaIterator* _tmp4_;
		_tmp0_ = self->priv->per_name_children;
		_tmp1_ = vala_map_get_values (_tmp0_);
		_tmp2_ = _tmp1_;
		_tmp3_ = vala_iterable_iterator ((ValaIterable*) _tmp2_);
		_tmp4_ = _tmp3_;
		_vala_iterable_unref0 (_tmp2_);
		_node_it = _tmp4_;
		while (TRUE) {
			ValaIterator* _tmp5_;
			gboolean _tmp6_;
			ValadocApiNode* node = NULL;
			ValaIterator* _tmp7_;
			gpointer _tmp8_;
			ValadocApiNode* _tmp9_;
			ValadocSettings* _tmp10_;
			gboolean _tmp11_;
			_tmp5_ = _node_it;
			_tmp6_ = vala_iterator_next (_tmp5_);
			if (!_tmp6_) {
				break;
			}
			_tmp7_ = _node_it;
			_tmp8_ = vala_iterator_get (_tmp7_);
			node = (ValadocApiNode*) _tmp8_;
			_tmp9_ = node;
			_tmp10_ = settings;
			_tmp11_ = valadoc_api_node_is_browsable (_tmp9_, _tmp10_);
			if (_tmp11_) {
				ValadocApiNode* _tmp12_;
				ValadocSettings* _tmp13_;
				ValadocDocumentationParser* _tmp14_;
				_tmp12_ = node;
				_tmp13_ = settings;
				_tmp14_ = parser;
				valadoc_api_item_check_comments ((ValadocApiItem*) _tmp12_, _tmp13_, _tmp14_);
			}
			_g_object_unref0 (node);
		}
		_vala_iterator_unref0 (_node_it);
	}
}


/**
 * Specifies whether this node has at least one visible child with the given type
 *
 * @param type a node type
 */
static gpointer _vala_iterable_ref0 (gpointer self) {
	return self ? vala_iterable_ref (self) : NULL;
}


gboolean valadoc_api_node_has_visible_children_by_type (ValadocApiNode* self, ValadocApiNodeType type, ValadocSettings* settings) {
	gboolean result = FALSE;
	ValaList* all_children = NULL;
	ValaMap* _tmp0_;
	ValadocApiNodeType _tmp1_;
	gpointer _tmp2_;
	ValaList* _tmp3_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (settings != NULL, FALSE);
	_tmp0_ = self->priv->per_type_children;
	_tmp1_ = type;
	_tmp2_ = vala_map_get (_tmp0_, (gpointer) ((gintptr) _tmp1_));
	all_children = (ValaList*) _tmp2_;
	_tmp3_ = all_children;
	if (_tmp3_ != NULL) {
		{
			ValaList* _node_list = NULL;
			ValaList* _tmp4_;
			ValaList* _tmp5_;
			gint _node_size = 0;
			ValaList* _tmp6_;
			gint _tmp7_;
			gint _tmp8_;
			gint _node_index = 0;
			_tmp4_ = all_children;
			_tmp5_ = _vala_iterable_ref0 (_tmp4_);
			_node_list = _tmp5_;
			_tmp6_ = _node_list;
			_tmp7_ = vala_collection_get_size ((ValaCollection*) _tmp6_);
			_tmp8_ = _tmp7_;
			_node_size = _tmp8_;
			_node_index = -1;
			while (TRUE) {
				gint _tmp9_;
				gint _tmp10_;
				gint _tmp11_;
				ValadocApiNode* node = NULL;
				ValaList* _tmp12_;
				gint _tmp13_;
				gpointer _tmp14_;
				ValadocApiNode* _tmp15_;
				ValadocSettings* _tmp16_;
				gboolean _tmp17_;
				_tmp9_ = _node_index;
				_node_index = _tmp9_ + 1;
				_tmp10_ = _node_index;
				_tmp11_ = _node_size;
				if (!(_tmp10_ < _tmp11_)) {
					break;
				}
				_tmp12_ = _node_list;
				_tmp13_ = _node_index;
				_tmp14_ = vala_list_get (_tmp12_, _tmp13_);
				node = (ValadocApiNode*) _tmp14_;
				_tmp15_ = node;
				_tmp16_ = settings;
				_tmp17_ = valadoc_api_node_is_browsable (_tmp15_, _tmp16_);
				if (_tmp17_) {
					result = TRUE;
					_g_object_unref0 (node);
					_vala_iterable_unref0 (_node_list);
					_vala_iterable_unref0 (all_children);
					return result;
				}
				_g_object_unref0 (node);
			}
			_vala_iterable_unref0 (_node_list);
		}
	}
	result = FALSE;
	_vala_iterable_unref0 (all_children);
	return result;
}


/**
 * Specifies whether this node has at least one visible child with the given types
 *
 * @param types a list of node types
 */
gboolean valadoc_api_node_has_visible_children_by_types (ValadocApiNode* self, ValadocApiNodeType* types, int types_length1, ValadocSettings* settings) {
	gboolean result = FALSE;
	ValadocApiNodeType* _tmp0_;
	gint _tmp0__length1;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (settings != NULL, FALSE);
	_tmp0_ = types;
	_tmp0__length1 = types_length1;
	{
		ValadocApiNodeType* type_collection = NULL;
		gint type_collection_length1 = 0;
		gint _type_collection_size_ = 0;
		gint type_it = 0;
		type_collection = _tmp0_;
		type_collection_length1 = _tmp0__length1;
		for (type_it = 0; type_it < _tmp0__length1; type_it = type_it + 1) {
			ValadocApiNodeType type = 0;
			type = type_collection[type_it];
			{
				ValadocApiNodeType _tmp1_;
				ValadocSettings* _tmp2_;
				gboolean _tmp3_;
				_tmp1_ = type;
				_tmp2_ = settings;
				_tmp3_ = valadoc_api_node_has_visible_children_by_type (self, _tmp1_, _tmp2_);
				if (_tmp3_) {
					result = TRUE;
					return result;
				}
			}
		}
	}
	result = FALSE;
	return result;
}


/**
 * Specifies whether this node has at least one visible child
 */
gboolean valadoc_api_node_has_visible_children (ValadocApiNode* self, ValadocSettings* settings) {
	gboolean result = FALSE;
	ValaMap* _tmp0_;
	ValaSet* _tmp1_;
	ValaSet* _tmp2_;
	gint _tmp3_;
	gpointer* _tmp4_;
	ValadocApiNodeType* _tmp5_;
	gint _tmp5__length1;
	ValadocSettings* _tmp6_;
	gboolean _tmp7_;
	gboolean _tmp8_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (settings != NULL, FALSE);
	_tmp0_ = self->priv->per_type_children;
	_tmp1_ = vala_map_get_keys (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp4_ = vala_collection_to_array ((ValaCollection*) _tmp2_, &_tmp3_);
	_tmp5_ = _tmp4_;
	_tmp5__length1 = _tmp3_;
	_tmp6_ = settings;
	_tmp7_ = valadoc_api_node_has_visible_children_by_types (self, _tmp5_, _tmp3_, _tmp6_);
	_tmp8_ = _tmp7_;
	_tmp5_ = (g_free (_tmp5_), NULL);
	_vala_iterable_unref0 (_tmp2_);
	result = _tmp8_;
	return result;
}


/**
 * Specifies whether this node has at least one child with the given type
 *
 * @param type a node type
 */
gboolean valadoc_api_node_has_children_by_type (ValadocApiNode* self, ValadocApiNodeType type) {
	gboolean result = FALSE;
	ValaList* all_children = NULL;
	ValaMap* _tmp0_;
	ValadocApiNodeType _tmp1_;
	gpointer _tmp2_;
	gboolean _tmp3_ = FALSE;
	ValaList* _tmp4_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->per_type_children;
	_tmp1_ = type;
	_tmp2_ = vala_map_get (_tmp0_, (gpointer) ((gintptr) _tmp1_));
	all_children = (ValaList*) _tmp2_;
	_tmp4_ = all_children;
	if (_tmp4_ != NULL) {
		ValaList* _tmp5_;
		gboolean _tmp6_;
		gboolean _tmp7_;
		_tmp5_ = all_children;
		_tmp6_ = vala_collection_get_is_empty ((ValaCollection*) _tmp5_);
		_tmp7_ = _tmp6_;
		_tmp3_ = !_tmp7_;
	} else {
		_tmp3_ = FALSE;
	}
	result = _tmp3_;
	_vala_iterable_unref0 (all_children);
	return result;
}


/**
 * Specifies whether this node has at least one child with the given types
 *
 * @param types a list of node types
 */
gboolean valadoc_api_node_has_children (ValadocApiNode* self, ValadocApiNodeType* types, int types_length1) {
	gboolean result = FALSE;
	ValadocApiNodeType* _tmp0_;
	gint _tmp0__length1;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = types;
	_tmp0__length1 = types_length1;
	{
		ValadocApiNodeType* type_collection = NULL;
		gint type_collection_length1 = 0;
		gint _type_collection_size_ = 0;
		gint type_it = 0;
		type_collection = _tmp0_;
		type_collection_length1 = _tmp0__length1;
		for (type_it = 0; type_it < _tmp0__length1; type_it = type_it + 1) {
			ValadocApiNodeType type = 0;
			type = type_collection[type_it];
			{
				ValadocApiNodeType _tmp1_;
				gboolean _tmp2_;
				_tmp1_ = type;
				_tmp2_ = valadoc_api_node_has_children_by_type (self, _tmp1_);
				if (_tmp2_) {
					result = TRUE;
					return result;
				}
			}
		}
	}
	result = FALSE;
	return result;
}


/**
 * Returns a list of all children with the given type.
 *
 * @param type a node type
 * @param filtered specifies whether nodes which are not browsable should appear in the list
 */
ValaList* valadoc_api_node_get_children_by_type (ValadocApiNode* self, ValadocApiNodeType type, gboolean filtered) {
	ValaList* result = NULL;
	ValaArrayList* children = NULL;
	GEqualFunc _tmp0_;
	ValaArrayList* _tmp1_;
	ValaList* all_children = NULL;
	ValaMap* _tmp2_;
	ValadocApiNodeType _tmp3_;
	gpointer _tmp4_;
	ValaList* _tmp5_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_direct_equal;
	_tmp1_ = vala_array_list_new (VALADOC_API_TYPE_NODE, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, _tmp0_);
	children = _tmp1_;
	_tmp2_ = self->priv->per_type_children;
	_tmp3_ = type;
	_tmp4_ = vala_map_get (_tmp2_, (gpointer) ((gintptr) _tmp3_));
	all_children = (ValaList*) _tmp4_;
	_tmp5_ = all_children;
	if (_tmp5_ != NULL) {
		{
			ValaList* _node_list = NULL;
			ValaList* _tmp6_;
			ValaList* _tmp7_;
			gint _node_size = 0;
			ValaList* _tmp8_;
			gint _tmp9_;
			gint _tmp10_;
			gint _node_index = 0;
			_tmp6_ = all_children;
			_tmp7_ = _vala_iterable_ref0 (_tmp6_);
			_node_list = _tmp7_;
			_tmp8_ = _node_list;
			_tmp9_ = vala_collection_get_size ((ValaCollection*) _tmp8_);
			_tmp10_ = _tmp9_;
			_node_size = _tmp10_;
			_node_index = -1;
			while (TRUE) {
				gint _tmp11_;
				gint _tmp12_;
				gint _tmp13_;
				ValadocApiNode* node = NULL;
				ValaList* _tmp14_;
				gint _tmp15_;
				gpointer _tmp16_;
				gboolean _tmp17_ = FALSE;
				ValadocApiNode* _tmp18_;
				gboolean _tmp19_;
				_tmp11_ = _node_index;
				_node_index = _tmp11_ + 1;
				_tmp12_ = _node_index;
				_tmp13_ = _node_size;
				if (!(_tmp12_ < _tmp13_)) {
					break;
				}
				_tmp14_ = _node_list;
				_tmp15_ = _node_index;
				_tmp16_ = vala_list_get (_tmp14_, _tmp15_);
				node = (ValadocApiNode*) _tmp16_;
				_tmp18_ = node;
				_tmp19_ = _tmp18_->do_document;
				if (_tmp19_) {
					_tmp17_ = TRUE;
				} else {
					gboolean _tmp20_;
					_tmp20_ = filtered;
					_tmp17_ = !_tmp20_;
				}
				if (_tmp17_) {
					ValaArrayList* _tmp21_;
					ValadocApiNode* _tmp22_;
					_tmp21_ = children;
					_tmp22_ = node;
					vala_collection_add ((ValaCollection*) _tmp21_, _tmp22_);
				}
				_g_object_unref0 (node);
			}
			_vala_iterable_unref0 (_node_list);
		}
	}
	result = (ValaList*) children;
	_vala_iterable_unref0 (all_children);
	return result;
}


/**
 * Returns a list of all children with the given types.
 *
 * @param types a list of node types
 * @param filtered specifies whether nodes which are not browsable should appear in the list
 */
ValaList* valadoc_api_node_get_children_by_types (ValadocApiNode* self, ValadocApiNodeType* types, int types_length1, gboolean filtered) {
	ValaList* result = NULL;
	ValaArrayList* children = NULL;
	GEqualFunc _tmp0_;
	ValaArrayList* _tmp1_;
	ValadocApiNodeType* _tmp2_;
	gint _tmp2__length1;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_direct_equal;
	_tmp1_ = vala_array_list_new (VALADOC_API_TYPE_NODE, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, _tmp0_);
	children = _tmp1_;
	_tmp2_ = types;
	_tmp2__length1 = types_length1;
	{
		ValadocApiNodeType* type_collection = NULL;
		gint type_collection_length1 = 0;
		gint _type_collection_size_ = 0;
		gint type_it = 0;
		type_collection = _tmp2_;
		type_collection_length1 = _tmp2__length1;
		for (type_it = 0; type_it < _tmp2__length1; type_it = type_it + 1) {
			ValadocApiNodeType type = 0;
			type = type_collection[type_it];
			{
				ValaArrayList* _tmp3_;
				ValadocApiNodeType _tmp4_;
				gboolean _tmp5_;
				ValaList* _tmp6_;
				ValaList* _tmp7_;
				_tmp3_ = children;
				_tmp4_ = type;
				_tmp5_ = filtered;
				_tmp6_ = valadoc_api_node_get_children_by_type (self, _tmp4_, _tmp5_);
				_tmp7_ = _tmp6_;
				vala_collection_add_all ((ValaCollection*) _tmp3_, (ValaCollection*) _tmp7_);
				_vala_iterable_unref0 (_tmp7_);
			}
		}
	}
	result = (ValaList*) children;
	return result;
}


/**
 * Visits all children of this node with the given type with the specified Visitor.
 *
 * @param type a node type
 * @param visitor the visitor to be called while traversing
 * @param filtered specifies whether nodes which are not browsable should appear in the list
 */
void valadoc_api_node_accept_children_by_type (ValadocApiNode* self, ValadocApiNodeType type, ValadocApiVisitor* visitor, gboolean filtered) {
	ValaList* all_children = NULL;
	ValaMap* _tmp0_;
	ValadocApiNodeType _tmp1_;
	gpointer _tmp2_;
	ValaList* _tmp3_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (visitor != NULL);
	_tmp0_ = self->priv->per_type_children;
	_tmp1_ = type;
	_tmp2_ = vala_map_get (_tmp0_, (gpointer) ((gintptr) _tmp1_));
	all_children = (ValaList*) _tmp2_;
	_tmp3_ = all_children;
	if (_tmp3_ != NULL) {
		{
			ValaList* _node_list = NULL;
			ValaList* _tmp4_;
			ValaList* _tmp5_;
			gint _node_size = 0;
			ValaList* _tmp6_;
			gint _tmp7_;
			gint _tmp8_;
			gint _node_index = 0;
			_tmp4_ = all_children;
			_tmp5_ = _vala_iterable_ref0 (_tmp4_);
			_node_list = _tmp5_;
			_tmp6_ = _node_list;
			_tmp7_ = vala_collection_get_size ((ValaCollection*) _tmp6_);
			_tmp8_ = _tmp7_;
			_node_size = _tmp8_;
			_node_index = -1;
			while (TRUE) {
				gint _tmp9_;
				gint _tmp10_;
				gint _tmp11_;
				ValadocApiNode* node = NULL;
				ValaList* _tmp12_;
				gint _tmp13_;
				gpointer _tmp14_;
				gboolean _tmp15_ = FALSE;
				ValadocApiNode* _tmp16_;
				gboolean _tmp17_;
				_tmp9_ = _node_index;
				_node_index = _tmp9_ + 1;
				_tmp10_ = _node_index;
				_tmp11_ = _node_size;
				if (!(_tmp10_ < _tmp11_)) {
					break;
				}
				_tmp12_ = _node_list;
				_tmp13_ = _node_index;
				_tmp14_ = vala_list_get (_tmp12_, _tmp13_);
				node = (ValadocApiNode*) _tmp14_;
				_tmp16_ = node;
				_tmp17_ = _tmp16_->do_document;
				if (_tmp17_) {
					_tmp15_ = TRUE;
				} else {
					gboolean _tmp18_;
					_tmp18_ = filtered;
					_tmp15_ = !_tmp18_;
				}
				if (_tmp15_) {
					ValadocApiNode* _tmp19_;
					ValadocApiVisitor* _tmp20_;
					_tmp19_ = node;
					_tmp20_ = visitor;
					valadoc_api_node_accept (_tmp19_, _tmp20_);
				}
				_g_object_unref0 (node);
			}
			_vala_iterable_unref0 (_node_list);
		}
	}
	_vala_iterable_unref0 (all_children);
}


/**
 * Visits all children of this node with the given types with the specified Visitor.
 *
 * @param types a list of node types
 * @param visitor the visitor to be called while traversing
 * @param filtered specifies whether nodes which are not browsable should appear in the list
 */
void valadoc_api_node_accept_children (ValadocApiNode* self, ValadocApiNodeType* types, int types_length1, ValadocApiVisitor* visitor, gboolean filtered) {
	ValadocApiNodeType* _tmp0_;
	gint _tmp0__length1;
	g_return_if_fail (self != NULL);
	g_return_if_fail (visitor != NULL);
	_tmp0_ = types;
	_tmp0__length1 = types_length1;
	{
		ValadocApiNodeType* type_collection = NULL;
		gint type_collection_length1 = 0;
		gint _type_collection_size_ = 0;
		gint type_it = 0;
		type_collection = _tmp0_;
		type_collection_length1 = _tmp0__length1;
		for (type_it = 0; type_it < _tmp0__length1; type_it = type_it + 1) {
			ValadocApiNodeType type = 0;
			type = type_collection[type_it];
			{
				ValadocApiNodeType _tmp1_;
				ValadocApiVisitor* _tmp2_;
				gboolean _tmp3_;
				_tmp1_ = type;
				_tmp2_ = visitor;
				_tmp3_ = filtered;
				valadoc_api_node_accept_children_by_type (self, _tmp1_, _tmp2_, _tmp3_);
			}
		}
	}
}


/**
 * Visits all children of this node with the specified Visitor.
 *
 * @param visitor the visitor to be called while traversing
 * @param filtered specifies whether nodes which are not browsable should appear in the list
 */
void valadoc_api_node_accept_all_children (ValadocApiNode* self, ValadocApiVisitor* visitor, gboolean filtered) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (visitor != NULL);
	{
		ValaIterator* _children_it = NULL;
		ValaMap* _tmp0_;
		ValaCollection* _tmp1_;
		ValaCollection* _tmp2_;
		ValaIterator* _tmp3_;
		ValaIterator* _tmp4_;
		_tmp0_ = self->priv->per_type_children;
		_tmp1_ = vala_map_get_values (_tmp0_);
		_tmp2_ = _tmp1_;
		_tmp3_ = vala_iterable_iterator ((ValaIterable*) _tmp2_);
		_tmp4_ = _tmp3_;
		_vala_iterable_unref0 (_tmp2_);
		_children_it = _tmp4_;
		while (TRUE) {
			ValaIterator* _tmp5_;
			gboolean _tmp6_;
			ValaList* children = NULL;
			ValaIterator* _tmp7_;
			gpointer _tmp8_;
			_tmp5_ = _children_it;
			_tmp6_ = vala_iterator_next (_tmp5_);
			if (!_tmp6_) {
				break;
			}
			_tmp7_ = _children_it;
			_tmp8_ = vala_iterator_get (_tmp7_);
			children = (ValaList*) _tmp8_;
			{
				ValaList* _node_list = NULL;
				ValaList* _tmp9_;
				ValaList* _tmp10_;
				gint _node_size = 0;
				ValaList* _tmp11_;
				gint _tmp12_;
				gint _tmp13_;
				gint _node_index = 0;
				_tmp9_ = children;
				_tmp10_ = _vala_iterable_ref0 (_tmp9_);
				_node_list = _tmp10_;
				_tmp11_ = _node_list;
				_tmp12_ = vala_collection_get_size ((ValaCollection*) _tmp11_);
				_tmp13_ = _tmp12_;
				_node_size = _tmp13_;
				_node_index = -1;
				while (TRUE) {
					gint _tmp14_;
					gint _tmp15_;
					gint _tmp16_;
					ValadocApiNode* node = NULL;
					ValaList* _tmp17_;
					gint _tmp18_;
					gpointer _tmp19_;
					gboolean _tmp20_ = FALSE;
					ValadocApiNode* _tmp21_;
					gboolean _tmp22_;
					_tmp14_ = _node_index;
					_node_index = _tmp14_ + 1;
					_tmp15_ = _node_index;
					_tmp16_ = _node_size;
					if (!(_tmp15_ < _tmp16_)) {
						break;
					}
					_tmp17_ = _node_list;
					_tmp18_ = _node_index;
					_tmp19_ = vala_list_get (_tmp17_, _tmp18_);
					node = (ValadocApiNode*) _tmp19_;
					_tmp21_ = node;
					_tmp22_ = _tmp21_->do_document;
					if (_tmp22_) {
						_tmp20_ = TRUE;
					} else {
						gboolean _tmp23_;
						_tmp23_ = filtered;
						_tmp20_ = !_tmp23_;
					}
					if (_tmp20_) {
						ValadocApiNode* _tmp24_;
						ValadocApiVisitor* _tmp25_;
						_tmp24_ = node;
						_tmp25_ = visitor;
						valadoc_api_node_accept (_tmp24_, _tmp25_);
					}
					_g_object_unref0 (node);
				}
				_vala_iterable_unref0 (_node_list);
			}
			_vala_iterable_unref0 (children);
		}
		_vala_iterator_unref0 (_children_it);
	}
}


ValadocApiNode* valadoc_api_node_find_by_name (ValadocApiNode* self, const gchar* name) {
	ValadocApiNode* result = NULL;
	const gchar* _tmp0_;
	gchar _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (name != NULL, NULL);
	_tmp0_ = name;
	_tmp1_ = string_get (_tmp0_, (glong) 0);
	if (_tmp1_ == '@') {
		ValaMap* _tmp2_;
		const gchar* _tmp3_;
		const gchar* _tmp4_;
		gpointer _tmp5_;
		_tmp2_ = self->priv->per_name_children;
		_tmp3_ = name;
		_tmp4_ = g_utf8_next_char (_tmp3_);
		_tmp5_ = vala_map_get (_tmp2_, _tmp4_);
		result = (ValadocApiNode*) _tmp5_;
		return result;
	} else {
		ValaMap* _tmp6_;
		const gchar* _tmp7_;
		gpointer _tmp8_;
		_tmp6_ = self->priv->per_name_children;
		_tmp7_ = name;
		_tmp8_ = vala_map_get (_tmp6_, _tmp7_);
		result = (ValadocApiNode*) _tmp8_;
		return result;
	}
}


/**
 * Returns canonicalized absolute name (GLib.FileStream for instance)
 */
gchar* valadoc_api_node_get_full_name (ValadocApiNode* self) {
	gchar* result = NULL;
	const gchar* _tmp0_;
	const gchar* _tmp25_;
	gchar* _tmp26_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_full_name;
	if (_tmp0_ == NULL) {
		const gchar* _tmp1_;
		GString* full_name = NULL;
		const gchar* _tmp2_;
		GString* _tmp3_;
		ValadocApiItem* _tmp4_;
		ValadocApiItem* _tmp5_;
		GString* _tmp22_;
		const gchar* _tmp23_;
		gchar* _tmp24_;
		_tmp1_ = self->priv->_name;
		if (_tmp1_ == NULL) {
			result = NULL;
			return result;
		}
		_tmp2_ = self->priv->_name;
		_tmp3_ = g_string_new (_tmp2_);
		full_name = _tmp3_;
		_tmp4_ = valadoc_api_item_get_parent ((ValadocApiItem*) self);
		_tmp5_ = _tmp4_;
		if (_tmp5_ != NULL) {
			{
				ValadocApiItem* pos = NULL;
				ValadocApiItem* _tmp6_;
				ValadocApiItem* _tmp7_;
				ValadocApiItem* _tmp8_;
				_tmp6_ = valadoc_api_item_get_parent ((ValadocApiItem*) self);
				_tmp7_ = _tmp6_;
				_tmp8_ = _g_object_ref0 (_tmp7_);
				pos = _tmp8_;
				{
					gboolean _tmp9_ = FALSE;
					_tmp9_ = TRUE;
					while (TRUE) {
						ValadocApiItem* _tmp14_;
						gchar* name = NULL;
						ValadocApiItem* _tmp15_;
						const gchar* _tmp16_;
						gchar* _tmp17_;
						const gchar* _tmp18_;
						if (!_tmp9_) {
							ValadocApiItem* _tmp10_;
							ValadocApiItem* _tmp11_;
							ValadocApiItem* _tmp12_;
							ValadocApiItem* _tmp13_;
							_tmp10_ = pos;
							_tmp11_ = valadoc_api_item_get_parent (_tmp10_);
							_tmp12_ = _tmp11_;
							_tmp13_ = _g_object_ref0 (_tmp12_);
							_g_object_unref0 (pos);
							pos = _tmp13_;
						}
						_tmp9_ = FALSE;
						_tmp14_ = pos;
						if (!(G_TYPE_CHECK_INSTANCE_TYPE (_tmp14_, VALADOC_API_TYPE_PACKAGE) == FALSE)) {
							break;
						}
						_tmp15_ = pos;
						_tmp16_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp15_, VALADOC_API_TYPE_NODE, ValadocApiNode)->priv->_name;
						_tmp17_ = g_strdup (_tmp16_);
						name = _tmp17_;
						_tmp18_ = name;
						if (_tmp18_ != NULL) {
							GString* _tmp19_;
							GString* _tmp20_;
							const gchar* _tmp21_;
							_tmp19_ = full_name;
							g_string_prepend_unichar (_tmp19_, (gunichar) '.');
							_tmp20_ = full_name;
							_tmp21_ = name;
							g_string_prepend (_tmp20_, _tmp21_);
						}
						_g_free0 (name);
					}
				}
				_g_object_unref0 (pos);
			}
		}
		_tmp22_ = full_name;
		_tmp23_ = _tmp22_->str;
		_tmp24_ = g_strdup (_tmp23_);
		_g_free0 (self->priv->_full_name);
		self->priv->_full_name = _tmp24_;
		_g_string_free0 (full_name);
	}
	_tmp25_ = self->priv->_full_name;
	_tmp26_ = g_strdup (_tmp25_);
	result = _tmp26_;
	return result;
}


/**
 * A comparison function used to sort nodes in alphabetical order
 */
gint valadoc_api_node_compare_to (ValadocApiNode* self, ValadocApiNode* node) {
	gint result = 0;
	GCompareFunc _tmp0_;
	const gchar* _tmp1_;
	ValadocApiNode* _tmp2_;
	const gchar* _tmp3_;
	gint _tmp4_;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (node != NULL, 0);
	_tmp0_ = g_strcmp0;
	_tmp1_ = self->priv->_name;
	_tmp2_ = node;
	_tmp3_ = _tmp2_->priv->_name;
	_tmp4_ = _tmp0_ (_tmp1_, _tmp3_);
	result = _tmp4_;
	return result;
}


static gboolean valadoc_api_node_is_keyword (ValadocApiNode* self, const gchar* name) {
	gboolean result = FALSE;
	const gchar* _tmp0_;
	gchar _tmp1_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (name != NULL, FALSE);
	_tmp0_ = name;
	_tmp1_ = string_get (_tmp0_, (glong) 0);
	switch (_tmp1_) {
		case 'a':
		{
			const gchar* _tmp2_;
			gchar _tmp3_;
			_tmp2_ = name;
			_tmp3_ = string_get (_tmp2_, (glong) 1);
			switch (_tmp3_) {
				case 'b':
				{
					const gchar* _tmp4_;
					_tmp4_ = name;
					result = g_strcmp0 (_tmp4_, "abstract") == 0;
					return result;
				}
				case 's':
				{
					const gchar* _tmp5_;
					gchar _tmp6_;
					const gchar* _tmp7_;
					_tmp5_ = name;
					_tmp6_ = string_get (_tmp5_, (glong) 2);
					if (_tmp6_ == '\0') {
						result = TRUE;
						return result;
					}
					_tmp7_ = name;
					result = g_strcmp0 (_tmp7_, "async") == 0;
					return result;
				}
				default:
				break;
			}
			break;
		}
		case 'b':
		{
			const gchar* _tmp8_;
			gchar _tmp9_;
			_tmp8_ = name;
			_tmp9_ = string_get (_tmp8_, (glong) 1);
			switch (_tmp9_) {
				case 'a':
				{
					const gchar* _tmp10_;
					_tmp10_ = name;
					result = g_strcmp0 (_tmp10_, "base") == 0;
					return result;
				}
				case 'r':
				{
					const gchar* _tmp11_;
					_tmp11_ = name;
					result = g_strcmp0 (_tmp11_, "break") == 0;
					return result;
				}
				default:
				break;
			}
			break;
		}
		case 'c':
		{
			const gchar* _tmp12_;
			gchar _tmp13_;
			_tmp12_ = name;
			_tmp13_ = string_get (_tmp12_, (glong) 1);
			switch (_tmp13_) {
				case 'a':
				{
					const gchar* _tmp14_;
					gchar _tmp15_;
					_tmp14_ = name;
					_tmp15_ = string_get (_tmp14_, (glong) 2);
					switch (_tmp15_) {
						case 's':
						{
							const gchar* _tmp16_;
							_tmp16_ = name;
							result = g_strcmp0 (_tmp16_, "case") == 0;
							return result;
						}
						case 't':
						{
							const gchar* _tmp17_;
							_tmp17_ = name;
							result = g_strcmp0 (_tmp17_, "catch") == 0;
							return result;
						}
						default:
						break;
					}
					break;
				}
				case 'l':
				{
					const gchar* _tmp18_;
					_tmp18_ = name;
					result = g_strcmp0 (_tmp18_, "class") == 0;
					return result;
				}
				case 'o':
				{
					const gchar* _tmp19_;
					gchar _tmp20_;
					const gchar* _tmp21_;
					gchar _tmp22_;
					_tmp19_ = name;
					_tmp20_ = string_get (_tmp19_, (glong) 2);
					if (_tmp20_ != 'n') {
						result = FALSE;
						return result;
					}
					_tmp21_ = name;
					_tmp22_ = string_get (_tmp21_, (glong) 3);
					switch (_tmp22_) {
						case 's':
						{
							const gchar* _tmp23_;
							gchar _tmp24_;
							_tmp23_ = name;
							_tmp24_ = string_get (_tmp23_, (glong) 4);
							if (_tmp24_ == 't') {
								const gchar* _tmp25_;
								gchar _tmp26_;
								_tmp25_ = name;
								_tmp26_ = string_get (_tmp25_, (glong) 5);
								switch (_tmp26_) {
									case '\0':
									{
										result = TRUE;
										return result;
									}
									case 'r':
									{
										const gchar* _tmp27_;
										_tmp27_ = name;
										result = g_strcmp0 (_tmp27_, "construct") == 0;
										return result;
									}
									default:
									break;
								}
							}
							break;
						}
						case 't':
						{
							const gchar* _tmp28_;
							_tmp28_ = name;
							result = g_strcmp0 (_tmp28_, "continue") == 0;
							return result;
						}
						default:
						break;
					}
					break;
				}
				default:
				break;
			}
			break;
		}
		case 'd':
		{
			const gchar* _tmp29_;
			gchar _tmp30_;
			_tmp29_ = name;
			_tmp30_ = string_get (_tmp29_, (glong) 1);
			switch (_tmp30_) {
				case 'e':
				{
					const gchar* _tmp31_;
					gchar _tmp32_;
					_tmp31_ = name;
					_tmp32_ = string_get (_tmp31_, (glong) 2);
					switch (_tmp32_) {
						case 'f':
						{
							const gchar* _tmp33_;
							_tmp33_ = name;
							result = g_strcmp0 (_tmp33_, "default") == 0;
							return result;
						}
						case 'l':
						{
							const gchar* _tmp34_;
							gchar _tmp35_;
							const gchar* _tmp36_;
							gchar _tmp37_;
							_tmp34_ = name;
							_tmp35_ = string_get (_tmp34_, (glong) 3);
							if (_tmp35_ != 'e') {
								result = FALSE;
								return result;
							}
							_tmp36_ = name;
							_tmp37_ = string_get (_tmp36_, (glong) 4);
							switch (_tmp37_) {
								case 'g':
								{
									const gchar* _tmp38_;
									_tmp38_ = name;
									result = g_strcmp0 (_tmp38_, "delegate") == 0;
									return result;
								}
								case 't':
								{
									const gchar* _tmp39_;
									_tmp39_ = name;
									result = g_strcmp0 (_tmp39_, "delete") == 0;
									return result;
								}
								default:
								break;
							}
							break;
						}
						default:
						break;
					}
					break;
				}
				case 'o':
				{
					const gchar* _tmp40_;
					gchar _tmp41_;
					_tmp40_ = name;
					_tmp41_ = string_get (_tmp40_, (glong) 2);
					result = _tmp41_ == '\0';
					return result;
				}
				case 'y':
				{
					const gchar* _tmp42_;
					_tmp42_ = name;
					result = g_strcmp0 (_tmp42_, "dynamic") == 0;
					return result;
				}
				default:
				break;
			}
			break;
		}
		case 'e':
		{
			const gchar* _tmp43_;
			gchar _tmp44_;
			_tmp43_ = name;
			_tmp44_ = string_get (_tmp43_, (glong) 1);
			switch (_tmp44_) {
				case 'l':
				{
					const gchar* _tmp45_;
					_tmp45_ = name;
					result = g_strcmp0 (_tmp45_, "else") == 0;
					return result;
				}
				case 'n':
				{
					const gchar* _tmp46_;
					gchar _tmp47_;
					_tmp46_ = name;
					_tmp47_ = string_get (_tmp46_, (glong) 2);
					switch (_tmp47_) {
						case 's':
						{
							const gchar* _tmp48_;
							_tmp48_ = name;
							result = g_strcmp0 (_tmp48_, "ensures") == 0;
							return result;
						}
						case 'u':
						{
							const gchar* _tmp49_;
							_tmp49_ = name;
							result = g_strcmp0 (_tmp49_, "enum") == 0;
							return result;
						}
						default:
						break;
					}
					break;
				}
				case 'r':
				{
					const gchar* _tmp50_;
					_tmp50_ = name;
					result = g_strcmp0 (_tmp50_, "errordomain") == 0;
					return result;
				}
				case 'x':
				{
					const gchar* _tmp51_;
					_tmp51_ = name;
					result = g_strcmp0 (_tmp51_, "extern") == 0;
					return result;
				}
				default:
				break;
			}
			break;
		}
		case 'f':
		{
			const gchar* _tmp52_;
			gchar _tmp53_;
			_tmp52_ = name;
			_tmp53_ = string_get (_tmp52_, (glong) 1);
			switch (_tmp53_) {
				case 'a':
				{
					const gchar* _tmp54_;
					_tmp54_ = name;
					result = g_strcmp0 (_tmp54_, "false") == 0;
					return result;
				}
				case 'i':
				{
					const gchar* _tmp55_;
					_tmp55_ = name;
					result = g_strcmp0 (_tmp55_, "finally") == 0;
					return result;
				}
				case 'o':
				{
					const gchar* _tmp56_;
					gchar _tmp57_;
					const gchar* _tmp58_;
					gchar _tmp59_;
					_tmp56_ = name;
					_tmp57_ = string_get (_tmp56_, (glong) 2);
					if (_tmp57_ != 'r') {
						result = FALSE;
						return result;
					}
					_tmp58_ = name;
					_tmp59_ = string_get (_tmp58_, (glong) 3);
					switch (_tmp59_) {
						case '\0':
						{
							result = TRUE;
							return result;
						}
						case 'e':
						{
							const gchar* _tmp60_;
							_tmp60_ = name;
							result = g_strcmp0 (_tmp60_, "foreach") == 0;
							return result;
						}
						default:
						break;
					}
					break;
				}
				default:
				break;
			}
			break;
		}
		case 'g':
		{
			const gchar* _tmp61_;
			_tmp61_ = name;
			result = g_strcmp0 (_tmp61_, "get") == 0;
			return result;
		}
		case 'i':
		{
			const gchar* _tmp62_;
			gchar _tmp63_;
			_tmp62_ = name;
			_tmp63_ = string_get (_tmp62_, (glong) 1);
			switch (_tmp63_) {
				case 'f':
				{
					const gchar* _tmp64_;
					gchar _tmp65_;
					_tmp64_ = name;
					_tmp65_ = string_get (_tmp64_, (glong) 2);
					result = _tmp65_ == '\0';
					return result;
				}
				case 'n':
				{
					const gchar* _tmp66_;
					gchar _tmp67_;
					_tmp66_ = name;
					_tmp67_ = string_get (_tmp66_, (glong) 2);
					switch (_tmp67_) {
						case '\0':
						{
							result = TRUE;
							return result;
						}
						case 'l':
						{
							const gchar* _tmp68_;
							_tmp68_ = name;
							result = g_strcmp0 (_tmp68_, "inline") == 0;
							return result;
						}
						case 't':
						{
							gboolean _tmp69_ = FALSE;
							const gchar* _tmp70_;
							_tmp70_ = name;
							if (g_strcmp0 (_tmp70_, "interface") == 0) {
								_tmp69_ = TRUE;
							} else {
								const gchar* _tmp71_;
								_tmp71_ = name;
								_tmp69_ = g_strcmp0 (_tmp71_, "internal") == 0;
							}
							result = _tmp69_;
							return result;
						}
						default:
						break;
					}
					break;
				}
				case 's':
				{
					const gchar* _tmp72_;
					gchar _tmp73_;
					_tmp72_ = name;
					_tmp73_ = string_get (_tmp72_, (glong) 2);
					result = _tmp73_ == '\0';
					return result;
				}
				default:
				break;
			}
			break;
		}
		case 'l':
		{
			const gchar* _tmp74_;
			_tmp74_ = name;
			result = g_strcmp0 (_tmp74_, "lock") == 0;
			return result;
		}
		case 'n':
		{
			const gchar* _tmp75_;
			gchar _tmp76_;
			_tmp75_ = name;
			_tmp76_ = string_get (_tmp75_, (glong) 1);
			switch (_tmp76_) {
				case 'a':
				{
					const gchar* _tmp77_;
					_tmp77_ = name;
					result = g_strcmp0 (_tmp77_, "namespace") == 0;
					return result;
				}
				case 'e':
				{
					const gchar* _tmp78_;
					_tmp78_ = name;
					result = g_strcmp0 (_tmp78_, "new") == 0;
					return result;
				}
				case 'u':
				{
					const gchar* _tmp79_;
					_tmp79_ = name;
					result = g_strcmp0 (_tmp79_, "null") == 0;
					return result;
				}
				default:
				break;
			}
			break;
		}
		case 'o':
		{
			const gchar* _tmp80_;
			gchar _tmp81_;
			_tmp80_ = name;
			_tmp81_ = string_get (_tmp80_, (glong) 1);
			switch (_tmp81_) {
				case 'u':
				{
					const gchar* _tmp82_;
					_tmp82_ = name;
					result = g_strcmp0 (_tmp82_, "out") == 0;
					return result;
				}
				case 'v':
				{
					const gchar* _tmp83_;
					_tmp83_ = name;
					result = g_strcmp0 (_tmp83_, "override") == 0;
					return result;
				}
				case 'w':
				{
					const gchar* _tmp84_;
					_tmp84_ = name;
					result = g_strcmp0 (_tmp84_, "owned") == 0;
					return result;
				}
				default:
				break;
			}
			break;
		}
		case 'p':
		{
			const gchar* _tmp85_;
			gchar _tmp86_;
			_tmp85_ = name;
			_tmp86_ = string_get (_tmp85_, (glong) 1);
			switch (_tmp86_) {
				case 'a':
				{
					const gchar* _tmp87_;
					_tmp87_ = name;
					result = g_strcmp0 (_tmp87_, "params") == 0;
					return result;
				}
				case 'r':
				{
					const gchar* _tmp88_;
					gchar _tmp89_;
					_tmp88_ = name;
					_tmp89_ = string_get (_tmp88_, (glong) 2);
					switch (_tmp89_) {
						case 'i':
						{
							const gchar* _tmp90_;
							_tmp90_ = name;
							result = g_strcmp0 (_tmp90_, "private") == 0;
							return result;
						}
						case 'o':
						{
							const gchar* _tmp91_;
							_tmp91_ = name;
							result = g_strcmp0 (_tmp91_, "protected") == 0;
							return result;
						}
						default:
						break;
					}
					break;
				}
				case 'u':
				{
					const gchar* _tmp92_;
					_tmp92_ = name;
					result = g_strcmp0 (_tmp92_, "public") == 0;
					return result;
				}
				default:
				break;
			}
			break;
		}
		case 'r':
		{
			const gchar* _tmp93_;
			gchar _tmp94_;
			const gchar* _tmp95_;
			gchar _tmp96_;
			_tmp93_ = name;
			_tmp94_ = string_get (_tmp93_, (glong) 1);
			if (_tmp94_ != 'e') {
				result = FALSE;
				return result;
			}
			_tmp95_ = name;
			_tmp96_ = string_get (_tmp95_, (glong) 2);
			switch (_tmp96_) {
				case 'f':
				{
					const gchar* _tmp97_;
					gchar _tmp98_;
					_tmp97_ = name;
					_tmp98_ = string_get (_tmp97_, (glong) 3);
					result = _tmp98_ == '\0';
					return result;
				}
				case 'q':
				{
					const gchar* _tmp99_;
					_tmp99_ = name;
					result = g_strcmp0 (_tmp99_, "requires") == 0;
					return result;
				}
				case 't':
				{
					const gchar* _tmp100_;
					_tmp100_ = name;
					result = g_strcmp0 (_tmp100_, "return") == 0;
					return result;
				}
				default:
				break;
			}
			break;
		}
		case 's':
		{
			const gchar* _tmp101_;
			gchar _tmp102_;
			_tmp101_ = name;
			_tmp102_ = string_get (_tmp101_, (glong) 1);
			switch (_tmp102_) {
				case 'e':
				{
					const gchar* _tmp103_;
					gchar _tmp104_;
					_tmp103_ = name;
					_tmp104_ = string_get (_tmp103_, (glong) 2);
					switch (_tmp104_) {
						case 'a':
						{
							const gchar* _tmp105_;
							_tmp105_ = name;
							result = g_strcmp0 (_tmp105_, "sealed") == 0;
							return result;
						}
						case 't':
						{
							const gchar* _tmp106_;
							gchar _tmp107_;
							_tmp106_ = name;
							_tmp107_ = string_get (_tmp106_, (glong) 3);
							result = _tmp107_ == '\0';
							return result;
						}
						default:
						break;
					}
					break;
				}
				case 'i':
				{
					const gchar* _tmp108_;
					gchar _tmp109_;
					_tmp108_ = name;
					_tmp109_ = string_get (_tmp108_, (glong) 2);
					switch (_tmp109_) {
						case 'g':
						{
							const gchar* _tmp110_;
							_tmp110_ = name;
							result = g_strcmp0 (_tmp110_, "signal") == 0;
							return result;
						}
						case 'z':
						{
							const gchar* _tmp111_;
							_tmp111_ = name;
							result = g_strcmp0 (_tmp111_, "sizeof") == 0;
							return result;
						}
						default:
						break;
					}
					break;
				}
				case 't':
				{
					const gchar* _tmp112_;
					gchar _tmp113_;
					_tmp112_ = name;
					_tmp113_ = string_get (_tmp112_, (glong) 2);
					switch (_tmp113_) {
						case 'a':
						{
							const gchar* _tmp114_;
							_tmp114_ = name;
							result = g_strcmp0 (_tmp114_, "static") == 0;
							return result;
						}
						case 'r':
						{
							const gchar* _tmp115_;
							_tmp115_ = name;
							result = g_strcmp0 (_tmp115_, "struct") == 0;
							return result;
						}
						default:
						break;
					}
					break;
				}
				case 'w':
				{
					const gchar* _tmp116_;
					_tmp116_ = name;
					result = g_strcmp0 (_tmp116_, "switch") == 0;
					return result;
				}
				default:
				break;
			}
			break;
		}
		case 't':
		{
			const gchar* _tmp117_;
			gchar _tmp118_;
			_tmp117_ = name;
			_tmp118_ = string_get (_tmp117_, (glong) 1);
			switch (_tmp118_) {
				case 'h':
				{
					const gchar* _tmp119_;
					gchar _tmp120_;
					_tmp119_ = name;
					_tmp120_ = string_get (_tmp119_, (glong) 2);
					switch (_tmp120_) {
						case 'i':
						{
							const gchar* _tmp121_;
							_tmp121_ = name;
							result = g_strcmp0 (_tmp121_, "this") == 0;
							return result;
						}
						case 'r':
						{
							gboolean _tmp122_ = FALSE;
							const gchar* _tmp123_;
							gchar _tmp124_;
							_tmp123_ = name;
							_tmp124_ = string_get (_tmp123_, (glong) 3);
							if (_tmp124_ == 'o') {
								const gchar* _tmp125_;
								gchar _tmp126_;
								_tmp125_ = name;
								_tmp126_ = string_get (_tmp125_, (glong) 4);
								_tmp122_ = _tmp126_ == 'w';
							} else {
								_tmp122_ = FALSE;
							}
							if (_tmp122_) {
								gboolean _tmp127_ = FALSE;
								const gchar* _tmp128_;
								gchar _tmp129_;
								_tmp128_ = name;
								_tmp129_ = string_get (_tmp128_, (glong) 5);
								if (_tmp129_ == '\0') {
									_tmp127_ = TRUE;
								} else {
									gboolean _tmp130_ = FALSE;
									const gchar* _tmp131_;
									gchar _tmp132_;
									_tmp131_ = name;
									_tmp132_ = string_get (_tmp131_, (glong) 5);
									if (_tmp132_ == 's') {
										const gchar* _tmp133_;
										gchar _tmp134_;
										_tmp133_ = name;
										_tmp134_ = string_get (_tmp133_, (glong) 6);
										_tmp130_ = _tmp134_ == '\0';
									} else {
										_tmp130_ = FALSE;
									}
									_tmp127_ = _tmp130_;
								}
								result = _tmp127_;
								return result;
							}
							break;
						}
						default:
						break;
					}
					break;
				}
				case 'r':
				{
					const gchar* _tmp135_;
					gchar _tmp136_;
					_tmp135_ = name;
					_tmp136_ = string_get (_tmp135_, (glong) 2);
					switch (_tmp136_) {
						case 'u':
						{
							const gchar* _tmp137_;
							_tmp137_ = name;
							result = g_strcmp0 (_tmp137_, "true") == 0;
							return result;
						}
						case 'y':
						{
							const gchar* _tmp138_;
							gchar _tmp139_;
							_tmp138_ = name;
							_tmp139_ = string_get (_tmp138_, (glong) 3);
							result = _tmp139_ == '\0';
							return result;
						}
						default:
						break;
					}
					break;
				}
				case 'y':
				{
					const gchar* _tmp140_;
					_tmp140_ = name;
					result = g_strcmp0 (_tmp140_, "typeof") == 0;
					return result;
				}
				default:
				break;
			}
			break;
		}
		case 'u':
		{
			const gchar* _tmp141_;
			gchar _tmp142_;
			_tmp141_ = name;
			_tmp142_ = string_get (_tmp141_, (glong) 1);
			switch (_tmp142_) {
				case 'n':
				{
					const gchar* _tmp143_;
					_tmp143_ = name;
					result = g_strcmp0 (_tmp143_, "unowned") == 0;
					return result;
				}
				case 's':
				{
					const gchar* _tmp144_;
					_tmp144_ = name;
					result = g_strcmp0 (_tmp144_, "using") == 0;
					return result;
				}
				default:
				break;
			}
			break;
		}
		case 'v':
		{
			const gchar* _tmp145_;
			gchar _tmp146_;
			_tmp145_ = name;
			_tmp146_ = string_get (_tmp145_, (glong) 1);
			switch (_tmp146_) {
				case 'a':
				{
					const gchar* _tmp147_;
					_tmp147_ = name;
					result = g_strcmp0 (_tmp147_, "var") == 0;
					return result;
				}
				case 'i':
				{
					const gchar* _tmp148_;
					_tmp148_ = name;
					result = g_strcmp0 (_tmp148_, "virtual") == 0;
					return result;
				}
				case 'o':
				{
					const gchar* _tmp149_;
					gchar _tmp150_;
					_tmp149_ = name;
					_tmp150_ = string_get (_tmp149_, (glong) 2);
					switch (_tmp150_) {
						case 'i':
						{
							const gchar* _tmp151_;
							_tmp151_ = name;
							result = g_strcmp0 (_tmp151_, "void") == 0;
							return result;
						}
						case 'l':
						{
							const gchar* _tmp152_;
							_tmp152_ = name;
							result = g_strcmp0 (_tmp152_, "volatile") == 0;
							return result;
						}
						default:
						break;
					}
					break;
				}
				default:
				break;
			}
			break;
		}
		case 'w':
		{
			const gchar* _tmp153_;
			gchar _tmp154_;
			_tmp153_ = name;
			_tmp154_ = string_get (_tmp153_, (glong) 1);
			switch (_tmp154_) {
				case 'e':
				{
					const gchar* _tmp155_;
					_tmp155_ = name;
					result = g_strcmp0 (_tmp155_, "weak") == 0;
					return result;
				}
				case 'h':
				{
					const gchar* _tmp156_;
					_tmp156_ = name;
					result = g_strcmp0 (_tmp156_, "while") == 0;
					return result;
				}
				default:
				break;
			}
			break;
		}
		case 'y':
		{
			const gchar* _tmp157_;
			_tmp157_ = name;
			result = g_strcmp0 (_tmp157_, "yield") == 0;
			return result;
		}
		default:
		break;
	}
	result = FALSE;
	return result;
}


const gchar* valadoc_api_node_get_name (ValadocApiNode* self) {
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_name;
	result = _tmp0_;
	return result;
}


static void valadoc_api_node_set_name (ValadocApiNode* self, const gchar* value) {
	g_return_if_fail (self != NULL);
	if (g_strcmp0 (value, valadoc_api_node_get_name (self)) != 0) {
		const gchar* _tmp0_;
		gchar* _tmp1_;
		_tmp0_ = value;
		_tmp1_ = g_strdup (_tmp0_);
		_g_free0 (self->priv->_name);
		self->priv->_name = _tmp1_;
		g_object_notify_by_pspec ((GObject *) self, valadoc_api_node_properties[VALADOC_API_NODE_NAME_PROPERTY]);
	}
}


ValadocApiNodeType valadoc_api_node_get_node_type (ValadocApiNode* self) {
	g_return_val_if_fail (self != NULL, 0);
	return VALADOC_API_NODE_GET_CLASS (self)->get_node_type (self);
}


ValadocApiNamespace* valadoc_api_node_get_nspace (ValadocApiNode* self) {
	ValadocApiNamespace* result;
	ValadocApiNamespace* _tmp0_;
	ValadocApiNamespace* _tmp10_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_nspace;
	if (_tmp0_ == NULL) {
		ValadocApiItem* ast = NULL;
		ValadocApiItem* _tmp1_;
		ValadocApiItem* _tmp8_;
		ValadocApiNamespace* _tmp9_;
		_tmp1_ = _g_object_ref0 ((ValadocApiItem*) self);
		ast = _tmp1_;
		while (TRUE) {
			ValadocApiItem* _tmp2_;
			ValadocApiItem* _tmp3_;
			ValadocApiItem* _tmp4_;
			ValadocApiItem* _tmp5_;
			ValadocApiItem* _tmp6_;
			ValadocApiItem* _tmp7_;
			_tmp2_ = ast;
			if (!(G_TYPE_CHECK_INSTANCE_TYPE (_tmp2_, VALADOC_API_TYPE_NAMESPACE) == FALSE)) {
				break;
			}
			_tmp3_ = ast;
			_tmp4_ = valadoc_api_item_get_parent (_tmp3_);
			_tmp5_ = _tmp4_;
			_tmp6_ = _g_object_ref0 (_tmp5_);
			_g_object_unref0 (ast);
			ast = _tmp6_;
			_tmp7_ = ast;
			if (_tmp7_ == NULL) {
				result = NULL;
				_g_object_unref0 (ast);
				return result;
			}
		}
		_tmp8_ = ast;
		_tmp9_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, VALADOC_API_TYPE_NAMESPACE, ValadocApiNamespace));
		_g_object_unref0 (self->priv->_nspace);
		self->priv->_nspace = _tmp9_;
		_g_object_unref0 (ast);
	}
	_tmp10_ = self->priv->_nspace;
	result = _tmp10_;
	return result;
}


static ValadocApiPackage* valadoc_api_node_real_get_package (ValadocDocumentation* base) {
	ValadocApiPackage* result;
	ValadocApiNode* self;
	ValadocApiPackage* _tmp0_;
	ValadocApiPackage* _tmp10_;
	self = (ValadocApiNode*) base;
	_tmp0_ = self->priv->_package;
	if (_tmp0_ == NULL) {
		ValadocApiItem* ast = NULL;
		ValadocApiItem* _tmp1_;
		ValadocApiItem* _tmp8_;
		ValadocApiPackage* _tmp9_;
		_tmp1_ = _g_object_ref0 ((ValadocApiItem*) self);
		ast = _tmp1_;
		while (TRUE) {
			ValadocApiItem* _tmp2_;
			ValadocApiItem* _tmp3_;
			ValadocApiItem* _tmp4_;
			ValadocApiItem* _tmp5_;
			ValadocApiItem* _tmp6_;
			ValadocApiItem* _tmp7_;
			_tmp2_ = ast;
			if (!(G_TYPE_CHECK_INSTANCE_TYPE (_tmp2_, VALADOC_API_TYPE_PACKAGE) == FALSE)) {
				break;
			}
			_tmp3_ = ast;
			_tmp4_ = valadoc_api_item_get_parent (_tmp3_);
			_tmp5_ = _tmp4_;
			_tmp6_ = _g_object_ref0 (_tmp5_);
			_g_object_unref0 (ast);
			ast = _tmp6_;
			_tmp7_ = ast;
			if (_tmp7_ == NULL) {
				result = NULL;
				_g_object_unref0 (ast);
				return result;
			}
		}
		_tmp8_ = ast;
		_tmp9_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, VALADOC_API_TYPE_PACKAGE, ValadocApiPackage));
		_g_object_unref0 (self->priv->_package);
		self->priv->_package = _tmp9_;
		_g_object_unref0 (ast);
	}
	_tmp10_ = self->priv->_package;
	result = _tmp10_;
	return result;
}


ValadocContentComment* valadoc_api_node_get_documentation (ValadocApiNode* self) {
	ValadocContentComment* result;
	ValadocContentComment* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_documentation;
	result = _tmp0_;
	return result;
}


G_GNUC_INTERNAL void valadoc_api_node_set_documentation (ValadocApiNode* self, ValadocContentComment* value) {
	g_return_if_fail (self != NULL);
	if (valadoc_api_node_get_documentation (self) != value) {
		ValadocContentComment* _tmp0_;
		ValadocContentComment* _tmp1_;
		_tmp0_ = value;
		_tmp1_ = _g_object_ref0 (_tmp0_);
		_g_object_unref0 (self->priv->_documentation);
		self->priv->_documentation = _tmp1_;
		g_object_notify_by_pspec ((GObject *) self, valadoc_api_node_properties[VALADOC_API_NODE_DOCUMENTATION_PROPERTY]);
	}
}


static void valadoc_api_node_class_init (ValadocApiNodeClass * klass) {
	valadoc_api_node_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (ValadocApiNodePrivate));
	((ValadocApiNodeClass *) klass)->accept = (void (*) (ValadocApiNode *, ValadocApiVisitor*)) valadoc_api_node_real_accept;
	((ValadocApiNodeClass *) klass)->is_browsable = (gboolean (*) (ValadocApiNode *, ValadocSettings*)) valadoc_api_node_real_is_browsable;
	((ValadocApiItemClass *) klass)->parse_comments = (void (*) (ValadocApiItem *, ValadocSettings*, ValadocDocumentationParser*)) valadoc_api_node_real_parse_comments;
	((ValadocApiItemClass *) klass)->check_comments = (void (*) (ValadocApiItem *, ValadocSettings*, ValadocDocumentationParser*)) valadoc_api_node_real_check_comments;
	G_OBJECT_CLASS (klass)->get_property = _vala_valadoc_api_node_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_valadoc_api_node_set_property;
	G_OBJECT_CLASS (klass)->finalize = valadoc_api_node_finalize;
	/**
	 * The name of the node
	 */
	g_object_class_install_property (G_OBJECT_CLASS (klass), VALADOC_API_NODE_NAME_PROPERTY, valadoc_api_node_properties[VALADOC_API_NODE_NAME_PROPERTY] = g_param_spec_string ("name", "name", "name", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	/**
	 * Returns the type of this node
	 */
	g_object_class_install_property (G_OBJECT_CLASS (klass), VALADOC_API_NODE_NODE_TYPE_PROPERTY, valadoc_api_node_properties[VALADOC_API_NODE_NODE_TYPE_PROPERTY] = g_param_spec_enum ("node-type", "node-type", "node-type", VALADOC_API_TYPE_NODE_TYPE, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	/**
	 * The corresponding namespace
	 */
	g_object_class_install_property (G_OBJECT_CLASS (klass), VALADOC_API_NODE_NSPACE_PROPERTY, valadoc_api_node_properties[VALADOC_API_NODE_NSPACE_PROPERTY] = g_param_spec_object ("nspace", "nspace", "nspace", VALADOC_API_TYPE_NAMESPACE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	/**
	 * The corresponding package such as a vapi or gir file
	 */
	g_object_class_install_property (G_OBJECT_CLASS (klass), VALADOC_API_NODE_PACKAGE_PROPERTY, valadoc_api_node_properties[VALADOC_API_NODE_PACKAGE_PROPERTY] = g_param_spec_object ("package", "package", "package", VALADOC_API_TYPE_PACKAGE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), VALADOC_API_NODE_DOCUMENTATION_PROPERTY, valadoc_api_node_properties[VALADOC_API_NODE_DOCUMENTATION_PROPERTY] = g_param_spec_object ("documentation", "documentation", "documentation", VALADOC_CONTENT_TYPE_COMMENT, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
}


static void valadoc_api_node_valadoc_api_browsable_interface_init (ValadocApiBrowsableIface * iface) {
	valadoc_api_node_valadoc_api_browsable_parent_iface = g_type_interface_peek_parent (iface);
	iface->is_browsable = (gboolean (*) (ValadocApiBrowsable *, ValadocSettings*)) valadoc_api_node_is_browsable;
}


static void valadoc_api_node_valadoc_documentation_interface_init (ValadocDocumentationIface * iface) {
	valadoc_api_node_valadoc_documentation_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_filename = (gchar* (*) (ValadocDocumentation *)) valadoc_api_node_real_get_filename;
	iface->get_package = valadoc_api_node_real_get_package;
}


static void valadoc_api_node_instance_init (ValadocApiNode * self) {
	self->priv = VALADOC_API_NODE_GET_PRIVATE (self);
	self->do_document = FALSE;
	self->priv->_nspace = NULL;
	self->priv->_package = NULL;
	self->priv->_full_name = NULL;
}


static void valadoc_api_node_finalize (GObject * obj) {
	ValadocApiNode * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALADOC_API_TYPE_NODE, ValadocApiNode);
	_g_object_unref0 (self->priv->file);
	_g_free0 (self->priv->_name);
	_vala_map_unref0 (self->priv->per_name_children);
	_vala_map_unref0 (self->priv->per_type_children);
	_g_object_unref0 (self->priv->_nspace);
	_g_object_unref0 (self->priv->_package);
	_g_free0 (self->priv->_full_name);
	_g_object_unref0 (self->priv->_documentation);
	G_OBJECT_CLASS (valadoc_api_node_parent_class)->finalize (obj);
}


/**
 * Represents a node in the api tree.
 */
GType valadoc_api_node_get_type (void) {
	static volatile gsize valadoc_api_node_type_id__volatile = 0;
	if (g_once_init_enter (&valadoc_api_node_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValadocApiNodeClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) valadoc_api_node_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValadocApiNode), 0, (GInstanceInitFunc) valadoc_api_node_instance_init, NULL };
		static const GInterfaceInfo valadoc_api_browsable_info = { (GInterfaceInitFunc) valadoc_api_node_valadoc_api_browsable_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		static const GInterfaceInfo valadoc_documentation_info = { (GInterfaceInitFunc) valadoc_api_node_valadoc_documentation_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType valadoc_api_node_type_id;
		valadoc_api_node_type_id = g_type_register_static (VALADOC_API_TYPE_ITEM, "ValadocApiNode", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
		g_type_add_interface_static (valadoc_api_node_type_id, VALADOC_API_TYPE_BROWSABLE, &valadoc_api_browsable_info);
		g_type_add_interface_static (valadoc_api_node_type_id, VALADOC_TYPE_DOCUMENTATION, &valadoc_documentation_info);
		g_once_init_leave (&valadoc_api_node_type_id__volatile, valadoc_api_node_type_id);
	}
	return valadoc_api_node_type_id__volatile;
}


static void _vala_valadoc_api_node_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	ValadocApiNode * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, VALADOC_API_TYPE_NODE, ValadocApiNode);
	switch (property_id) {
		case VALADOC_API_NODE_NAME_PROPERTY:
		g_value_set_string (value, valadoc_api_node_get_name (self));
		break;
		case VALADOC_API_NODE_NSPACE_PROPERTY:
		g_value_set_object (value, valadoc_api_node_get_nspace (self));
		break;
		case VALADOC_API_NODE_PACKAGE_PROPERTY:
		g_value_set_object (value, valadoc_documentation_get_package ((ValadocDocumentation*) self));
		break;
		case VALADOC_API_NODE_DOCUMENTATION_PROPERTY:
		g_value_set_object (value, valadoc_api_node_get_documentation (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_valadoc_api_node_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	ValadocApiNode * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, VALADOC_API_TYPE_NODE, ValadocApiNode);
	switch (property_id) {
		case VALADOC_API_NODE_NAME_PROPERTY:
		valadoc_api_node_set_name (self, g_value_get_string (value));
		break;
		case VALADOC_API_NODE_DOCUMENTATION_PROPERTY:
		valadoc_api_node_set_documentation (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}



