/*
 * Java-Gnome Bindings Library
 *
 * Copyright 1998-2004 the Java-Gnome Team, all rights reserved.
 *
 * The Java-Gnome bindings library is free software distributed under
 * the terms of the GNU Library General Public License version 2.
 */

package org.gnu.pango;
import org.gnu.glib.Enum;

/**
 * The PangoUnderline enumeration is used to specify whether text should be
 * underlined, and if so, the type of underlining.
 */
public class Underline extends Enum 
{
    /****************************************
     * BEGINNING OF GENERATED CODE
     ****************************************/
    static final private int _NONE = 0;
	/** no underline should be drawn. */
    static final public org.gnu.pango.Underline NONE = new org.gnu.pango.Underline (_NONE);
    static final private int _SINGLE = 1;
	/** a single underline should be drawn. */
    static final public org.gnu.pango.Underline SINGLE = new org.gnu.pango.Underline (_SINGLE);
    static final private int _DOUBLE = 2;
	/** a double underline should be drawn. */
    static final public org.gnu.pango.Underline DOUBLE = new org.gnu.pango.Underline (_DOUBLE);
    static final private int _LOW = 3;
	/** 
	 * a single underline should be drawn at a position beneath the ink extents
	 * of the text being underlined. This should be used only for underlining
	 * single characters, such as for keyboard accelerators.
	 * {@link #SINGLE} should be used for extended portions of text.
	 */
    static final public org.gnu.pango.Underline LOW = new org.gnu.pango.Underline (_LOW);
    static final private org.gnu.pango.Underline[] theInterned = new org.gnu.pango.Underline[] 
    {
        NONE, SINGLE, DOUBLE, LOW 
    }

;
    static private java.util.Hashtable theInternedExtras;
    static final private org.gnu.pango.Underline theSacrificialOne = new org.gnu.pango.Underline (0);
    static public org.gnu.pango.Underline intern (int value) 
    {
        if (value < theInterned.length) 
        {
            return theInterned[value];
        }
        theSacrificialOne.value_ = value;
        if (theInternedExtras == null) 
        {
            theInternedExtras = new java.util.Hashtable();
        }
        org.gnu.pango.Underline already = (org.gnu.pango.Underline) theInternedExtras.get (
            theSacrificialOne);
        if (already == null) 
        {
            already = new org.gnu.pango.Underline(value);
            theInternedExtras.put(already, already);
        }
        return already;
    }

    private Underline (int value) 
    {
        value_ = value;
    }

    public org.gnu.pango.Underline or (org.gnu.pango.Underline other) 
    {
        return intern(value_ | other.value_);
    }

    public org.gnu.pango.Underline and (org.gnu.pango.Underline other) 
    {
        return intern(value_ & other.value_);
    }

    public org.gnu.pango.Underline xor (org.gnu.pango.Underline other) 
    {
        return intern(value_ ^ other.value_);
    }

    public boolean test (org.gnu.pango.Underline other) 
    {
        return (value_ & other.value_) == other.value_;
    }

    /****************************************
     * END OF GENERATED CODE
     ****************************************/
}

