/*
 * Java-Gnome Bindings Library
 *
 * Copyright 1998-2004 the Java-Gnome Team, all rights reserved.
 *
 * The Java-Gnome bindings library is free software distributed under
 * the terms of the GNU Library General Public License version 2.
 */

#include <jni.h>
#include <sys/types.h>
#include <gtk/gtk.h>

#ifndef _Included_org_gnu_gtk_RadioAction
#define _Included_org_gnu_gtk_RadioAction
#ifdef __cplusplus
extern "C" {
#endif

/*
 * Class:     org_gnu_gtk_RadioAction
 * Method:    gtk_radio_action_get_type
 * Signature: ()I
 */
JNIEXPORT jint JNICALL Java_org_gnu_gtk_RadioAction_gtk_1radio_1action_1get_1type
  (JNIEnv *env, jclass cls)
{
	return (jint)gtk_radio_action_get_type();
}

/*
 * Class:     org_gnu_gtk_RadioAction
 * Method:    gtk_radio_action_new
 * Signature: (Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;I)I
 */
JNIEXPORT jint JNICALL Java_org_gnu_gtk_RadioAction_gtk_1radio_1action_1new
  (JNIEnv *env, jclass cls, jstring name, jstring label, jstring tooltip, jstring stockId, jint val)
{
	const gchar* n = (*env)->GetStringUTFChars(env, name, NULL);
	const gchar* l = (*env)->GetStringUTFChars(env, label, NULL);
	const gchar* t = (*env)->GetStringUTFChars(env, tooltip, NULL);
	const gchar* s = (*env)->GetStringUTFChars(env, stockId, NULL);
	jint value = (jint)gtk_radio_action_new(n, l, t, s, val);
	(*env)->ReleaseStringUTFChars(env, name, n);
	(*env)->ReleaseStringUTFChars(env, label, l);
	(*env)->ReleaseStringUTFChars(env, tooltip, t);
	(*env)->ReleaseStringUTFChars(env, stockId, s);
	return value;
}
                                                                                   
/*
 * Class:     org_gnu_gtk_RadioAction
 * Method:    gtk_radio_action_get_group
 * Signature: (I)[I
 */
JNIEXPORT jintArray JNICALL Java_org_gnu_gtk_RadioAction_gtk_1radio_1action_1get_1group
  (JNIEnv *env, jclass cls, jint action)
{
	GSList *list = gtk_radio_action_get_group((GtkRadioAction*)action);
	guint len;
	jintArray ar;
	int i = 0;
 	if (NULL == list)
		return NULL;
	 len = g_slist_length(list);
	 ar = (*env)->NewIntArray(env, len);
	for (i = 0; i < len; i++) {
		GSList *item = g_slist_nth(list, i);
		(*env)->SetIntArrayRegion(env, ar, i, 1, (jint*)item->data);
	}
	return ar;
}

/*
 * Class:     org_gnu_gtk_RadioAction
 * Method:    gtk_radio_action_set_group
 * Signature: (I[I)V
 */
JNIEXPORT void JNICALL Java_org_gnu_gtk_RadioAction_gtk_1radio_1action_1set_1group
  (JNIEnv *env, jclass cls, jint action, jintArray group)
{
	jsize len;
	int index;
	jint* g;
	GSList *list;
	GtkRadioAction* act;

	list = g_slist_alloc();
	len = (*env)->GetArrayLength(env, group);
	g = (*env)->GetIntArrayElements(env, group, NULL);
	for (index = 0; index < len; index++) {
		act = (GtkRadioAction*)g[index];
		list = g_slist_append(list, act);
	}
	gtk_radio_action_set_group((GtkRadioAction*)action, list);
}

/*
 * Class:     org_gnu_gtk_RadioAction
 * Method:    gtk_radio_action_get_current_value
 * Signature: (I)I
 */
JNIEXPORT jint JNICALL Java_org_gnu_gtk_RadioAction_gtk_1radio_1action_1get_1current_1value
  (JNIEnv *env, jclass cls, jint action)
{
	return (jint)gtk_radio_action_get_current_value((GtkRadioAction*)action);
}


#ifdef __cplusplus
}
#endif
#endif
