/*
 * Java-Gnome Bindings Library
 *
 * Copyright 1998-2004 the Java-Gnome Team, all rights reserved.
 *
 * The Java-Gnome bindings library is free software distributed under
 * the terms of the GNU Library General Public License version 2.
 */

package org.gnu.gtk;
import org.gnu.glib.GObject;
import org.gnu.glib.Type;
import org.gnu.pango.FontDescription;
/**
 * A class that provides runtime routines for handling
 * resource files.
 */
public class RcStyle extends GObject 
{
	/**
	 * Construct a new RcStyle.
	 */
	public RcStyle() {
		super(gtk_rc_style_new());
	}
	
	/**
	 * Construct a new RcStyle from a given handle to a native resource.
	 */
	public RcStyle(int handle) {
		super(handle);
	}
	
	/**
	 * Retrieve the runtime type used by the GLib library.
	 */
	public static Type getType() {
		return new Type(gtk_rc_style_get_type());
	}
	
	public FontDescription getFontDescription() {
		return new FontDescription(getFontDesc(getHandle()));
	}
	
	public String getName(){
		return getName(getHandle());
	}
	
    /****************************************
     * BEGINNING OF GENERATED CODE
     ****************************************/
    native static final protected String getName (int cptr);
    native static final protected int getFontDesc (int cptr);
    native static final protected int getXthickness (int cptr);
    native static final protected int getYthickness (int cptr);
    native static final protected int gtk_rc_style_get_type ();
    native static final protected int gtk_rc_style_new ();
    native static final protected int gtk_rc_style_copy (int orig);
    native static final protected void gtk_rc_style_ref (int rc_style);
    native static final protected void gtk_rc_style_unref (int rc_style);
    /****************************************
     * END OF GENERATED CODE
     ****************************************/
}

