/*
 * Java-Gnome Bindings Library
 *
 * Copyright 1998-2004 the Java-Gnome Team, all rights reserved.
 *
 * The Java-Gnome bindings library is free software distributed under
 * the terms of the GNU Library General Public License version 2.
 */

package org.gnu.gtk;

import org.gnu.gdk.Screen;
import org.gnu.glib.GObject;
import org.gnu.glib.Type;

/**
 * The Invisible widget displays a blank window. It can act as a
 * placeholder. For example, it can be sized with a call to setMinimumSize,
 * and used inside a container to help position other widgets.
 */
public class Invisible extends Widget 
{
	
	/**
	 * Construct a new Invisible object.
	 */
	public Invisible() {
		super(Invisible.gtk_invisible_new());
	}
	
	public Invisible(Screen screen) {
		super(gtk_invisible_new_for_screen(screen.getHandle()));
	}
	
	public void setScreen(Screen screen) {
		gtk_invisible_set_screen(getHandle(), screen.getHandle());
	}
	
	public Screen getScreen() {
		int hndl = gtk_invisible_get_screen(getHandle());
		GObject obj = retrieveGObject(hndl);
		if (null != obj)
			return (Screen)obj;
		return new Screen(hndl);
	}
	
	/**
	 * Retrieve the runtime type used by the GLib library.
	 */
	public static Type getType() {
		return new Type(gtk_invisible_get_type());
	}

    /****************************************
     * BEGINNING OF GENERATED CODE
     ****************************************/
    native static final protected int gtk_invisible_get_type ();
    native static final protected int gtk_invisible_new ();
    native static final protected int gtk_invisible_new_for_screen(int screen);
    native static final protected void gtk_invisible_set_screen(int invisible, int screen);
    native static final protected int gtk_invisible_get_screen(int invisible);
    /****************************************
     * END OF GENERATED CODE
     ****************************************/
}

