/*
 * Java-Gnome Bindings Library
 *
 * Copyright 1998-2004 the Java-Gnome Team, all rights reserved.
 *
 * The Java-Gnome bindings library is free software distributed under
 * the terms of the GNU Library General Public License version 2.
 */

 /*
  * TODO:
  * Documentation.
  * add functionallity like in awt?
  */

package org.gnu.gdk;
import org.gnu.glib.Boxed;
public class Point extends Boxed 
{
	public Point(int x, int y) {
		handle = gdk_point_new();
		setX(x);
		setY(y);
	}
	
	public Point(int handle){
		this.handle=handle;
	}
	
	public int getX(){
		return Point.getX(handle);
	}
	
	public void setX(int x){
		setX(handle,x);
	}
	
	public int getY(){
		return Point.getY(handle);
	}
	
	public void setY(int y){
		setY(handle,y);
	}
	
	protected void finalize() throws Throwable {
		gdk_point_free(handle);
	}
	
	
	native static final protected int gdk_point_new();
	native static final protected void gdk_point_free(int handle);
	
    /****************************************
     * BEGINNING OF GENERATED CODE
     ****************************************/
    native static final protected int getX (int obj);
    native final protected void setX (int obj, int x);
    native static final protected int getY (int obj);
    native final protected void setY (int obj, int y);
    /****************************************
     * END OF GENERATED CODE
     ****************************************/
}

