/*
 * Java-Gnome Bindings Library
 *
 * Copyright 2006 the Java-Gnome Team, all rights reserved.
 *
 * The Java-Gnome bindings library is free software distributed under
 * the terms of the GNU Library General Public License version 2.
 */

package org.gnu.gtk;

import org.gnu.glib.Type;

/**
 * Represents a block in which <code>long</code> data can be stored in a
 * {@link TreeModel}.
 * <p>
 * See parent class {@link DataColumn} description for more information.
 * 
 * @since 2.8.5
 * @author Andrew Cowie;
 */
public class DataColumnLong extends DataColumn {

    /**
     * Constructs a new datablock for storing <code>long</code> data.
     */
    public DataColumnLong() {
        type = Type.LONG();
    }
}
