/*
 * Java-Gnome Bindings Library
 *
 * Copyright 1998-2004 the Java-Gnome Team, all rights reserved.
 *
 * The Java-Gnome bindings library is free software distributed under
 * the terms of the GNU Library General Public License version 2.
 */

package org.gnu.gnome;

/**
 * org.gnu.gnome.HelpException - An exception thrown when there is an error
 * displaying a help file.
 * 
 * <P>
 * <B>Revision History:</B>
 * <UL>
 * <LI>Nov 5, 2002 This class was created.</LI>
 * </UL>
 * </P>
 * 
 * @author Philip A. Chapman
 */
public final class HelpException extends Exception {

    private HelpError error = null;

    /**
     * Constructor for HelpException.
     */
    HelpException() {
        super();
    }

    /**
     * Constructor for HelpException.
     * 
     * @param message
     */
    public HelpException(String message) {
        super(message);
    }

    // Constructors only available in java 1.4.0 and later
    /**
     * Constructor for HelpException.
     * 
     * @param message
     * @param cause
     */
    // public HelpException(String message, Throwable cause) {
    // super(message, cause);
    // }
    /**
     * Constructor for HelpException.
     * 
     * @param cause
     */
    // public HelpException(Throwable cause) {
    // super(cause);
    // }
}
