---
myst:
  html_meta:
    keywords: LaTeX,code,programmation,FAQ,exemples de code LaTeX
---
# Y a-t-il des exemples ?

Oui, plein ! En fait, le but est d'en présenter le maximum.

- Les exemples sans affichage de résultat sont présentés comme ceci :

  ```{noedit}
  Ceci est un exemple de code \LaTeX{} dont on ne présente pas le résultat.
  ```

- Les exemples avec affichage du résultat seront la plupart du temps présentés
  comme suit (appréciez la colorisation du code et n'hésitez pas à cliquer sur
  le bouton "Compiler et afficher") :

  ```
  \documentclass[french]{article}
  \usepackage[T1]{fontenc}
  \usepackage{babel}

  %% Commentaire : fin du préambule

  \begin{document}

  \title{Titre de mon article}
  \author{Le Monsieur \and La Madame}
  \date{Le \today}
  \maketitle

  \begin{abstract}
  Résumé de mon article, passionnant.
  \end{abstract}

  \tableofcontents

  \section{Explications}

  \texttt{fontenc}, \texttt{inputenc} sont des
  packages permettant d'utiliser les accents.
  \texttt{babel} sert à franciser le document.
  \texttt{article} est la classe de document
  utilisée.

  \end{document}
  ```

  Certains d'entre eux seront affichés de façon plus minimale (notamment sans
  préambule) et seront automatiquement complétés en un exemple compilable
  (notamment avec ajout d'un préambule) dès que leur compilation aura été
  demandée. C'est le cas de l'exemple suivant (n'hésitez pas à cliquer sur le
  bouton "Compiler et afficher") :

  ```
  Ceci est un exemple de code \LaTeX{} dont on présente le résultat.
  ```

Nous invitons les personnes voulant contribuer à la FAQ à lire la documentation
relative à [la mise en évidence de la syntaxe du code
LaTeX](/8_contribuer/syntaxe/syntax.md#blocs-de-codes-latex).
