---
myst:
  html_meta:
    keywords: programmation, erreurs, messages d'erreur de LaTeX, définir une commande,
              définir une macro, nom de commande
---

# Que signifie l'erreur : "Missing control sequence inserted" ?

:Message: `Missing control sequence inserted`
:Origine: TeX.

On a utilisé `\newcommand` ou `\renewcommand` sans fournir de nom de commande 
(commençant par une barre oblique inverse) comme premier argument.

Si vous souhaitez par exemple définir la macro `\L` pour écrire un `L` gras, 
la syntaxe correcte est :

```
\documentclass[french]{article}
  \usepackage[T1]{fontenc}    % Encodage T1 (adapté au français)
  \usepackage{lmodern}        % Caractères plus lisibles
  \usepackage{babel}          % Réglages linguistiques (avec french)
  \pagestyle{empty}           % N'affiche pas de numéro de page
  \renewcommand{\L}{\textbf{L}}

  % Une forme erronée affichant l'erreur serait :
  % \renewcommand{L}{\textbf{L}}

\begin{document}
\Large L \L
\end{document}
```


:::{sources}
- <https://latex.developpez.com/faq/erreurs?page=M>,
- [*LaTeX Companion*, 2e édition](https://www.latex-project.org/help/books/#french), 
  Frank Mittelbach, Michel Goossens, Johannes Braams, David Carlisle, Chris Rowley 
  (Pearson, 2006) ; ISBN : 978-2-7440-7182-9. Annexe B, 
  *Détecter et résoudre les problèmes*, reproduite avec l'aimable autorisation de l'éditeur.
- [DeclareDocumentEnvironment : missing control sequence inserted — `\inaccessible`](https://tex.stackexchange.com/q/121481),
  sur [Tex Stack Exchange](https://tex.stackexchange.com/)
:::