/***************************************************************************\
*                                                                           *
*   RICHEDIT.H                                                              *
*                                                                           *
*   Some headers are used from the cygnus project                           *
*   Modified by:                                                            *
*    kiefer@isys.de                                                         *
*    rainer@mathematik.uni-bielefeld.de                                     *
*									    *
\***************************************************************************/

#if !defined (_RICHEDIT_H)
#define _RICHEDIT_H

#ifdef __cplusplus
extern "C" {
#endif

#define EM_CANPASTE			(WM_USER + 50)
#define EM_DISPLAYBAND		(WM_USER + 51)
#define EM_EXGETSEL			(WM_USER + 52)
#define EM_EXLIMITTEXT		(WM_USER + 53)
#define EM_EXLINEFROMCHAR	(WM_USER + 54)
#define EM_EXSETSEL			(WM_USER + 55)
#define EM_FINDTEXT			(WM_USER + 56)
#define EM_FORMATRANGE		(WM_USER + 57)
#define EM_GETCHARFORMAT		(WM_USER + 58)
#define EM_GETEVENTMASK		(WM_USER + 59)
#define EM_GETOLEINTERFACE	(WM_USER + 60)
#define EM_GETPARAFORMAT		(WM_USER + 61)
#define EM_GETSELTEXT		(WM_USER + 62)
#define EM_HIDESELECTION		(WM_USER + 63)
#define EM_PASTESPECIAL		(WM_USER + 64)
#define EM_REQUESTRESIZE		(WM_USER + 65)
#define EM_SELECTIONTYPE		(WM_USER + 66)
#define EM_SETBKGNDCOLOR		(WM_USER + 67)
#define EM_SETCHARFORMAT		(WM_USER + 68)
#define EM_SETEVENTMASK		(WM_USER + 69)
#define EM_SETOLECALLBACK		(WM_USER + 70)
#define EM_SETPARAFORMAT		(WM_USER + 71)
#define EM_SETTARGETDEVICE		(WM_USER + 72)
#define EM_STREAMIN			(WM_USER + 73)
#define EM_STREAMOUT		(WM_USER + 74)
#define EM_GETTEXTRANGE		(WM_USER + 75)
#define EM_FINDWORDBREAK		(WM_USER + 76)
#define EM_SETOPTIONS		(WM_USER + 77)
#define EM_GETOPTIONS		(WM_USER + 78)
#define EM_FINDTEXTEX		(WM_USER + 79)
#define EM_GETWORDBREAKPROCEX	(WM_USER + 80)
#define EM_SETWORDBREAKPROCEX	(WM_USER + 81)
#define EM_SETPUNCTUATION		(WM_USER + 100)
#define EM_GETPUNCTUATION		(WM_USER + 101)
#define EM_SETWORDWRAPMODE	(WM_USER + 102)
#define EM_GETWORDWRAPMODE	(WM_USER + 103)
#define EM_SETIMECOLOR		(WM_USER + 104)
#define EM_GETIMECOLOR		(WM_USER + 105)
#define EM_SETIMEOPTIONS		(WM_USER + 106)
#define EM_GETIMEOPTIONS		(WM_USER + 107)


#define EN_MSGFILTER			0x0700
#define EN_REQUESTRESIZE		0x0701
#define EN_SELCHANGE		0x0702
#define EN_DROPFILES			0x0703
#define EN_PROTECTED		0x0704
#define EN_CORRECTTEXT		0x0705
#define EN_STOPNOUNDO		0x0706
#define EN_IMECHANGE		0x0707
#define EN_SAVECLIPBOARD		0x0708
#define EN_OLEOPFAILED		0x0709

#define ENM_NONE			0x00000000
#define ENM_CHANGE			0x00000001
#define ENM_UPDATE			0x00000002
#define ENM_SCROLL			0x00000004
#define ENM_KEYEVENTS		0x00010000
#define ENM_MOUSEEVENTS		0x00020000
#define ENM_REQUESTRESIZE		0x00040000
#define ENM_SELCHANGE		0x00080000
#define ENM_DROPFILES		0x00100000
#define ENM_PROTECTED		0x00200000
#define ENM_CORRECTTEXT		0x00400000
#define ENM_IMECHANGE		0x00800000

#define ES_SAVESEL			0x00008000
#define ES_SUNKEN			0x00004000
#define ES_DISABLENOSCROLL		0x00002000
#define ES_SELECTIONBAR		0x01000000
#define ES_EX_NOCALLOLEINIT	0x01000000

#define ES_VERTICAL			0x00400000
#define ES_NOIME			0x00080000
#define ES_SELFIME			0x00040000

#define ECO_AUTOWORDSELECTION	0x00000001
#define ECO_AUTOVSCROLL		0x00000040
#define ECO_AUTOHSCROLL		0x00000080
#define ECO_NOHIDESEL		0x00000100
#define ECO_READONLY		0x00000800
#define ECO_WANTRETURN		0x00001000
#define ECO_SAVESEL			0x00008000
#define ECO_SELECTIONBAR		0x01000000
#define ECO_VERTICAL			0x00400000

#define ECOOP_SET		1
#define ECOOP_OR		2
#define ECOOP_AND		3
#define ECOOP_XOR		4

#define WB_CLASSIFY			3
#define WB_MOVEWORDLEFT		4
#define WB_MOVEWORDRIGHT	5
#define WB_LEFTBREAK		6
#define WB_RIGHTBREAK		7

#define PC_FOLLOWING	1
#define PC_LEADING		2
#define PC_OVERFLOW		3
#define PC_DELIMITER		4

#define WBF_WORDWRAP	0x010
#define WBF_WORDBREAK	0x020
#define WBF_OVERFLOW	0x040	
#define WBF_LEVEL1		0x080
#define WBF_LEVEL2		0x100
#define WBF_CUSTOM		0x200

#define WBF_CLASS		((BYTE) 0x0F)
#define WBF_ISWHITE		((BYTE) 0x10)
#define WBF_BREAKLINE	((BYTE) 0x20)
#define WBF_BREAKAFTER	((BYTE) 0x40)

typedef struct
{
	LONG	cpMin;
	LONG	cpMax;
} CHARRANGE;

typedef struct
{
	CHARRANGE chrg;
	LPSTR lpstrText;	
} TEXTRANGE;

typedef DWORD (WINAPI *EDITSTREAMCALLBACK)(DWORD dwCookie, LPBYTE pbBuff, LONG cb, LONG *pcb);

typedef struct 
{
	DWORD dwCookie;
	DWORD dwError;
	EDITSTREAMCALLBACK pfnCallback;
} EDITSTREAM;

#define SF_TEXT	0x0001
#define SF_RTF		0x0002
#define SF_RTFNOOBJS	0x0003
#define SF_TEXTIZED	0x0004

#define SFF_SELECTION	0x8000
#define SFF_PLAINRTF		0x4000

typedef struct 
{
	CHARRANGE chrg;
	LPSTR lpstrText;
} FINDTEXT;

typedef struct
{
	UINT		cbSize;
	DWORD	dwMask;
	DWORD	dwEffects;
	LONG		yHeight;
	LONG		yOffset;
	COLORREF	crTextColor;
	BYTE		bCharSet;
	BYTE		bPitchAndFamily;
	char		szFaceName[LF_FACESIZE];
} CHARFORMAT;

#define CFM_BOLD		0x00000001
#define CFM_ITALIC		0x00000002
#define CFM_UNDERLINE	0x00000004
#define CFM_STRIKEOUT	0x00000008
#define CFM_PROTECTED	0x00000010
#define CFM_SIZE		0x80000000
#define CFM_COLOR		0x40000000
#define CFM_FACE		0x20000000
#define CFM_OFFSET		0x10000000
#define CFM_CHARSET		0x08000000

#define CFE_BOLD		0x0001
#define CFE_ITALIC		0x0002
#define CFE_UNDERLINE	0x0004
#define CFE_STRIKEOUT	0x0008
#define CFE_PROTECTED	0x0010
/* NOTE: CFE_AUTOCOLOR corresponds to CFM_COLOR, which controls it */
#define CFE_AUTOCOLOR	0x40000000

#define yHeightCharPtsMost 1638

#define SCF_SELECTION	0x0001
#define SCF_WORD		0x0002

typedef struct 
{
	CHARRANGE chrg;
	LPSTR lpstrText;
	CHARRANGE chrgText;
} FINDTEXTEX;

#define CF_RTF "Rich Text Format"
#define CF_RTFNOOBJS "Rich Text Format Without Objects"
#define CF_RETEXTOBJ "RichEdit Text and Objects"

typedef struct 
{
	DWORD dwAspect;
	DWORD dwParam;
} REPASTESPECIAL;

typedef struct _formatrange
{
	HDC hdc;
	HDC hdcTarget;
	RECT rc;
	RECT rcPage;
	CHARRANGE chrg;
} FORMATRANGE;

#define MAX_TAB_STOPS 32
#define lDefaultTab 720

typedef struct
{
	UINT	cbSize;
	DWORD	dwMask;
	WORD	wNumbering;
	WORD	wReserved;
	LONG	dxStartIndent;
	LONG	dxRightIndent;
	LONG	dxOffset;
	WORD	wAlignment;
	SHORT	cTabCount;
	LONG	rgxTabs[MAX_TAB_STOPS];
} PARAFORMAT;

#define PFM_STARTINDENT			0x00000001
#define PFM_RIGHTINDENT			0x00000002
#define PFM_OFFSET				0x00000004
#define PFM_ALIGNMENT			0x00000008
#define PFM_TABSTOPS			0x00000010
#define PFM_NUMBERING			0x00000020
#define PFM_OFFSETINDENT		0x80000000

#define PFN_BULLET		0x0001

#define PFA_LEFT	0x0001
#define PFA_RIGHT	0x0002
#define PFA_CENTER	0x0003

typedef struct
{
	NMHDR	nmhdr;
	UINT	msg;
	WPARAM	wParam;
	LPARAM	lParam;
} MSGFILTER;

typedef struct
{
	NMHDR nmhdr;
	RECT rc;
} REQRESIZE;

typedef struct
{
	NMHDR nmhdr;
	CHARRANGE chrg;
	WORD seltyp;
} SELCHANGE;

#define SEL_EMPTY		0x0000
#define SEL_TEXT		0x0001
#define SEL_OBJECT		0x0002
#define SEL_MULTICHAR	0x0004
#define SEL_MULTIOBJECT	0x0008

typedef struct
{
	NMHDR nmhdr;
	HANDLE hDrop;
	LONG cp;
	BOOL fProtected;
} ENDROPFILES;

typedef struct
{
	NMHDR nmhdr;
	UINT msg;
	WPARAM wParam;
	LPARAM lParam;
	CHARRANGE chrg;
} ENPROTECTED;

typedef struct 
{
	NMHDR nmhdr;
	LONG cObjectCount;
	LONG cch;
} ENSAVECLIPBOARD;

/* FIXME FIXME */
typedef HANDLE HRESULT; 
typedef struct 
{
	NMHDR nmhdr;
	LONG iob;
	LONG lOper;
	HRESULT hr;
} ENOLEOPFAILED;

#define	OLEOP_DOVERB	1

#ifdef __cplusplus
}
#endif

#endif /* !defined (_RICHEDIT_H) */
