/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.heapviewer.ui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.io.File;
import java.util.Collection;
import java.util.Comparator;
import java.util.TreeSet;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.MenuElement;
import javax.swing.MenuSelectionManager;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.graalvm.visualvm.heapviewer.HeapContext;
import org.graalvm.visualvm.heapviewer.HeapViewer;
import org.graalvm.visualvm.heapviewer.ui.Bundle;
import org.graalvm.visualvm.heapviewer.ui.HeapDumpInfoAction;
import org.graalvm.visualvm.heapviewer.ui.HeapView;
import org.graalvm.visualvm.heapviewer.ui.HeapViewerActions;
import org.graalvm.visualvm.heapviewer.ui.HeapViewerFeature;
import org.graalvm.visualvm.heapviewer.ui.MultiResolutionImageHack;
import org.graalvm.visualvm.lib.ui.UIUtils;
import org.graalvm.visualvm.lib.ui.components.ProfilerToolbar;
import org.graalvm.visualvm.lib.ui.swing.PopupButton;
import org.graalvm.visualvm.lib.ui.swing.ProfilerPopupMenu;
import org.graalvm.visualvm.lib.ui.swing.StayOpenPopupMenu;
import org.graalvm.visualvm.uisupport.ProfilerTabbedView;
import org.openide.util.Lookup;
import org.openide.util.RequestProcessor;

public final class HeapViewerComponent
extends JPanel {
    private final HeapViewer heapViewer;
    private HeapContext[] contexts;
    private HeapViewerFeature[][] features;
    private ProfilerTabbedView views;
    private ProfilerToolbar toolbar;
    private ProfilerToolbar viewToolbar;
    private HeapView currentView;
    private ProfilerToolbar currentViewToolbar;
    private MainView mainView;

    public HeapViewerComponent(HeapViewer heapViewer) {
        super(new BorderLayout());
        this.setOpaque(false);
        this.heapViewer = heapViewer;
        this.add((Component)new JLabel(Bundle.HeapViewerComponent_LoadingProgress(), 0), "Center");
        File file = heapViewer.getFile();
        String name = file == null ? "<no heap dump file>" : file.getName();
        new RequestProcessor("HPROF initializer for " + name).post(new Runnable(){

            @Override
            public void run() {
                HeapViewerComponent.this.initImpl();
            }
        });
    }

    @Override
    public Dimension getMinimumSize() {
        return new Dimension(0, 0);
    }

    private void initImpl() {
        this.contexts = HeapContext.allContexts(this.heapViewer);
        HeapViewerActions actions = new HeapViewerActions(){

            @Override
            public HeapViewerFeature findFeature(String id) {
                HeapViewerFeature[][] heapViewerFeatureArray = HeapViewerComponent.this.features;
                int n = heapViewerFeatureArray.length;
                for (int i = 0; i < n; ++i) {
                    HeapViewerFeature[] featureArr;
                    for (HeapViewerFeature feature : featureArr = heapViewerFeatureArray[i]) {
                        if (!feature.getID().equals(id)) continue;
                        return feature;
                    }
                }
                return null;
            }

            @Override
            public <T extends HeapViewerFeature> T findFeature(Class<T> featureClass) {
                HeapViewerFeature[][] heapViewerFeatureArray = HeapViewerComponent.this.features;
                int n = heapViewerFeatureArray.length;
                for (int i = 0; i < n; ++i) {
                    HeapViewerFeature[] featureArr;
                    for (HeapViewerFeature feature : featureArr = heapViewerFeatureArray[i]) {
                        if (feature.getClass() != featureClass) continue;
                        return (T)feature;
                    }
                }
                return null;
            }

            @Override
            public void selectFeature(HeapViewerFeature feature) {
                HeapViewerComponent.this.selectView(HeapViewerComponent.this.mainView);
                HeapViewerComponent.this.mainView.selectFeature(HeapViewerComponent.this.contexts[feature.getScope()], feature);
            }

            @Override
            public void selectView(HeapView view) {
                HeapViewerComponent.this.selectView(view);
            }

            @Override
            public void addView(HeapView view, boolean select) {
                HeapViewerComponent.this.addView(view, select, true);
            }
        };
        Collection providers = Lookup.getDefault().lookupAll(HeapViewerFeature.Provider.class);
        this.features = new HeapViewerFeature[this.contexts.length][];
        for (int i = 0; i < this.contexts.length; ++i) {
            TreeSet<HeapViewerFeature> featuresS = new TreeSet<HeapViewerFeature>(new Comparator<HeapViewerFeature>(){

                @Override
                public int compare(HeapViewerFeature f1, HeapViewerFeature f2) {
                    return Integer.compare(f1.getPosition(), f2.getPosition());
                }
            });
            for (HeapViewerFeature.Provider provider : providers) {
                HeapViewerFeature feature = provider.getFeature(this.contexts[i], actions);
                if (feature == null) continue;
                feature.setScope(i);
                featuresS.add(feature);
            }
            this.features[i] = featuresS.toArray(new HeapViewerFeature[0]);
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                HeapViewerComponent.this.initComponents();
            }
        });
    }

    private void initComponents() {
        this.removeAll();
        this.toolbar = ProfilerToolbar.create((boolean)true);
        this.add((Component)this.toolbar.getComponent(), "North");
        this.viewToolbar = ProfilerToolbar.create((boolean)false);
        this.toolbar.add(this.viewToolbar);
        this.toolbar.addFiller();
        this.toolbar.add((Action)new HeapDumpInfoAction(this.heapViewer));
        this.views = ProfilerTabbedView.createBottom((boolean)true, (boolean)true, (ChangeListener)new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                JComponent newComponent = HeapViewerComponent.this.views.getSelectedView();
                if (newComponent != null) {
                    HeapViewerComponent.this.viewSelected(HeapViewerComponent.getView(newComponent));
                }
            }
        });
        this.views.addViewListener(new ProfilerTabbedView.Listener(){

            public void viewRemoved(JComponent view) {
                HeapViewerComponent.this.viewClosed(HeapViewerComponent.getView(view));
            }
        });
        this.add((Component)this.views.getComponent(), "Center");
        this.views.setFocusMaster((Component)this);
        this.mainView = new MainView();
        this.addView(this.mainView, false, false);
    }

    private void selectView(final HeapView view) {
        UIUtils.runInEventDispatchThread((Runnable)new Runnable(){

            @Override
            public void run() {
                HeapViewerComponent.this.views.selectView(view.getComponent());
            }
        });
    }

    private void addView(final HeapView view, final boolean select, final boolean closable) {
        UIUtils.runInEventDispatchThread((Runnable)new Runnable(){

            @Override
            public void run() {
                JComponent component = view.getComponent();
                if (HeapViewerComponent.this.views.containsView(component)) {
                    if (select) {
                        HeapViewerComponent.this.views.selectView(component);
                    } else {
                        HeapViewerComponent.this.views.highlightView(component);
                    }
                } else {
                    component.putClientProperty("HeapView", view);
                    HeapViewerComponent.this.views.addView(view.getName(), view.getIcon(), view.getDescription(), component, closable);
                    if (select) {
                        HeapViewerComponent.this.views.selectView(component);
                    }
                    HeapViewerComponent.this.invalidate();
                    HeapViewerComponent.this.revalidate();
                    HeapViewerComponent.this.doLayout();
                    HeapViewerComponent.this.repaint();
                }
            }
        });
    }

    private static HeapView getView(JComponent component) {
        return (HeapView)component.getClientProperty("HeapView");
    }

    private void viewSelected(HeapView newView) {
        if (this.currentView == newView) {
            return;
        }
        if (this.currentViewToolbar != null) {
            this.viewToolbar.remove(this.currentViewToolbar);
        }
        if (this.currentView != null) {
            this.currentView.hidden();
        }
        this.currentView = newView;
        this.currentView.showing();
        this.currentViewToolbar = this.currentView.getToolbar();
        if (this.currentViewToolbar != null) {
            this.viewToolbar.add(this.currentViewToolbar);
        }
    }

    private void viewClosed(HeapView view) {
        view.closed();
    }

    private void updateViewTab(HeapView view) {
        if (this.views.getViewsCount() > 0) {
            this.views.updateView(view.getComponent(), view.getName(), view.getIcon(), view.getDescription());
        }
    }

    public void willBeClosed() {
        if (this.mainView != null) {
            this.mainView.willBeClosed(null);
        }
    }

    public void closed() {
        if (this.views != null) {
            this.views.removeAllViews();
        }
    }

    private class MainView
    extends HeapView {
        private PopupButton featureChooser;
        private ProfilerToolbar toolbar;
        private JComponent component;
        private HeapContext selectedContext;
        private HeapViewerFeature selectedFeature;

        MainView() {
            super(null, null);
            for (int i = 0; this.selectedFeature == null && i < HeapViewerComponent.this.features.length; ++i) {
                for (int j = 0; this.selectedFeature == null && j < HeapViewerComponent.this.features[i].length; ++j) {
                    if (!HeapViewerComponent.this.features[i][j].isDefault()) continue;
                    this.selectedContext = HeapViewerComponent.this.contexts[i];
                    this.selectedFeature = HeapViewerComponent.this.features[i][j];
                }
            }
            if (this.selectedFeature == null) {
                this.selectedContext = HeapViewerComponent.this.contexts[0];
                this.selectedFeature = HeapViewerComponent.this.features[0][0];
            }
        }

        @Override
        public JComponent getComponent() {
            if (this.component == null) {
                this.initUI();
            }
            return this.component;
        }

        @Override
        public ProfilerToolbar getToolbar() {
            if (this.toolbar == null) {
                this.initUI();
            }
            return this.toolbar;
        }

        @Override
        public String getName() {
            return this.selectedFeature.getName();
        }

        @Override
        public String getDescription() {
            return HeapViewerComponent.this.contexts.length == 1 ? this.selectedFeature.getName() : this.selectedContext.getFragment().getName() + ": " + this.selectedFeature.getName();
        }

        @Override
        public Icon getIcon() {
            return this.selectedFeature.getIcon();
        }

        @Override
        protected void showing() {
            this.selectedFeature.showing();
        }

        @Override
        protected void hidden() {
            this.selectedFeature.hidden();
        }

        @Override
        protected void willBeClosed(Runnable viewSelector) {
            for (int i = 0; i < HeapViewerComponent.this.features.length; ++i) {
                HeapViewerFeature[] featureArr;
                final HeapContext context = HeapViewerComponent.this.contexts[i];
                for (final HeapViewerFeature feature : featureArr = HeapViewerComponent.this.features[i]) {
                    Runnable _viewSelector = new Runnable(){

                        @Override
                        public void run() {
                            MainView.this.selectFeature(context, feature);
                        }
                    };
                    feature.willBeClosed(_viewSelector);
                }
            }
        }

        @Override
        protected void closed() {
            HeapViewerFeature[][] heapViewerFeatureArray = HeapViewerComponent.this.features;
            int n = heapViewerFeatureArray.length;
            for (int i = 0; i < n; ++i) {
                HeapViewerFeature[] featureArr;
                for (HeapViewerFeature feature : featureArr = heapViewerFeatureArray[i]) {
                    feature.closed();
                }
            }
        }

        void selectFeature(HeapContext context, HeapViewerFeature feature) {
            if (this.selectedFeature != null) {
                this.selectedFeature.hidden();
            }
            this.selectedContext = context;
            this.selectedFeature = feature;
            this.selectedFeature.showing();
            this.featureChooser.setText(this.getName());
            this.featureChooser.setToolTipText(this.getDescription());
            this.featureChooser.setIcon(this.getIcon());
            this.featureChooser.invalidate();
            Container parent = this.featureChooser.getParent();
            if (parent != null) {
                parent.revalidate();
                parent.repaint();
            }
            this.component.removeAll();
            this.component.add((Component)feature.getComponent(), "Center");
            this.component.invalidate();
            parent = this.component.getParent();
            if (parent != null) {
                parent.revalidate();
                parent.repaint();
            }
            while (this.toolbar.getComponentCount() > 1) {
                this.toolbar.remove(1);
            }
            ProfilerToolbar featureToolbar = feature.getToolbar();
            if (featureToolbar != null) {
                this.toolbar.add(featureToolbar);
            }
            HeapViewerComponent.this.updateViewTab(this);
        }

        private void displayPopupImpl(JComponent invoker) {
            StayOpenPopupMenu popup = new StayOpenPopupMenu(){};
            popup.setLayout((LayoutManager)new GridBagLayout());
            if (!UIUtils.isAquaLookAndFeel()) {
                popup.setForceBackground(true);
                Color background = UIUtils.getProfilerResultsBackground();
                popup.setBackground(new Color(background.getRGB()));
                Color foreground = new JLabel().getForeground();
                if (foreground == null) {
                    foreground = new JTextArea().getForeground();
                }
                if (foreground == null) {
                    foreground = UIUtils.isDarkResultsBackground() ? Color.WHITE : Color.BLACK;
                }
                popup.setForeground(new Color(foreground.getRGB()));
            }
            boolean scopes = HeapViewerComponent.this.contexts.length > 1;
            final boolean[] skipChange = new boolean[1];
            int topl = 8;
            int labl = 8;
            int left = scopes ? 12 : 4;
            int y = 0;
            class ViewsUpdater {
                int viewsIdx = Integer.MAX_VALUE;
                MenuElement preselect = null;
                final /* synthetic */ ProfilerPopupMenu val$popup;
                final /* synthetic */ int val$left;

                ViewsUpdater() {
                    this.val$popup = profilerPopupMenu;
                    this.val$left = n;
                }

                void updateViews(final HeapContext context, HeapViewerFeature[] features) {
                    int count = this.val$popup.getComponentCount();
                    for (int i = this.viewsIdx; i < count; ++i) {
                        this.val$popup.remove(this.viewsIdx);
                    }
                    int y = this.viewsIdx;
                    for (final HeapViewerFeature feature : features) {
                        GridBagConstraints c = new GridBagConstraints();
                        c.gridx = 0;
                        c.gridy = y++;
                        c.insets = new Insets(HeapViewerComponent.this.contexts.length == 1 && y == 1 ? 4 : 0, this.val$left, 0, 5);
                        c.fill = 2;
                        JMenuItem mi = new JMenuItem(feature.getName(), feature.getIcon()){

                            @Override
                            protected void fireActionPerformed(ActionEvent e) {
                                MainView.this.selectFeature(context, feature);
                            }
                        };
                        if (MainView.this.selectedFeature == feature) {
                            this.preselect = mi;
                        }
                        this.val$popup.add((Component)mi, (Object)c);
                    }
                    JPanel footer = new JPanel(null);
                    footer.setOpaque(false);
                    GridBagConstraints c = new GridBagConstraints();
                    c.gridx = 0;
                    c.gridy = y++;
                    c.weightx = 1.0;
                    c.weighty = 1.0;
                    c.insets = new Insets(3, 0, 0, 0);
                    c.anchor = 18;
                    c.fill = 1;
                    this.val$popup.add((Component)footer, (Object)c);
                    this.val$popup.pack();
                }
            }
            final ViewsUpdater updater = new ViewsUpdater();
            if (scopes) {
                JLabel scopeL = new JLabel(Bundle.HeapViewerComponent_Scope(), 10);
                scopeL.setFont(popup.getFont().deriveFont(1));
                GridBagConstraints c = new GridBagConstraints();
                c.gridx = 0;
                c.gridy = y++;
                c.insets = new Insets(5, labl, 5, 5);
                c.fill = 2;
                popup.add((Component)scopeL, (Object)c);
                MultiResolutionImageHack.hackIcon("RadioButtonMenuItem.checkIcon");
                StayOpenPopupMenu.RadioButtonItem toSelect = null;
                ButtonGroup bg = new ButtonGroup();
                for (int i = 0; i < HeapViewerComponent.this.contexts.length; ++i) {
                    c = new GridBagConstraints();
                    c.gridx = 0;
                    c.gridy = y++;
                    c.insets = new Insets(0, left, 0, 5);
                    c.fill = 2;
                    final int ii = i;
                    StayOpenPopupMenu.RadioButtonItem mi = new StayOpenPopupMenu.RadioButtonItem(HeapViewerComponent.this.contexts[i].getFragment().getName()){
                        {
                            super(x0);
                        }

                        protected void fireItemStateChanged(ItemEvent event) {
                            if (this.isSelected()) {
                                updater.updateViews(HeapViewerComponent.this.contexts[ii], HeapViewerComponent.this.features[ii]);
                                if (!skipChange[0]) {
                                    MainView.this.selectFeature(HeapViewerComponent.this.contexts[ii], HeapViewerComponent.this.features[ii][0]);
                                } else {
                                    skipChange[0] = false;
                                }
                            }
                        }
                    };
                    if (this.selectedContext == HeapViewerComponent.this.contexts[ii]) {
                        toSelect = mi;
                    }
                    bg.add((AbstractButton)mi);
                    popup.add((Component)mi, (Object)c);
                }
                JLabel viewL = new JLabel(Bundle.HeapViewerComponent_View(), 10);
                viewL.setFont(popup.getFont().deriveFont(1));
                c = new GridBagConstraints();
                c.gridx = 0;
                c.gridy = y++;
                c.insets = new Insets(topl, labl, 5, 5);
                c.fill = 2;
                popup.add((Component)viewL, (Object)c);
                updater.viewsIdx = y;
                if (toSelect != null) {
                    skipChange[0] = true;
                    toSelect.setSelected(true);
                }
            } else {
                updater.viewsIdx = 0;
                updater.updateViews(HeapViewerComponent.this.contexts[0], HeapViewerComponent.this.features[0]);
            }
            popup.show((Component)invoker, 0, invoker.getHeight());
            if (updater.preselect != null) {
                MenuSelectionManager.defaultManager().setSelectedPath(new MenuElement[]{popup, updater.preselect});
            }
        }

        private void initUI() {
            this.toolbar = ProfilerToolbar.create((boolean)false);
            this.featureChooser = new PopupButton(){

                protected void displayPopup() {
                    MainView.this.displayPopupImpl((JComponent)MainView.this.featureChooser);
                }

                public int getIconTextGap() {
                    return 5;
                }
            };
            this.toolbar.add((Component)this.featureChooser);
            this.component = new JPanel(new BorderLayout()){

                @Override
                public boolean requestFocusInWindow() {
                    if (this.getComponentCount() == 0) {
                        return super.requestFocusInWindow();
                    }
                    return this.getComponent(0).requestFocusInWindow();
                }
            };
            this.component.setOpaque(false);
            this.selectFeature(this.selectedContext, this.selectedFeature);
        }
    }
}

