untrusted comment: verify with openbsd-78-base.pub
RWS3/nvFmk4SWQBcczjUfPvPjdf0+lVC+I6jJa0RqHSU655XU19c3+Sib/P02vE3GK0Da4dGji6g0qGkZwT/tPb/H0nre/qkrQA=

OpenBSD 7.8 errata 012, January 14, 2026:

A malicious RPKI Certification Authority can cause a NULL dereference.
A malicious RPKI Trust Anchor can cause memory exhaustion.

Apply by doing:
    signify -Vep /etc/signify/openbsd-78-base.pub -x 012_rpki.patch.sig \
        -m - | (cd /usr/src && patch -p0)

And then rebuild and install rpki-client:
    cd /usr/src/usr.sbin/rpki-client
    make obj
    make
    make install

Index: usr.sbin/rpki-client/cert.c
===================================================================
RCS file: /cvs/src/usr.sbin/rpki-client/cert.c,v
diff -u -p -r1.205 cert.c
--- usr.sbin/rpki-client/cert.c	2 Aug 2025 14:09:25 -0000	1.205
+++ usr.sbin/rpki-client/cert.c	9 Jan 2026 15:56:00 -0000
@@ -1352,6 +1352,15 @@ cert_as_inherit(const struct cert *cert)
 	return cert->ases[0].type == CERT_AS_INHERIT;
 }
 
+static int
+cert_has_one_as(const struct cert *cert)
+{
+	if (cert->num_ases != 1)
+		return 0;
+
+	return cert->ases[0].type == CERT_AS_ID;
+}
+
 int
 sbgp_parse_assysnum(const char *fn, const ASIdentifiers *asidentifiers,
     struct cert_as **out_as, size_t *out_num_ases)
@@ -1744,6 +1753,12 @@ cert_parse_extensions(const char *fn, st
 		if (cert_as_inherit(cert)) {
 			warnx("%s: RFC 8209, 3.1.3.5: BGPsec Router cert "
 			    "with inherit element", fn);
+			goto out;
+		}
+
+		if (!cert_has_one_as(cert)) {
+			warnx("%s: BGPsec Router certs with more than one "
+			    "AS number are not supported", fn);
 			goto out;
 		}
 	}
Index: usr.sbin/rpki-client/parser.c
===================================================================
RCS file: /cvs/src/usr.sbin/rpki-client/parser.c,v
diff -u -p -r1.169 parser.c
--- usr.sbin/rpki-client/parser.c	19 Aug 2025 08:32:24 -0000	1.169
+++ usr.sbin/rpki-client/parser.c	9 Jan 2026 15:56:00 -0000
@@ -589,6 +589,13 @@ proc_parser_cert(char *file, const unsig
 	if (cert == NULL)
 		goto out;
 
+	if (cert->purpose != CERT_PURPOSE_CA &&
+	    cert->purpose != CERT_PURPOSE_BGPSEC_ROUTER) {
+		warnx("%s: %s not allowed in a manifest", file,
+		    purpose2str(cert->purpose));
+		goto out;
+	}
+
 	a = find_issuer(file, entp->certid, cert->aki, entp->mftaki);
 	if (a == NULL)
 		goto out;
