
#ifndef KEDUVOCDOCUMENT_EXPORT_H
#define KEDUVOCDOCUMENT_EXPORT_H

#ifdef KEDUVOCDOCUMENT_STATIC_DEFINE
#  define KEDUVOCDOCUMENT_EXPORT
#  define KEDUVOCDOCUMENT_NO_EXPORT
#else
#  ifndef KEDUVOCDOCUMENT_EXPORT
#    ifdef KEduVocDocument_EXPORTS
        /* We are building this library */
#      define KEDUVOCDOCUMENT_EXPORT __attribute__((visibility("default")))
#    else
        /* We are using this library */
#      define KEDUVOCDOCUMENT_EXPORT __attribute__((visibility("default")))
#    endif
#  endif

#  ifndef KEDUVOCDOCUMENT_NO_EXPORT
#    define KEDUVOCDOCUMENT_NO_EXPORT __attribute__((visibility("hidden")))
#  endif
#endif

#ifndef KEDUVOCDOCUMENT_DECL_DEPRECATED
#  define KEDUVOCDOCUMENT_DECL_DEPRECATED __attribute__ ((__deprecated__))
#endif

#ifndef KEDUVOCDOCUMENT_DECL_DEPRECATED_EXPORT
#  define KEDUVOCDOCUMENT_DECL_DEPRECATED_EXPORT KEDUVOCDOCUMENT_EXPORT KEDUVOCDOCUMENT_DECL_DEPRECATED
#endif

#ifndef KEDUVOCDOCUMENT_DECL_DEPRECATED_NO_EXPORT
#  define KEDUVOCDOCUMENT_DECL_DEPRECATED_NO_EXPORT KEDUVOCDOCUMENT_NO_EXPORT KEDUVOCDOCUMENT_DECL_DEPRECATED
#endif

/* NOLINTNEXTLINE(readability-avoid-unconditional-preprocessor-if) */
#if 0 /* DEFINE_NO_DEPRECATED */
#  ifndef KEDUVOCDOCUMENT_NO_DEPRECATED
#    define KEDUVOCDOCUMENT_NO_DEPRECATED
#  endif
#endif
#include <keduvocdocument_version.h>

#define KEDUVOCDOCUMENT_DECL_DEPRECATED_TEXT(text) __attribute__ ((__deprecated__(text)))

#if defined(KEDUVOCDOCUMENT_NO_DEPRECATED)
#  undef KEDUVOCDOCUMENT_DEPRECATED
#  define KEDUVOCDOCUMENT_DEPRECATED_EXPORT KEDUVOCDOCUMENT_EXPORT
#  define KEDUVOCDOCUMENT_DEPRECATED_NO_EXPORT KEDUVOCDOCUMENT_NO_EXPORT
#elif defined(KEDUVOCDOCUMENT_NO_DEPRECATED_WARNINGS)
#  define KEDUVOCDOCUMENT_DEPRECATED
#  define KEDUVOCDOCUMENT_DEPRECATED_EXPORT KEDUVOCDOCUMENT_EXPORT
#  define KEDUVOCDOCUMENT_DEPRECATED_NO_EXPORT KEDUVOCDOCUMENT_NO_EXPORT
#else
#  define KEDUVOCDOCUMENT_DEPRECATED KEDUVOCDOCUMENT_DECL_DEPRECATED
#  define KEDUVOCDOCUMENT_DEPRECATED_EXPORT KEDUVOCDOCUMENT_DECL_DEPRECATED_EXPORT
#  define KEDUVOCDOCUMENT_DEPRECATED_NO_EXPORT KEDUVOCDOCUMENT_DECL_DEPRECATED_NO_EXPORT
#endif

/* No deprecated API had been removed from build */
#define KEDUVOCDOCUMENT_EXCLUDE_DEPRECATED_BEFORE_AND_AT 0

#define KEDUVOCDOCUMENT_BUILD_DEPRECATED_SINCE(major, minor) 1

#ifdef KEDUVOCDOCUMENT_NO_DEPRECATED
#  define KEDUVOCDOCUMENT_DISABLE_DEPRECATED_BEFORE_AND_AT KEDUVOCDOCUMENT_VERSION
#endif
#ifdef KEDUVOCDOCUMENT_NO_DEPRECATED_WARNINGS
#  define KEDUVOCDOCUMENT_DEPRECATED_WARNINGS_SINCE 0
#endif

#ifndef KEDUVOCDOCUMENT_DEPRECATED_WARNINGS_SINCE
#  ifdef KEDUVOCDOCUMENT_DISABLE_DEPRECATED_BEFORE_AND_AT
#    define KEDUVOCDOCUMENT_DEPRECATED_WARNINGS_SINCE KEDUVOCDOCUMENT_DISABLE_DEPRECATED_BEFORE_AND_AT
#  else
#    define KEDUVOCDOCUMENT_DEPRECATED_WARNINGS_SINCE KEDUVOCDOCUMENT_VERSION
#  endif
#endif

#ifndef KEDUVOCDOCUMENT_DISABLE_DEPRECATED_BEFORE_AND_AT
#  define KEDUVOCDOCUMENT_DISABLE_DEPRECATED_BEFORE_AND_AT 0
#endif

#ifdef KEDUVOCDOCUMENT_DEPRECATED
#  define KEDUVOCDOCUMENT_ENABLE_DEPRECATED_SINCE(major, minor) (((major<<16)|(minor<<8)) > KEDUVOCDOCUMENT_DISABLE_DEPRECATED_BEFORE_AND_AT)
#else
#  define KEDUVOCDOCUMENT_ENABLE_DEPRECATED_SINCE(major, minor) 0
#endif

#endif /* KEDUVOCDOCUMENT_EXPORT_H */
