/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.util;

import java.util.Date;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import net.i2p.I2PAppContext;
import net.i2p.time.BuildTime;
import net.i2p.time.Timestamper;
import net.i2p.util.Log;

public class Clock
implements Timestamper.UpdateListener {
    protected final I2PAppContext _context;
    protected final boolean _isSystemClockBad;
    protected long _startedOn;
    protected boolean _statCreated;
    protected volatile long _offset;
    protected boolean _alreadyChanged;
    private final Set<ClockUpdateListener> _listeners;
    public static final long MAX_OFFSET = 259200000L;
    public static final long MAX_LIVE_OFFSET = 600000L;
    public static final long MIN_OFFSET_CHANGE = 5000L;

    public Clock(I2PAppContext context) {
        this._context = context;
        this._listeners = new CopyOnWriteArraySet<ClockUpdateListener>();
        long now = System.currentTimeMillis();
        long min = BuildTime.getEarliestTime();
        long max = BuildTime.getLatestTime();
        if (now < min) {
            this._offset = min - now;
            System.out.println("ERROR: System clock is invalid: " + new Date(now));
            now = min;
            this._isSystemClockBad = true;
        } else if (now > max) {
            this._offset = max - now;
            System.out.println("ERROR: System clock is invalid: " + new Date(now));
            now = max;
            this._isSystemClockBad = true;
        } else {
            this._isSystemClockBad = false;
        }
        this._startedOn = now;
    }

    public static Clock getInstance() {
        return I2PAppContext.getGlobalContext().clock();
    }

    public Timestamper getTimestamper() {
        return new Timestamper();
    }

    protected Log getLog() {
        return this._context.logManager().getLog(Clock.class);
    }

    public void setOffset(long offsetMs) {
        this.setOffset(offsetMs, false);
    }

    public synchronized void setOffset(long offsetMs, boolean force) {
        long delta = offsetMs - this._offset;
        if (!force) {
            if (!(this._isSystemClockBad || offsetMs <= 259200000L && offsetMs >= -259200000L)) {
                Log log = this.getLog();
                if (log.shouldLog(30)) {
                    log.warn("Maximum offset shift exceeded [" + offsetMs + "], NOT HONORING IT");
                }
                return;
            }
            if (this._alreadyChanged && System.currentTimeMillis() - this._startedOn > 600000L && (delta > 600000L || delta < -600000L)) {
                Log log = this.getLog();
                if (log.shouldLog(30)) {
                    log.warn("The clock has already been updated, but you want to change it by " + delta + " to " + offsetMs + "?  Did something break?");
                }
                return;
            }
            if (delta < 5000L && delta > -5000L) {
                Log log = this.getLog();
                if (log.shouldLog(10)) {
                    log.debug("Not changing offset since it is only " + delta + "ms");
                }
                this._alreadyChanged = true;
                return;
            }
        }
        if (this._alreadyChanged) {
            if (delta > 15000L) {
                this.getLog().log(50, "Updating clock offset to " + offsetMs + "ms from " + this._offset + "ms");
            } else if (this.getLog().shouldLog(20)) {
                this.getLog().info("Updating clock offset to " + offsetMs + "ms from " + this._offset + "ms");
            }
            if (!this._statCreated) {
                this._context.statManager().createRateStat("clock.skew", "Clock step adjustment (ms)", "Clock", new long[]{3600000L});
                this._statCreated = true;
            }
            this._context.statManager().addRateData("clock.skew", delta, 0L);
        } else {
            Log log = this.getLog();
            if (log.shouldLog(20)) {
                log.info("Initializing clock offset to " + offsetMs + "ms from " + this._offset + "ms");
            }
        }
        this._alreadyChanged = true;
        this._offset = offsetMs;
        this.fireOffsetChanged(delta);
    }

    public synchronized long getOffset() {
        return this._offset;
    }

    public boolean getUpdatedSuccessfully() {
        return this._alreadyChanged;
    }

    public void setNow(long realTime) {
        if (realTime < BuildTime.getEarliestTime() || realTime > BuildTime.getLatestTime()) {
            Log log = this.getLog();
            String msg = "Invalid time received: " + new Date(realTime);
            if (log.shouldWarn()) {
                log.warn(msg, new Exception());
            } else {
                log.logAlways(30, msg);
            }
            return;
        }
        long diff = realTime - System.currentTimeMillis();
        this.setOffset(diff);
    }

    @Override
    public void setNow(long realTime, int stratum) {
        this.setNow(realTime);
    }

    public long now() {
        return this._offset + System.currentTimeMillis();
    }

    public void addUpdateListener(ClockUpdateListener lsnr) {
        this._listeners.add(lsnr);
    }

    public void removeUpdateListener(ClockUpdateListener lsnr) {
        this._listeners.remove(lsnr);
    }

    protected void fireOffsetChanged(long delta) {
        for (ClockUpdateListener lsnr : this._listeners) {
            lsnr.offsetChanged(delta);
        }
    }

    public static interface ClockUpdateListener {
        public void offsetChanged(long var1);
    }
}

