/*
 * Copyright (c) 2004, 2005, id Quantique SA, Switzerland
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice, this
 * list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright notice,
 * this list of conditions and the following disclaimer in the documentation
 * and/or other materials provided with the distribution.
 * Neither the name of id Quantique nor the names of its contributors may be
 * used to endorse or promote products derived from this software without
 * specific prior written permission.
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */


#include <iostream>
#include <string>

#include "QuantisCpp.h"

using std::string;

void testAssert(string name, unsigned long value, unsigned long should) {
  if (value != should) {
    std::cerr << name << ": "
	      << value << " should have been " << should
	      << "     [FAILED]" << std::endl;
  } else {
    std::cerr << name << ": "
	      << "Correct value " << value << " [OK]" << std::endl;
  }
}

int main(void) {
  try {
    Quantis::Quantis quantis;

    quantis.reset();
    quantis.setEnabledModules(0xf);

    /* check we have 4 modules */
    testAssert("getModulesMask", quantis.getModulesMask(),
	       Quantis::Quantis::AllModules);
    
    /* read on first module */
    {
      bool noException = true;

      try {
	unsigned char buf[8192];
	quantis.setEnabledModules(Quantis::Quantis::Module1);
	quantis.readBlocking(buf, 8192);
      } catch (std::exception &e) {
	noException = false;
      }

      testAssert("read Module1", noException, true);
    }

    /* disable modules 1, 3, 4 */
    quantis.disableModules(0xd);
    quantis.enableModules(0x2);
    {
      unsigned char buf[8192];
      quantis.readBlocking(buf, 8192);
      /* XXX check that we have a counter */
    }

    quantis.enableModules(0xf);
    unsigned int status = quantis.getModulesStatus();
    std::cerr << "Modules status " << std::hex << status << std::endl;
    
    /* disable modules 1, 2, 4 */
    quantis.disableModules(0xb);
    quantis.enableModules(0x4);

    /* disable modules 1, 2, 3 */
    quantis.disableModules(0x7);
    quantis.enableModules(0x8);
    bool gotError = false;
    try {
      unsigned char buf[8192];
      quantis.readBlocking(buf, 8192);
    } catch (Quantis::QuantisError &e) {
      gotError = true;
    }
    if (!gotError) {
      std::cerr << "Reading from fourth module should have caused a timeout" << std::endl;
    }

    /* disable modules 3, 4 */
    quantis.disableModules(0xc);
    quantis.enableModules(0x3);
    {
      unsigned char buf[8192];
      quantis.readBlocking(buf, 8192);
    /* XXX performance tests */
    }
  } catch (Quantis::QuantisError &e) {
    std::cerr << "Caught an error while doing tests: " << e.getErrorMessage()
	      << std::endl;
  }

  return EXIT_SUCCESS;
}
