/*	$NetBSD: $ */

/*-
 * Copyright (c) 2008 The NetBSD Foundation, Inc.
 * All rights reserved.
 *
 * This code is derived from software contributed to The NetBSD Foundation
 * by Robert Swindells
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE NETBSD FOUNDATION, INC. AND CONTRIBUTORS
 * ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED
 * TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE FOUNDATION OR CONTRIBUTORS
 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

#include <sys/cdefs.h>
__KERNEL_RCSID(0, "$NetBSD: $");

#include "opt_interrupt.h"

#include <sys/param.h>
#include <sys/systm.h>
#include <sys/malloc.h>
#include <sys/kernel.h>

#include <uvm/uvm_extern.h>

#include <machine/pio.h>

#include <dev/ofw/openfirm.h>

#include <machine/autoconf.h>

#include <arch/powerpc/mpc5200/mpc5200reg.h>
#include <arch/powerpc/mpc5200/mpc5200var.h>

static int obio_match(device_t, cfdata_t, void *);
static void obio_attach(device_t, device_t, void *);

struct obio_softc {
	device_t	sc;
	bus_space_tag_t	iot;
	bus_space_
};

CFATTACH_DECL_NEW(obio, sizeof(struct obio_softc),
	obio_match, obio_attach, NULL, NULL);

static int
obio_match(device_t parent, cfdata_t cf, void *aux)
{
	struct confargs *ca = aux;
#if 0
	char name[32];
#endif

	if (strcmp(ca->ca_name, "builtin") != 0)
		return 0;

#if 0
	OF_getprop(ca->ca_node, "compatible", name, sizeof(name));
	if (strcmp(name, "mpc5200-ohci") != 0)
		return 0;
#endif

	return 1;
}

static void
obio_attach(device_t parent, device_t self, void *aux)
{
	struct obio_softc *sc = device_private(self);
	struct confargs *ca = aux;
	struct reg {
		uint32_t addr;
		uint32_t size;
	} range, *rp = &range;
	int node = ca->ca_node;

	sc->sc_dev = self;

	aprint_normal("\n");

	sc->sc_iot.pbs_flags = _BUS_SPACE_MEM_TYPE;
	sc->sc_iot.pbs_base = 0x00000000;
	if (ofwoea_map_space(RANGE_TYPE_SOC, RANGE_MEM, node, &sc->sc_iot,
			     "obio") != 0)
		/*panic("Can't init obio tag");*/
		aprint_normal_dev(self, "Can't init obio tag");

	aprint_normal_dev(self, "id %x\n", in32(baseaddr + USBHC_RR));
#if 0
	bus_space_map(sc->sc.iot, rp->addr, rp->size, 0, &sc->sc.ioh);
	aprint_normal_dev(self, "id %x\n",
		      bus_space_read_4(sc->sc.iot, sc->sc.ioh, USBHC_RR));
#endif
}

