/*
 * Decompiled with CFR 0.152.
 */
package sun.security.ssl;

import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.SecureRandom;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContextSpi;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLServerSocketFactory;
import javax.net.ssl.SSLSessionContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509ExtendedKeyManager;
import javax.net.ssl.X509KeyManager;
import javax.net.ssl.X509TrustManager;
import sun.security.ssl.AbstractWrapper;
import sun.security.ssl.Debug;
import sun.security.ssl.DummyX509KeyManager;
import sun.security.ssl.DummyX509TrustManager;
import sun.security.ssl.EphemeralKeyManager;
import sun.security.ssl.JsseJce;
import sun.security.ssl.SSLEngineImpl;
import sun.security.ssl.SSLServerSocketFactoryImpl;
import sun.security.ssl.SSLSessionContextImpl;
import sun.security.ssl.SSLSocketFactoryImpl;
import sun.security.ssl.SunJSSE;
import sun.security.ssl.SunX509KeyManagerImpl;
import sun.security.ssl.X509KeyManagerImpl;
import sun.security.ssl.X509TrustManagerImpl;

public class SSLContextImpl
extends SSLContextSpi {
    private static final Debug debug = Debug.getInstance("ssl");
    private final EphemeralKeyManager ephemeralKeyManager;
    private final SSLSessionContextImpl clientCache;
    private final SSLSessionContextImpl serverCache;
    private boolean isInitialized;
    private X509ExtendedKeyManager keyManager;
    private X509TrustManager trustManager;
    private SecureRandom secureRandom;

    public SSLContextImpl() {
        this(null);
    }

    SSLContextImpl(SSLContextImpl sSLContextImpl) {
        if (sSLContextImpl == null) {
            this.ephemeralKeyManager = new EphemeralKeyManager();
            this.clientCache = new SSLSessionContextImpl();
            this.serverCache = new SSLSessionContextImpl();
        } else {
            this.ephemeralKeyManager = sSLContextImpl.ephemeralKeyManager;
            this.clientCache = sSLContextImpl.clientCache;
            this.serverCache = sSLContextImpl.serverCache;
        }
    }

    protected void engineInit(KeyManager[] keyManagerArray, TrustManager[] trustManagerArray, SecureRandom secureRandom) throws KeyManagementException {
        this.isInitialized = false;
        this.keyManager = this.chooseKeyManager(keyManagerArray);
        if (trustManagerArray == null) {
            try {
                TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
                trustManagerFactory.init((KeyStore)null);
                trustManagerArray = trustManagerFactory.getTrustManagers();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.trustManager = this.chooseTrustManager(trustManagerArray);
        if (secureRandom == null) {
            this.secureRandom = JsseJce.getSecureRandom();
        } else {
            if (SunJSSE.isFIPS() && secureRandom.getProvider() != SunJSSE.cryptoProvider) {
                throw new KeyManagementException("FIPS mode: SecureRandom must be from provider " + SunJSSE.cryptoProvider.getName());
            }
            this.secureRandom = secureRandom;
        }
        if (debug != null && Debug.isOn("sslctx")) {
            System.out.println("trigger seeding of SecureRandom");
        }
        this.secureRandom.nextInt();
        if (debug != null && Debug.isOn("sslctx")) {
            System.out.println("done seeding SecureRandom");
        }
        this.isInitialized = true;
    }

    private X509TrustManager chooseTrustManager(TrustManager[] trustManagerArray) throws KeyManagementException {
        for (int i = 0; trustManagerArray != null && i < trustManagerArray.length; ++i) {
            if (!(trustManagerArray[i] instanceof X509TrustManager)) continue;
            if (SunJSSE.isFIPS() && !(trustManagerArray[i] instanceof X509TrustManagerImpl)) {
                throw new KeyManagementException("FIPS mode: only SunJSSE TrustManagers may be used");
            }
            return (X509TrustManager)trustManagerArray[i];
        }
        return DummyX509TrustManager.INSTANCE;
    }

    private X509ExtendedKeyManager chooseKeyManager(KeyManager[] keyManagerArray) throws KeyManagementException {
        for (int i = 0; keyManagerArray != null && i < keyManagerArray.length; ++i) {
            KeyManager keyManager = keyManagerArray[i];
            if (!(keyManager instanceof X509KeyManager)) continue;
            if (SunJSSE.isFIPS()) {
                if (keyManager instanceof X509KeyManagerImpl || keyManager instanceof SunX509KeyManagerImpl) {
                    return (X509ExtendedKeyManager)keyManager;
                }
                throw new KeyManagementException("FIPS mode: only SunJSSE KeyManagers may be used");
            }
            if (keyManager instanceof X509ExtendedKeyManager) {
                return (X509ExtendedKeyManager)keyManager;
            }
            if (debug != null && Debug.isOn("sslctx")) {
                System.out.println("X509KeyManager passed to SSLContext.init():  need an X509ExtendedKeyManager for SSLEngine use");
            }
            return new AbstractWrapper((X509KeyManager)keyManager);
        }
        return DummyX509KeyManager.INSTANCE;
    }

    protected SSLSocketFactory engineGetSocketFactory() {
        if (!this.isInitialized) {
            throw new IllegalStateException("SSLContextImpl is not initialized");
        }
        return new SSLSocketFactoryImpl(this);
    }

    protected SSLServerSocketFactory engineGetServerSocketFactory() {
        if (!this.isInitialized) {
            throw new IllegalStateException("SSLContext is not initialized");
        }
        return new SSLServerSocketFactoryImpl(this);
    }

    protected SSLEngine engineCreateSSLEngine() {
        if (!this.isInitialized) {
            throw new IllegalStateException("SSLContextImpl is not initialized");
        }
        return new SSLEngineImpl(this);
    }

    protected SSLEngine engineCreateSSLEngine(String string, int n) {
        if (!this.isInitialized) {
            throw new IllegalStateException("SSLContextImpl is not initialized");
        }
        return new SSLEngineImpl(this, string, n);
    }

    protected SSLSessionContext engineGetClientSessionContext() {
        return this.clientCache;
    }

    protected SSLSessionContext engineGetServerSessionContext() {
        return this.serverCache;
    }

    SecureRandom getSecureRandom() {
        return this.secureRandom;
    }

    X509ExtendedKeyManager getX509KeyManager() {
        return this.keyManager;
    }

    X509TrustManager getX509TrustManager() {
        return this.trustManager;
    }

    EphemeralKeyManager getEphemeralKeyManager() {
        return this.ephemeralKeyManager;
    }
}

