/*
 * Decompiled with CFR 0.152.
 */
package sun.security.ssl;

import java.io.IOException;
import java.io.PrintStream;
import java.security.PublicKey;
import java.security.interfaces.ECPublicKey;
import java.security.spec.ECParameterSpec;
import java.security.spec.ECPoint;
import sun.security.ssl.Debug;
import sun.security.ssl.HandshakeInStream;
import sun.security.ssl.HandshakeMessage;
import sun.security.ssl.HandshakeOutStream;
import sun.security.ssl.JsseJce;

final class ECDHClientKeyExchange
extends HandshakeMessage {
    private byte[] encodedPoint;

    int messageType() {
        return 16;
    }

    byte[] getEncodedPoint() {
        return this.encodedPoint;
    }

    ECDHClientKeyExchange(PublicKey publicKey) {
        ECPublicKey eCPublicKey = (ECPublicKey)publicKey;
        ECPoint eCPoint = eCPublicKey.getW();
        ECParameterSpec eCParameterSpec = eCPublicKey.getParams();
        this.encodedPoint = JsseJce.encodePoint(eCPoint, eCParameterSpec.getCurve());
    }

    ECDHClientKeyExchange(HandshakeInStream handshakeInStream) throws IOException {
        this.encodedPoint = handshakeInStream.getBytes8();
    }

    int messageLength() {
        return this.encodedPoint.length + 1;
    }

    void send(HandshakeOutStream handshakeOutStream) throws IOException {
        handshakeOutStream.putBytes8(this.encodedPoint);
    }

    void print(PrintStream printStream) throws IOException {
        printStream.println("*** ECDHClientKeyExchange");
        if (debug != null && Debug.isOn("verbose")) {
            Debug.println(printStream, "ECDH Public value", this.encodedPoint);
        }
    }
}

