/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.X11;

import java.awt.Component;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ComponentEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import sun.awt.ComponentAccessor;
import sun.awt.X11.WindowDimensions;
import sun.awt.X11.XCreateWindowParams;
import sun.awt.X11.XDecoratedPeer;
import sun.awt.X11.XEvent;
import sun.awt.X11.XFramePeer;
import sun.awt.X11.XToolkit;
import sun.awt.X11.XWindow;

public final class XContentWindow
extends XWindow {
    private static Logger insLog = Logger.getLogger("sun.awt.X11.insets.XContentWindow");
    private final XDecoratedPeer parentFrame;
    private final List<SavedExposeEvent> iconifiedExposeEvents = new ArrayList<SavedExposeEvent>();

    static XContentWindow createContent(XDecoratedPeer xDecoratedPeer) {
        WindowDimensions windowDimensions = xDecoratedPeer.getDimensions();
        Rectangle rectangle = windowDimensions.getBounds();
        Insets insets = windowDimensions.getInsets();
        if (insets != null) {
            rectangle.x = -insets.left;
            rectangle.y = -insets.top;
        } else {
            rectangle.x = 0;
            rectangle.y = 0;
        }
        XContentWindow xContentWindow = new XContentWindow(xDecoratedPeer, rectangle);
        xContentWindow.xSetVisible(true);
        return xContentWindow;
    }

    private XContentWindow(XDecoratedPeer xDecoratedPeer, Rectangle rectangle) {
        super((Component)xDecoratedPeer.getTarget(), xDecoratedPeer.getShell(), rectangle);
        this.parentFrame = xDecoratedPeer;
    }

    void preInit(XCreateWindowParams xCreateWindowParams) {
        super.preInit(xCreateWindowParams);
        xCreateWindowParams.putIfNull((Object)"bit gravity", (Object)1);
        Long l = (Long)xCreateWindowParams.get("event mask");
        if (l != null) {
            l = l & 0xFFFFFFFFFFFDFFFFL;
            xCreateWindowParams.put("event mask", l);
        }
    }

    protected String getWMName() {
        return "Content window";
    }

    protected boolean isEventDisabled(XEvent xEvent) {
        switch (xEvent.get_type()) {
            case 7: 
            case 8: {
                return false;
            }
            case 22: {
                return true;
            }
            case 18: 
            case 19: {
                return true;
            }
        }
        return super.isEventDisabled(xEvent) || this.parentFrame.isEventDisabled(xEvent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setContentBounds(WindowDimensions windowDimensions) {
        XToolkit.awtLock();
        try {
            Rectangle rectangle = windowDimensions.getBounds();
            Insets insets = windowDimensions.getInsets();
            if (insets != null) {
                rectangle.setLocation(-insets.left, -insets.top);
            }
            if (insLog.isLoggable(Level.FINE)) {
                insLog.log(Level.FINE, "Setting content bounds {0}, old bounds {1}", new Object[]{rectangle, this.getBounds()});
            }
            boolean bl = !rectangle.equals(this.getBounds());
            this.reshape(rectangle);
            if (bl) {
                insLog.fine("Sending RESIZED");
                this.handleResize(rectangle);
            }
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            XToolkit.awtUnlock();
            throw throwable;
        }
        XToolkit.awtUnlock();
        this.validateSurface();
    }

    public void handleResize(Rectangle rectangle) {
        ComponentAccessor.setWidth(this.target, rectangle.width);
        ComponentAccessor.setHeight(this.target, rectangle.height);
        this.postEvent(new ComponentEvent(this.target, 101));
    }

    public void handleExposeEvent(Component component, int n, int n2, int n3, int n4) {
        if (this.parentFrame instanceof XFramePeer && (((XFramePeer)this.parentFrame).getState() & 1) != 0) {
            this.iconifiedExposeEvents.add(new SavedExposeEvent(component, n, n2, n3, n4));
        } else {
            super.handleExposeEvent(component, n, n2, n3, n4);
        }
    }

    void purgeIconifiedExposeEvents() {
        for (SavedExposeEvent savedExposeEvent : this.iconifiedExposeEvents) {
            super.handleExposeEvent(savedExposeEvent.target, savedExposeEvent.x, savedExposeEvent.y, savedExposeEvent.w, savedExposeEvent.h);
        }
        this.iconifiedExposeEvents.clear();
    }

    public String toString() {
        return this.getClass().getName() + "[" + this.getBounds() + "]";
    }

    private static class SavedExposeEvent {
        Component target;
        int x;
        int y;
        int w;
        int h;

        SavedExposeEvent(Component component, int n, int n2, int n3, int n4) {
            this.target = component;
            this.x = n;
            this.y = n2;
            this.w = n3;
            this.h = n4;
        }
    }
}

