/*
 * Decompiled with CFR 0.152.
 */
package java.awt.image;

import java.awt.image.DataBuffer;
import sun.java2d.StateTrackable;

public final class DataBufferUShort
extends DataBuffer {
    short[] data;
    short[][] bankdata;

    public DataBufferUShort(int n) {
        super(StateTrackable.State.STABLE, 1, n);
        this.data = new short[n];
        this.bankdata = new short[1][];
        this.bankdata[0] = this.data;
    }

    public DataBufferUShort(int n, int n2) {
        super(StateTrackable.State.STABLE, 1, n, n2);
        this.bankdata = new short[n2][];
        for (int i = 0; i < n2; ++i) {
            this.bankdata[i] = new short[n];
        }
        this.data = this.bankdata[0];
    }

    public DataBufferUShort(short[] sArray, int n) {
        super(StateTrackable.State.UNTRACKABLE, 1, n);
        if (sArray == null) {
            throw new NullPointerException("dataArray is null");
        }
        this.data = sArray;
        this.bankdata = new short[1][];
        this.bankdata[0] = this.data;
    }

    public DataBufferUShort(short[] sArray, int n, int n2) {
        super(StateTrackable.State.UNTRACKABLE, 1, n, 1, n2);
        if (sArray == null) {
            throw new NullPointerException("dataArray is null");
        }
        if (n + n2 > sArray.length) {
            throw new IllegalArgumentException("Length of dataArray is less  than size+offset.");
        }
        this.data = sArray;
        this.bankdata = new short[1][];
        this.bankdata[0] = this.data;
    }

    public DataBufferUShort(short[][] sArray, int n) {
        super(StateTrackable.State.UNTRACKABLE, 1, n, sArray.length);
        if (sArray == null) {
            throw new NullPointerException("dataArray is null");
        }
        for (int i = 0; i < sArray.length; ++i) {
            if (sArray[i] != null) continue;
            throw new NullPointerException("dataArray[" + i + "] is null");
        }
        this.bankdata = (short[][])sArray.clone();
        this.data = this.bankdata[0];
    }

    public DataBufferUShort(short[][] sArray, int n, int[] nArray) {
        super(StateTrackable.State.UNTRACKABLE, 1, n, sArray.length, nArray);
        if (sArray == null) {
            throw new NullPointerException("dataArray is null");
        }
        for (int i = 0; i < sArray.length; ++i) {
            if (sArray[i] == null) {
                throw new NullPointerException("dataArray[" + i + "] is null");
            }
            if (n + nArray[i] <= sArray[i].length) continue;
            throw new IllegalArgumentException("Length of dataArray[" + i + "] is less than size+" + "offsets[" + i + "].");
        }
        this.bankdata = (short[][])sArray.clone();
        this.data = this.bankdata[0];
    }

    public short[] getData() {
        this.theTrackable.setUntrackable();
        return this.data;
    }

    public short[] getData(int n) {
        this.theTrackable.setUntrackable();
        return this.bankdata[n];
    }

    public short[][] getBankData() {
        this.theTrackable.setUntrackable();
        return (short[][])this.bankdata.clone();
    }

    public int getElem(int n) {
        return this.data[n + this.offset] & 0xFFFF;
    }

    public int getElem(int n, int n2) {
        return this.bankdata[n][n2 + this.offsets[n]] & 0xFFFF;
    }

    public void setElem(int n, int n2) {
        this.data[n + this.offset] = (short)(n2 & 0xFFFF);
        this.theTrackable.markDirty();
    }

    public void setElem(int n, int n2, int n3) {
        this.bankdata[n][n2 + this.offsets[n]] = (short)(n3 & 0xFFFF);
        this.theTrackable.markDirty();
    }
}

