/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.fastinfoset.stax;

import com.sun.xml.internal.fastinfoset.CommonResourceBundle;
import com.sun.xml.internal.fastinfoset.Encoder;
import com.sun.xml.internal.fastinfoset.stax.StAXManager;
import java.io.IOException;
import java.io.OutputStream;
import java.util.EmptyStackException;
import java.util.Enumeration;
import java.util.Iterator;
import javax.xml.namespace.NamespaceContext;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.xml.sax.helpers.NamespaceSupport;

public class StAXDocumentSerializer
extends Encoder
implements XMLStreamWriter {
    protected StAXManager _manager;
    protected String _encoding;
    protected String _currentLocalName;
    protected String _currentUri;
    protected String _currentPrefix;
    protected boolean _inStartElement = false;
    protected boolean _isEmptyElement = false;
    protected String[] _attributesArray = new String[64];
    protected int _attributesArrayIndex = 0;
    protected NamespaceSupport _nsSupport = new NamespaceSupport();
    protected boolean[] _nsSupportContextStack = new boolean[32];
    protected int _stackCount = -1;
    protected NamespaceContext _nsContext = new NamespaceContextImpl();
    protected String[] _namespacesArray = new String[16];
    protected int _namespacesArrayIndex = 0;

    public StAXDocumentSerializer() {
        super(true);
    }

    public StAXDocumentSerializer(OutputStream outputStream) {
        super(true);
        this.setOutputStream(outputStream);
    }

    public StAXDocumentSerializer(OutputStream outputStream, StAXManager stAXManager) {
        super(true);
        this.setOutputStream(outputStream);
        this._manager = stAXManager;
    }

    public void reset() {
        super.reset();
        this._attributesArrayIndex = 0;
        this._namespacesArrayIndex = 0;
        this._nsSupport.reset();
        this._stackCount = -1;
        this._currentPrefix = null;
        this._currentUri = null;
        this._currentLocalName = null;
        this._isEmptyElement = false;
        this._inStartElement = false;
    }

    public void writeStartDocument() throws XMLStreamException {
        this.writeStartDocument("finf", "1.0");
    }

    public void writeStartDocument(String string) throws XMLStreamException {
        this.writeStartDocument("finf", string);
    }

    public void writeStartDocument(String string, String string2) throws XMLStreamException {
        this.reset();
        try {
            this.encodeHeader(false);
            this.encodeInitialVocabulary();
        }
        catch (IOException iOException) {
            throw new XMLStreamException(iOException);
        }
    }

    public void writeEndDocument() throws XMLStreamException {
        if (this._inStartElement) {
            // empty if block
        }
        try {
            this.encodeDocumentTermination();
        }
        catch (IOException iOException) {
            throw new XMLStreamException(iOException);
        }
    }

    public void close() throws XMLStreamException {
        this.reset();
    }

    public void flush() throws XMLStreamException {
        try {
            this._s.flush();
        }
        catch (IOException iOException) {
            throw new XMLStreamException(iOException);
        }
    }

    public void writeStartElement(String string) throws XMLStreamException {
        this.writeStartElement("", string, "");
    }

    public void writeStartElement(String string, String string2) throws XMLStreamException {
        this.writeStartElement(this.getPrefix(string), string2, string);
    }

    public void writeStartElement(String string, String string2, String string3) throws XMLStreamException {
        this.encodeTerminationAndCurrentElement(false);
        this._inStartElement = true;
        this._isEmptyElement = false;
        this._currentLocalName = string2;
        this._currentPrefix = string;
        this._currentUri = string3;
        ++this._stackCount;
        if (this._stackCount == this._nsSupportContextStack.length) {
            boolean[] blArray = new boolean[this._stackCount * 2];
            System.arraycopy(this._nsSupportContextStack, 0, blArray, 0, this._nsSupportContextStack.length);
            this._nsSupportContextStack = blArray;
        }
        this._nsSupportContextStack[this._stackCount] = false;
    }

    public void writeEmptyElement(String string) throws XMLStreamException {
        this.writeEmptyElement("", string, "");
    }

    public void writeEmptyElement(String string, String string2) throws XMLStreamException {
        this.writeEmptyElement(this.getPrefix(string), string2, string);
    }

    public void writeEmptyElement(String string, String string2, String string3) throws XMLStreamException {
        this.encodeTerminationAndCurrentElement(false);
        this._inStartElement = true;
        this._isEmptyElement = true;
        this._currentLocalName = string2;
        this._currentPrefix = string;
        this._currentUri = string3;
        ++this._stackCount;
        if (this._stackCount == this._nsSupportContextStack.length) {
            boolean[] blArray = new boolean[this._stackCount * 2];
            System.arraycopy(this._nsSupportContextStack, 0, blArray, 0, this._nsSupportContextStack.length);
            this._nsSupportContextStack = blArray;
        }
        this._nsSupportContextStack[this._stackCount] = false;
    }

    public void writeEndElement() throws XMLStreamException {
        if (this._inStartElement) {
            this.encodeTerminationAndCurrentElement(false);
        }
        try {
            this.encodeElementTermination();
            if (this._nsSupportContextStack[this._stackCount--]) {
                this._nsSupport.popContext();
            }
        }
        catch (IOException iOException) {
            throw new XMLStreamException(iOException);
        }
        catch (EmptyStackException emptyStackException) {
            throw new XMLStreamException(emptyStackException);
        }
    }

    public void writeAttribute(String string, String string2) throws XMLStreamException {
        this.writeAttribute("", "", string, string2);
    }

    public void writeAttribute(String string, String string2, String string3) throws XMLStreamException {
        String string4 = "";
        if (string.length() > 0 && ((string4 = this._nsSupport.getPrefix(string)) == null || string4.length() == 0)) {
            if (string == "http://www.w3.org/2000/xmlns/" || string.equals("http://www.w3.org/2000/xmlns/")) {
                return;
            }
            throw new XMLStreamException(CommonResourceBundle.getInstance().getString("message.URIUnbound", new Object[]{string}));
        }
        this.writeAttribute(string4, string, string2, string3);
    }

    public void writeAttribute(String string, String string2, String string3, String string4) throws XMLStreamException {
        if (!this._inStartElement) {
            throw new IllegalStateException(CommonResourceBundle.getInstance().getString("message.attributeWritingNotAllowed"));
        }
        if (string2 == "http://www.w3.org/2000/xmlns/" || string2.equals("http://www.w3.org/2000/xmlns/")) {
            return;
        }
        if (this._attributesArrayIndex == this._attributesArray.length) {
            String[] stringArray = new String[this._attributesArrayIndex * 2];
            System.arraycopy(this._attributesArray, 0, stringArray, 0, this._attributesArrayIndex);
            this._attributesArray = stringArray;
        }
        this._attributesArray[this._attributesArrayIndex++] = string2;
        this._attributesArray[this._attributesArrayIndex++] = string;
        this._attributesArray[this._attributesArrayIndex++] = string3;
        this._attributesArray[this._attributesArrayIndex++] = string4;
    }

    public void writeNamespace(String string, String string2) throws XMLStreamException {
        if (string == null || string.length() == 0 || string.equals("xmlns")) {
            this.writeDefaultNamespace(string2);
        } else {
            if (!this._inStartElement) {
                throw new IllegalStateException(CommonResourceBundle.getInstance().getString("message.attributeWritingNotAllowed"));
            }
            if (this._namespacesArrayIndex == this._namespacesArray.length) {
                String[] stringArray = new String[this._namespacesArrayIndex * 2];
                System.arraycopy(this._namespacesArray, 0, stringArray, 0, this._namespacesArrayIndex);
                this._namespacesArray = stringArray;
            }
            this._namespacesArray[this._namespacesArrayIndex++] = string;
            this._namespacesArray[this._namespacesArrayIndex++] = string2;
        }
    }

    public void writeDefaultNamespace(String string) throws XMLStreamException {
        if (!this._inStartElement) {
            throw new IllegalStateException(CommonResourceBundle.getInstance().getString("message.attributeWritingNotAllowed"));
        }
        if (this._namespacesArrayIndex == this._namespacesArray.length) {
            String[] stringArray = new String[this._namespacesArrayIndex * 2];
            System.arraycopy(this._namespacesArray, 0, stringArray, 0, this._namespacesArrayIndex);
            this._namespacesArray = stringArray;
        }
        this._namespacesArray[this._namespacesArrayIndex++] = "";
        this._namespacesArray[this._namespacesArrayIndex++] = string;
    }

    public void writeComment(String string) throws XMLStreamException {
        try {
            if (this.getIgnoreComments()) {
                return;
            }
            this.encodeTerminationAndCurrentElement(true);
            this.encodeComment(string.toCharArray(), 0, string.length());
        }
        catch (IOException iOException) {
            throw new XMLStreamException(iOException);
        }
    }

    public void writeProcessingInstruction(String string) throws XMLStreamException {
        this.writeProcessingInstruction(string, "");
    }

    public void writeProcessingInstruction(String string, String string2) throws XMLStreamException {
        try {
            if (this.getIgnoreProcesingInstructions()) {
                return;
            }
            this.encodeTerminationAndCurrentElement(true);
            this.encodeProcessingInstruction(string, string2);
        }
        catch (IOException iOException) {
            throw new XMLStreamException(iOException);
        }
    }

    public void writeCData(String string) throws XMLStreamException {
        throw new UnsupportedOperationException(CommonResourceBundle.getInstance().getString("message.notImplemented"));
    }

    public void writeDTD(String string) throws XMLStreamException {
        throw new UnsupportedOperationException(CommonResourceBundle.getInstance().getString("message.notImplemented"));
    }

    public void writeEntityRef(String string) throws XMLStreamException {
        throw new UnsupportedOperationException(CommonResourceBundle.getInstance().getString("message.notImplemented"));
    }

    public void writeCharacters(String string) throws XMLStreamException {
        try {
            int n = string.length();
            if (n == 0) {
                return;
            }
            if (n < this._charBuffer.length) {
                if (this.getIgnoreWhiteSpaceTextContent() && StAXDocumentSerializer.isWhiteSpace(string)) {
                    return;
                }
                this.encodeTerminationAndCurrentElement(true);
                string.getChars(0, n, this._charBuffer, 0);
                this.encodeCharacters(this._charBuffer, 0, n);
            } else {
                char[] cArray = string.toCharArray();
                if (this.getIgnoreWhiteSpaceTextContent() && StAXDocumentSerializer.isWhiteSpace(cArray, 0, n)) {
                    return;
                }
                this.encodeTerminationAndCurrentElement(true);
                this.encodeCharactersNoClone(cArray, 0, n);
            }
        }
        catch (IOException iOException) {
            throw new XMLStreamException(iOException);
        }
    }

    public void writeCharacters(char[] cArray, int n, int n2) throws XMLStreamException {
        try {
            if (n2 <= 0) {
                return;
            }
            if (this.getIgnoreWhiteSpaceTextContent() && StAXDocumentSerializer.isWhiteSpace(cArray, n, n2)) {
                return;
            }
            this.encodeTerminationAndCurrentElement(true);
            this.encodeCharacters(cArray, n, n2);
        }
        catch (IOException iOException) {
            throw new XMLStreamException(iOException);
        }
    }

    public String getPrefix(String string) throws XMLStreamException {
        return this._nsSupport.getPrefix(string);
    }

    public void setPrefix(String string, String string2) throws XMLStreamException {
        if (this._stackCount > -1 && !this._nsSupportContextStack[this._stackCount]) {
            this._nsSupportContextStack[this._stackCount] = true;
            this._nsSupport.pushContext();
        }
        this._nsSupport.declarePrefix(string, string2);
    }

    public void setDefaultNamespace(String string) throws XMLStreamException {
        this.setPrefix("", string);
    }

    public void setNamespaceContext(NamespaceContext namespaceContext) throws XMLStreamException {
        throw new UnsupportedOperationException("setNamespaceContext");
    }

    public NamespaceContext getNamespaceContext() {
        return this._nsContext;
    }

    public Object getProperty(String string) throws IllegalArgumentException {
        if (this._manager != null) {
            return this._manager.getProperty(string);
        }
        return null;
    }

    public void setManager(StAXManager stAXManager) {
        this._manager = stAXManager;
    }

    public void setEncoding(String string) {
        this._encoding = string;
    }

    public void writeOctets(byte[] byArray, int n, int n2) throws XMLStreamException {
        try {
            if (n2 == 0) {
                return;
            }
            this.encodeTerminationAndCurrentElement(true);
            this.encodeCIIOctetAlgorithmData(1, byArray, n, n2);
        }
        catch (IOException iOException) {
            throw new XMLStreamException(iOException);
        }
    }

    protected void encodeTerminationAndCurrentElement(boolean bl) throws XMLStreamException {
        try {
            this.encodeTermination();
            if (this._inStartElement) {
                int n;
                this._b = 0;
                if (this._attributesArrayIndex > 0) {
                    this._b |= 0x40;
                }
                if (this._namespacesArrayIndex > 0) {
                    this.write(this._b | 0x38);
                    n = 0;
                    while (n < this._namespacesArrayIndex) {
                        this.encodeNamespaceAttribute(this._namespacesArray[n++], this._namespacesArray[n++]);
                    }
                    this._namespacesArrayIndex = 0;
                    this.write(240);
                    this._b = 0;
                }
                this.encodeElementQualifiedNameOnThirdBit(this._currentUri, this._currentPrefix, this._currentLocalName);
                n = 0;
                while (n < this._attributesArrayIndex) {
                    this.encodeAttributeQualifiedNameOnSecondBit(this._attributesArray[n++], this._attributesArray[n++], this._attributesArray[n++]);
                    String string = this._attributesArray[n];
                    this._attributesArray[n++] = null;
                    boolean bl2 = string.length() < this.attributeValueSizeConstraint;
                    this.encodeNonIdentifyingStringOnFirstBit(string, this._v.attributeValue, bl2);
                    this._b = 240;
                    this._terminate = true;
                }
                this._attributesArrayIndex = 0;
                this._inStartElement = false;
                if (this._isEmptyElement) {
                    this.encodeElementTermination();
                    if (this._nsSupportContextStack[this._stackCount--]) {
                        this._nsSupport.popContext();
                    }
                    this._isEmptyElement = false;
                }
                if (bl) {
                    this.encodeTermination();
                }
            }
        }
        catch (IOException iOException) {
            throw new XMLStreamException(iOException);
        }
    }

    protected class NamespaceContextImpl
    implements NamespaceContext {
        protected NamespaceContextImpl() {
        }

        public final String getNamespaceURI(String string) {
            return StAXDocumentSerializer.this._nsSupport.getURI(string);
        }

        public final String getPrefix(String string) {
            return StAXDocumentSerializer.this._nsSupport.getPrefix(string);
        }

        public final Iterator getPrefixes(String string) {
            final Enumeration enumeration = StAXDocumentSerializer.this._nsSupport.getPrefixes(string);
            return new Iterator(){

                public boolean hasNext() {
                    return enumeration.hasMoreElements();
                }

                public Object next() {
                    return enumeration.nextElement();
                }

                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }
    }
}

