/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jmx.namespace;

import com.sun.jmx.defaults.JmxProperties;
import com.sun.jmx.mbeanserver.Util;
import java.io.IOException;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.IntrospectionException;
import javax.management.InvalidAttributeValueException;
import javax.management.JMRuntimeException;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServerConnection;
import javax.management.NotCompliantMBeanException;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.management.QueryExp;
import javax.management.ReflectionException;
import javax.management.RuntimeMBeanException;
import javax.management.RuntimeOperationsException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class RoutingMBeanServerConnection<T extends MBeanServerConnection>
implements MBeanServerConnection {
    private static final Logger LOG = JmxProperties.NAMESPACE_LOGGER;

    protected abstract T source() throws IOException;

    protected abstract ObjectName toSource(ObjectName var1);

    protected abstract ObjectName toTarget(ObjectName var1);

    protected ObjectName newSourceMBeanName(ObjectName objectName) throws MBeanRegistrationException {
        try {
            return this.toSource(objectName);
        }
        catch (Exception exception) {
            throw new MBeanRegistrationException(exception, "Illegal MBean Name");
        }
    }

    ObjectName toSourceOrRuntime(ObjectName objectName) {
        try {
            return this.toSource(objectName);
        }
        catch (RuntimeException runtimeException) {
            throw this.makeCompliantRuntimeException(runtimeException);
        }
    }

    RuntimeException makeCompliantRuntimeException(Exception exception) {
        if (exception instanceof SecurityException) {
            return (SecurityException)exception;
        }
        if (exception instanceof JMRuntimeException) {
            return (JMRuntimeException)exception;
        }
        if (exception instanceof RuntimeException) {
            return new RuntimeOperationsException((RuntimeException)exception);
        }
        if (exception instanceof IOException) {
            return Util.newRuntimeIOException((IOException)exception);
        }
        UndeclaredThrowableException undeclaredThrowableException = new UndeclaredThrowableException(exception);
        return new RuntimeOperationsException(undeclaredThrowableException);
    }

    @Override
    public AttributeList getAttributes(ObjectName objectName, String[] stringArray) throws InstanceNotFoundException, ReflectionException, IOException {
        ObjectName objectName2 = this.toSourceOrRuntime(objectName);
        try {
            return this.source().getAttributes(objectName2, stringArray);
        }
        catch (RuntimeException runtimeException) {
            throw this.makeCompliantRuntimeException(runtimeException);
        }
    }

    @Override
    public Object invoke(ObjectName objectName, String string, Object[] objectArray, String[] stringArray) throws InstanceNotFoundException, MBeanException, ReflectionException, IOException {
        ObjectName objectName2 = this.toSourceOrRuntime(objectName);
        try {
            Object object = this.source().invoke(objectName2, string, objectArray, stringArray);
            return object;
        }
        catch (RuntimeException runtimeException) {
            throw this.makeCompliantRuntimeException(runtimeException);
        }
    }

    @Override
    public void unregisterMBean(ObjectName objectName) throws InstanceNotFoundException, MBeanRegistrationException, IOException {
        ObjectName objectName2 = this.toSourceOrRuntime(objectName);
        try {
            this.source().unregisterMBean(objectName2);
        }
        catch (RuntimeException runtimeException) {
            throw this.makeCompliantRuntimeException(runtimeException);
        }
    }

    @Override
    public MBeanInfo getMBeanInfo(ObjectName objectName) throws InstanceNotFoundException, IntrospectionException, ReflectionException, IOException {
        ObjectName objectName2 = this.toSourceOrRuntime(objectName);
        try {
            return this.source().getMBeanInfo(objectName2);
        }
        catch (RuntimeException runtimeException) {
            throw this.makeCompliantRuntimeException(runtimeException);
        }
    }

    @Override
    public ObjectInstance getObjectInstance(ObjectName objectName) throws InstanceNotFoundException, IOException {
        ObjectName objectName2 = this.toSourceOrRuntime(objectName);
        try {
            return this.processOutputInstance(this.source().getObjectInstance(objectName2));
        }
        catch (RuntimeException runtimeException) {
            throw this.makeCompliantRuntimeException(runtimeException);
        }
    }

    @Override
    public boolean isRegistered(ObjectName objectName) throws IOException {
        ObjectName objectName2 = this.toSourceOrRuntime(objectName);
        try {
            return this.source().isRegistered(objectName2);
        }
        catch (RuntimeMBeanException runtimeMBeanException) {
            throw new RuntimeOperationsException(runtimeMBeanException.getTargetException());
        }
        catch (RuntimeException runtimeException) {
            throw this.makeCompliantRuntimeException(runtimeException);
        }
    }

    @Override
    public void setAttribute(ObjectName objectName, Attribute attribute) throws InstanceNotFoundException, AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException, IOException {
        ObjectName objectName2 = this.toSourceOrRuntime(objectName);
        try {
            this.source().setAttribute(objectName2, attribute);
        }
        catch (RuntimeException runtimeException) {
            throw this.makeCompliantRuntimeException(runtimeException);
        }
    }

    @Override
    public ObjectInstance createMBean(String string, ObjectName objectName, ObjectName objectName2, Object[] objectArray, String[] stringArray) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException, InstanceNotFoundException, IOException {
        ObjectName objectName3 = this.newSourceMBeanName(objectName);
        ObjectName objectName4 = objectName2;
        try {
            ObjectInstance objectInstance = this.source().createMBean(string, objectName3, objectName4, objectArray, stringArray);
            return this.processOutputInstance(objectInstance);
        }
        catch (RuntimeException runtimeException) {
            throw this.makeCompliantRuntimeException(runtimeException);
        }
    }

    @Override
    public ObjectInstance createMBean(String string, ObjectName objectName, Object[] objectArray, String[] stringArray) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException, IOException {
        ObjectName objectName2 = this.newSourceMBeanName(objectName);
        try {
            return this.processOutputInstance(this.source().createMBean(string, objectName2, objectArray, stringArray));
        }
        catch (RuntimeException runtimeException) {
            throw this.makeCompliantRuntimeException(runtimeException);
        }
    }

    @Override
    public ObjectInstance createMBean(String string, ObjectName objectName, ObjectName objectName2) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException, InstanceNotFoundException, IOException {
        ObjectName objectName3 = this.newSourceMBeanName(objectName);
        ObjectName objectName4 = objectName2;
        try {
            return this.processOutputInstance(this.source().createMBean(string, objectName3, objectName4));
        }
        catch (RuntimeException runtimeException) {
            throw this.makeCompliantRuntimeException(runtimeException);
        }
    }

    @Override
    public ObjectInstance createMBean(String string, ObjectName objectName) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException, IOException {
        ObjectName objectName2 = this.newSourceMBeanName(objectName);
        try {
            return this.processOutputInstance(this.source().createMBean(string, objectName2));
        }
        catch (RuntimeException runtimeException) {
            throw this.makeCompliantRuntimeException(runtimeException);
        }
    }

    @Override
    public Object getAttribute(ObjectName objectName, String string) throws MBeanException, AttributeNotFoundException, InstanceNotFoundException, ReflectionException, IOException {
        ObjectName objectName2 = this.toSourceOrRuntime(objectName);
        try {
            return this.source().getAttribute(objectName2, string);
        }
        catch (RuntimeException runtimeException) {
            throw this.makeCompliantRuntimeException(runtimeException);
        }
    }

    @Override
    public boolean isInstanceOf(ObjectName objectName, String string) throws InstanceNotFoundException, IOException {
        ObjectName objectName2 = this.toSourceOrRuntime(objectName);
        try {
            return this.source().isInstanceOf(objectName2, string);
        }
        catch (RuntimeException runtimeException) {
            throw this.makeCompliantRuntimeException(runtimeException);
        }
    }

    @Override
    public AttributeList setAttributes(ObjectName objectName, AttributeList attributeList) throws InstanceNotFoundException, ReflectionException, IOException {
        ObjectName objectName2 = this.toSourceOrRuntime(objectName);
        try {
            return this.source().setAttributes(objectName2, attributeList);
        }
        catch (RuntimeException runtimeException) {
            throw this.makeCompliantRuntimeException(runtimeException);
        }
    }

    Set<ObjectInstance> processOutputInstances(Set<ObjectInstance> set) {
        Set<ObjectInstance> set2 = Util.equivalentEmptySet(set);
        for (ObjectInstance objectInstance : set) {
            try {
                ObjectInstance objectInstance2 = this.processOutputInstance(objectInstance);
                if (this.excludesFromResult(objectInstance2.getObjectName(), "queryMBeans")) continue;
                set2.add(objectInstance2);
            }
            catch (Exception exception) {
                if (!LOG.isLoggable(Level.FINE)) continue;
                LOG.fine("Skiping returned item: Unexpected exception while processing ObjectInstance: " + exception);
            }
        }
        return set2;
    }

    ObjectInstance processOutputInstance(ObjectInstance objectInstance) {
        if (objectInstance == null) {
            return null;
        }
        ObjectName objectName = objectInstance.getObjectName();
        try {
            ObjectName objectName2 = this.toTarget(objectName);
            return new ObjectInstance(objectName2, objectInstance.getClassName());
        }
        catch (RuntimeException runtimeException) {
            throw this.makeCompliantRuntimeException(runtimeException);
        }
    }

    Set<ObjectName> processOutputNames(Set<ObjectName> set) {
        Set<ObjectName> set2 = Util.equivalentEmptySet(set);
        for (ObjectName objectName : set) {
            try {
                ObjectName objectName2 = this.toTarget(objectName);
                if (this.excludesFromResult(objectName2, "queryNames")) continue;
                set2.add(objectName2);
            }
            catch (Exception exception) {
                if (!LOG.isLoggable(Level.FINE)) continue;
                LOG.fine("Skiping returned item: Unexpected exception while processing ObjectInstance: " + exception);
            }
        }
        return set2;
    }

    @Override
    public Set<ObjectInstance> queryMBeans(ObjectName objectName, QueryExp queryExp) throws IOException {
        if (objectName == null) {
            objectName = ObjectName.WILDCARD;
        }
        ObjectName objectName2 = this.toSourceOrRuntime(objectName);
        try {
            return this.processOutputInstances(this.source().queryMBeans(objectName2, queryExp));
        }
        catch (RuntimeException runtimeException) {
            throw this.makeCompliantRuntimeException(runtimeException);
        }
    }

    @Override
    public Set<ObjectName> queryNames(ObjectName objectName, QueryExp queryExp) throws IOException {
        if (objectName == null) {
            objectName = ObjectName.WILDCARD;
        }
        ObjectName objectName2 = this.toSourceOrRuntime(objectName);
        try {
            Set<ObjectName> set = this.source().queryNames(objectName2, queryExp);
            Set<ObjectName> set2 = this.processOutputNames(set);
            return set2;
        }
        catch (RuntimeException runtimeException) {
            throw this.makeCompliantRuntimeException(runtimeException);
        }
    }

    @Override
    public void removeNotificationListener(ObjectName objectName, NotificationListener notificationListener) throws InstanceNotFoundException, ListenerNotFoundException, IOException {
        ObjectName objectName2 = this.toSourceOrRuntime(objectName);
        try {
            this.source().removeNotificationListener(objectName2, notificationListener);
        }
        catch (RuntimeException runtimeException) {
            throw this.makeCompliantRuntimeException(runtimeException);
        }
    }

    @Override
    public void addNotificationListener(ObjectName objectName, ObjectName objectName2, NotificationFilter notificationFilter, Object object) throws InstanceNotFoundException, IOException {
        ObjectName objectName3 = this.toSourceOrRuntime(objectName);
        try {
            this.source().addNotificationListener(objectName3, objectName2, notificationFilter, object);
        }
        catch (RuntimeException runtimeException) {
            throw this.makeCompliantRuntimeException(runtimeException);
        }
    }

    @Override
    public void addNotificationListener(ObjectName objectName, NotificationListener notificationListener, NotificationFilter notificationFilter, Object object) throws InstanceNotFoundException, IOException {
        ObjectName objectName2 = this.toSourceOrRuntime(objectName);
        try {
            this.source().addNotificationListener(objectName2, notificationListener, notificationFilter, object);
        }
        catch (RuntimeException runtimeException) {
            throw this.makeCompliantRuntimeException(runtimeException);
        }
    }

    @Override
    public void removeNotificationListener(ObjectName objectName, NotificationListener notificationListener, NotificationFilter notificationFilter, Object object) throws InstanceNotFoundException, ListenerNotFoundException, IOException {
        ObjectName objectName2 = this.toSourceOrRuntime(objectName);
        try {
            this.source().removeNotificationListener(objectName2, notificationListener, notificationFilter, object);
        }
        catch (RuntimeException runtimeException) {
            throw this.makeCompliantRuntimeException(runtimeException);
        }
    }

    @Override
    public void removeNotificationListener(ObjectName objectName, ObjectName objectName2, NotificationFilter notificationFilter, Object object) throws InstanceNotFoundException, ListenerNotFoundException, IOException {
        ObjectName objectName3 = this.toSourceOrRuntime(objectName);
        try {
            this.source().removeNotificationListener(objectName3, objectName2, notificationFilter, object);
        }
        catch (RuntimeException runtimeException) {
            throw this.makeCompliantRuntimeException(runtimeException);
        }
    }

    @Override
    public void removeNotificationListener(ObjectName objectName, ObjectName objectName2) throws InstanceNotFoundException, ListenerNotFoundException, IOException {
        ObjectName objectName3 = this.toSourceOrRuntime(objectName);
        ObjectName objectName4 = objectName2;
        try {
            this.source().removeNotificationListener(objectName3, objectName4);
        }
        catch (RuntimeException runtimeException) {
            throw this.makeCompliantRuntimeException(runtimeException);
        }
    }

    @Override
    public Integer getMBeanCount() throws IOException {
        try {
            return this.source().getMBeanCount();
        }
        catch (RuntimeException runtimeException) {
            throw this.makeCompliantRuntimeException(runtimeException);
        }
    }

    @Override
    public String[] getDomains() throws IOException {
        try {
            return this.source().getDomains();
        }
        catch (RuntimeException runtimeException) {
            throw this.makeCompliantRuntimeException(runtimeException);
        }
    }

    @Override
    public String getDefaultDomain() throws IOException {
        try {
            return this.source().getDefaultDomain();
        }
        catch (RuntimeException runtimeException) {
            throw this.makeCompliantRuntimeException(runtimeException);
        }
    }

    boolean excludesFromResult(ObjectName objectName, String string) {
        return false;
    }
}

