/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing;

import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.EventQueue;
import java.util.Map;
import java.util.concurrent.Callable;
import javax.swing.JComponent;
import javax.swing.RepaintManager;
import sun.awt.AppContext;
import sun.awt.EventQueueDelegate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SwingUtilities3 {
    private static final Object DELEGATE_REPAINT_MANAGER_KEY = new StringBuilder("DelegateRepaintManagerKey");

    public static void setDelegateRepaintManager(JComponent jComponent, RepaintManager repaintManager) {
        AppContext.getAppContext().put(DELEGATE_REPAINT_MANAGER_KEY, Boolean.TRUE);
        jComponent.putClientProperty(DELEGATE_REPAINT_MANAGER_KEY, repaintManager);
    }

    public static RepaintManager getDelegateRepaintManager(Component component) {
        RepaintManager repaintManager = null;
        if (Boolean.TRUE == AppContext.getAppContext().get(DELEGATE_REPAINT_MANAGER_KEY)) {
            while (repaintManager == null && component != null) {
                while (component != null && !(component instanceof JComponent)) {
                    component = component.getParent();
                }
                if (component == null) continue;
                repaintManager = (RepaintManager)((JComponent)component).getClientProperty(DELEGATE_REPAINT_MANAGER_KEY);
                component = component.getParent();
            }
        }
        return repaintManager;
    }

    public static void setEventQueueDelegate(Map<String, Map<String, Object>> map) {
        EventQueueDelegate.setDelegate(new EventQueueDelegateFromMap(map));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class EventQueueDelegateFromMap
    implements EventQueueDelegate.Delegate {
        private final AWTEvent[] afterDispatchEventArgument;
        private final Object[] afterDispatchHandleArgument;
        private final Callable<Void> afterDispatchCallable;
        private final AWTEvent[] beforeDispatchEventArgument;
        private final Callable<Object> beforeDispatchCallable;
        private final EventQueue[] getNextEventEventQueueArgument;
        private final Callable<AWTEvent> getNextEventCallable;

        public EventQueueDelegateFromMap(Map<String, Map<String, Object>> map) {
            Map<String, Object> map2 = map.get("afterDispatch");
            this.afterDispatchEventArgument = (AWTEvent[])map2.get("event");
            this.afterDispatchHandleArgument = (Object[])map2.get("handle");
            this.afterDispatchCallable = (Callable)map2.get("method");
            map2 = map.get("beforeDispatch");
            this.beforeDispatchEventArgument = (AWTEvent[])map2.get("event");
            this.beforeDispatchCallable = (Callable)map2.get("method");
            map2 = map.get("getNextEvent");
            this.getNextEventEventQueueArgument = (EventQueue[])map2.get("eventQueue");
            this.getNextEventCallable = (Callable)map2.get("method");
        }

        @Override
        public void afterDispatch(AWTEvent aWTEvent, Object object) throws InterruptedException {
            this.afterDispatchEventArgument[0] = aWTEvent;
            this.afterDispatchHandleArgument[0] = object;
            try {
                this.afterDispatchCallable.call();
            }
            catch (InterruptedException interruptedException) {
                throw interruptedException;
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        }

        @Override
        public Object beforeDispatch(AWTEvent aWTEvent) throws InterruptedException {
            this.beforeDispatchEventArgument[0] = aWTEvent;
            try {
                return this.beforeDispatchCallable.call();
            }
            catch (InterruptedException interruptedException) {
                throw interruptedException;
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        }

        @Override
        public AWTEvent getNextEvent(EventQueue eventQueue) throws InterruptedException {
            this.getNextEventEventQueueArgument[0] = eventQueue;
            try {
                return this.getNextEventCallable.call();
            }
            catch (InterruptedException interruptedException) {
                throw interruptedException;
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        }
    }
}

