/*	$NetBSD: var.h,v 1.7 2003/08/07 11:17:34 agc Exp $	*/

/*
 * Copyright (c) 1983, 1993
 *	The Regents of the University of California.  All rights reserved.
 *
 * This code is derived from software contributed to Berkeley by
 * Edward Wang at The University of California, Berkeley.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. Neither the name of the University nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 *	@(#)var.h	8.1 (Berkeley) 6/6/93
 */
#ifndef VAR_H_
#define VAR_H_

typedef struct variable_t {
	struct variable_t	*r_left;
	struct variable_t	*r_right;
	char			*r_name;
	value_t		 	 r_val;
} variable_t;

variable_t     **var_lookup1(variable_t **, const char *);
variable_t	*var_set1(variable_t **, const char *, value_t *);
variable_t	*var_setnum1(variable_t **, const char *, int);
variable_t	*var_setstr1(variable_t **, const char *, char *);
int		 var_unset1(variable_t **, char *);
int		 var_walk1(variable_t *, int (*func)(void *, variable_t *),
			   void *);

#define var_set(n, v)		var_set1(get_var_list("var"), n, v)
#define var_setstr(n, s)	var_setstr1(get_var_list("var"), n, s)
#define var_setnum(n, i)	var_setnum1(get_var_list("var"), n, i)
#define var_unset(n)		var_unset1(get_var_list("var"), n)
#define var_lookup(n)		(*var_lookup1(get_var_list("var"), n))
#define var_walk(f, a)		var_walk1(*get_var_list("var"), f, a)


/* aliases use a list of variable_t's too */
	/* a_flags bits, must not interfere with v_type values */
#define A_INUSE		0x010	/* already inuse */

#define alias_set(n, s)		var_setstr1(get_var_list("alias"), n, s)
#define alias_walk(f, a)	var_walk1(*get_var_list("alias"), f, a)
#define alias_unset(n)		var_unset1(get_var_list("alias"), n)
#define alias_lookup(n)		(*var_lookup1(get_var_list("alias"), n))

variable_t **get_var_list(const char *);

#endif /* !VAR_H_ */
