/*	$NetBSD: startup.c,v 1.7 2003/08/07 11:17:29 agc Exp $	*/

/*
 * Copyright (c) 1983, 1993
 *	The Regents of the University of California.  All rights reserved.
 *
 * This code is derived from software contributed to Berkeley by
 * Edward Wang at The University of California, Berkeley.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. Neither the name of the University nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

#include <sys/cdefs.h>

#ifndef lint
__RCSID("$NetBSD: startup.c,v 1.7 2003/08/07 11:17:29 agc Exp $");
#endif /* not lint */

#include <stdlib.h>
#include "defs.h"
#include "var.h"
#include "char.h"
#include "local.h"

int
doconfig(void)
{
	char buf[100];
	const char *home;
	static char runcom[] = RUNCOM;

	if ((home = getenv("HOME")) == 0)
		home = ".";
	(void) snprintf(buf, sizeof(buf), "%.*s/%s",
		(int)((sizeof buf - sizeof runcom) / sizeof (char) - 1),
		home, runcom);
	return dosource(buf);
}

/*
 * The default is two windows of equal size.
 */
void
dodefault(winvars_t *winvars)
{
	ww_t *w;
	int r = winvars->wwnrow / 2 - 1;

	if (openwin(winvars, 1, r + 2, 0, winvars->wwnrow - r - 2, winvars->wwncol, winvars->default_nline,
	    NULL, WWT_PTY, WWU_HASFRAME, winvars->default_shellfile,
	    winvars->default_shell) == 0)
		return;
	if ((w = openwin(winvars, 0, 1, 0, r, winvars->wwncol, winvars->default_nline,
	    NULL, WWT_PTY, WWU_HASFRAME, winvars->default_shellfile,
	    winvars->default_shell)) == 0)
		return;
	wwprintf(w, "Escape character is %s.\r\n", UNCTRL(winvars->escapec));
}

void
setvars(winvars_t *winvars)
{
	/* try to use a random ordering to balance the tree */
	(void) var_setnum("nrow", winvars->wwnrow);
	(void) var_setnum("ncol", winvars->wwncol);
	(void) var_setnum("baud", winvars->wwbaud);
	(void) var_setnum("m_rev", WWM_REV);
	(void) var_setnum("m_blk", WWM_BLK);
	(void) var_setnum("m_ul", WWM_UL);
	(void) var_setnum("m_grp", WWM_GRP);
	(void) var_setnum("m_dim", WWM_DIM);
	(void) var_setnum("m_usr", WWM_USR);
	(void) var_setstr("term", winvars->wwterm);
	(void) var_setnum("modes", winvars->wwavailmodes);
}
