# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from enum import Enum, EnumMeta
from six import with_metaclass

class _CaseInsensitiveEnumMeta(EnumMeta):
    def __getitem__(self, name):
        return super().__getitem__(name.upper())

    def __getattr__(cls, name):
        """Return the enum member matching `name`
        We use __getattr__ instead of descriptors or inserting into the enum
        class' __dict__ in order to support `name` and `value` being both
        properties for enum members (which live in the class' __dict__) and
        enum members themselves.
        """
        try:
            return cls._member_map_[name.upper()]
        except KeyError:
            raise AttributeError(name)


class ActionType(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """Enum. Indicates the action type. "Internal" refers to actions that are for internal only APIs.
    """

    INTERNAL = "Internal"

class ArcSettingAggregateState(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """Aggregate state of Arc agent across the nodes in this HCI cluster.
    """

    NOT_SPECIFIED = "NotSpecified"
    ERROR = "Error"
    SUCCEEDED = "Succeeded"
    CANCELED = "Canceled"
    FAILED = "Failed"
    CONNECTED = "Connected"
    DISCONNECTED = "Disconnected"
    DELETED = "Deleted"
    CREATING = "Creating"
    UPDATING = "Updating"
    DELETING = "Deleting"
    MOVING = "Moving"
    PARTIALLY_SUCCEEDED = "PartiallySucceeded"
    PARTIALLY_CONNECTED = "PartiallyConnected"
    IN_PROGRESS = "InProgress"

class CreatedByType(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """The type of identity that created the resource.
    """

    USER = "User"
    APPLICATION = "Application"
    MANAGED_IDENTITY = "ManagedIdentity"
    KEY = "Key"

class ExtensionAggregateState(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """Aggregate state of Arc Extensions across the nodes in this HCI cluster.
    """

    NOT_SPECIFIED = "NotSpecified"
    ERROR = "Error"
    SUCCEEDED = "Succeeded"
    CANCELED = "Canceled"
    FAILED = "Failed"
    CONNECTED = "Connected"
    DISCONNECTED = "Disconnected"
    DELETED = "Deleted"
    CREATING = "Creating"
    UPDATING = "Updating"
    DELETING = "Deleting"
    MOVING = "Moving"
    PARTIALLY_SUCCEEDED = "PartiallySucceeded"
    PARTIALLY_CONNECTED = "PartiallyConnected"
    IN_PROGRESS = "InProgress"

class NodeArcState(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """State of Arc agent in this node.
    """

    NOT_SPECIFIED = "NotSpecified"
    ERROR = "Error"
    SUCCEEDED = "Succeeded"
    CANCELED = "Canceled"
    FAILED = "Failed"
    CONNECTED = "Connected"
    DISCONNECTED = "Disconnected"
    DELETED = "Deleted"
    CREATING = "Creating"
    UPDATING = "Updating"
    DELETING = "Deleting"
    MOVING = "Moving"

class NodeExtensionState(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """State of Arc Extension in this node.
    """

    NOT_SPECIFIED = "NotSpecified"
    ERROR = "Error"
    SUCCEEDED = "Succeeded"
    CANCELED = "Canceled"
    FAILED = "Failed"
    CONNECTED = "Connected"
    DISCONNECTED = "Disconnected"
    DELETED = "Deleted"
    CREATING = "Creating"
    UPDATING = "Updating"
    DELETING = "Deleting"
    MOVING = "Moving"

class Origin(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """The intended executor of the operation; as in Resource Based Access Control (RBAC) and audit
    logs UX. Default value is "user,system"
    """

    USER = "user"
    SYSTEM = "system"
    USER_SYSTEM = "user,system"

class ProvisioningState(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """Provisioning state of the ArcSetting proxy resource.
    """

    SUCCEEDED = "Succeeded"
    FAILED = "Failed"
    CANCELED = "Canceled"
    ACCEPTED = "Accepted"
    PROVISIONING = "Provisioning"

class Status(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """Status of the cluster agent.
    """

    NOT_YET_REGISTERED = "NotYetRegistered"
    CONNECTED_RECENTLY = "ConnectedRecently"
    NOT_CONNECTED_RECENTLY = "NotConnectedRecently"
    DISCONNECTED = "Disconnected"
    ERROR = "Error"
