#if   !defined(__PROXY_HPP)
#define __PROXY_HPP

/*
  CoreLinux++ 
  Copyright (C) 1999,2000 CoreLinux Consortium
  
   The CoreLinux++ Library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public License as
   published by the Free Software Foundation; either version 2 of the
   License, or (at your option) any later version.

   The CoreLinux++ Library Library is distributed in the hope that it will 
   be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with the GNU C Library; see the file COPYING.LIB.  If not,
   write to the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.  
*/   


#if   !defined(__COMMON_HPP)
#include <Common.hpp>
#endif

namespace corelinux
{
   /**
   Provide a surrogate or placeholder for another object to
   control access to it.
   */

   template< class SubjectImpl >
      class Proxy
      {
      public:

         //
         // Constructors and destructor
         //

                        /// Default constructor

                        Proxy( void )
                           :
                           theSubject( NULLPTR )
                        {
                           ;  // do nothing
                        }

                        /**
                        Constructor with SubjectImpl instance
                        @param SubjectImpl pointer
                        */

                        Proxy( SubjectImpl *aSubject )
                           throw(Assertion)
                           :
                           theSubject( aSubject )
                        {
                           REQUIRE( aSubject != NULLPTR );
                        }

                        /**
                        Copy constructor
                        @param Proxy const reference
                        */

                        Proxy( const Proxy &aProxy )
                           :
                           theSubject( aProxy.theSubject )
                        {
                           ;  // do nothing
                        }

                        /// Virtual destructor

         virtual        ~Proxy( void )
                        {
                           theSubject = NULLPTR;  
                        }

         //
         // Operator overloads
         //

                  /**
                  Assignment operator
                  @param Proxy const reference
                  @return Proxy reference
                  */

                  Proxy & operator=( const Proxy &aProxy )
                  {
                     if( (*this == aProxy) == false )
                     {
                        theSubject = aProxy.getSubject();
                     }
                     else
                     {
                        ;  // do nothing
                     }

                     return ( *this );
                  }

                  /**
                  Equality operator
                  @param Proxy const reference
                  @return bool if same
                  */

                  bool operator==( const Proxy &aProxy ) const
                  {
                     return ( this == &aProxy &&
                              theSubject == aProxy.getSubject() );
                  }

                  /**
                  Operator selector overload
                  @return SubjectImpl pointer
                  */

         virtual  SubjectImpl *  operator->( void )
                  {
                     return theSubject;
                  }

                  /**
                  Operator dereference overload
                  @return SubjectImpl reference
                  @exception Assertion if theSubject is NULLPTR
                  */

         virtual  SubjectImpl & operator*( void )
                                 throw( Assertion )
                  {
                     REQUIRE( theSubject != NULLPTR );
                     return ( *theSubject );
                  }
         //
         // Accessors
         //

                  /**
                  Returns a reference to theSubjec
                  @return SubjectImpl const reference
                  @exception Assertion if theSubject is NULLPTR
                  */

         virtual  const SubjectImpl &getSubject( void ) const
                                       throw( Assertion )
                  {
                     REQUIRE( theSubject != NULLPTR );
                     return ( *theSubject );
                  }

      protected:

         //
         // Mutators
         //

         virtual  void  setSubject( SubjectImpl *aSubject ) 
                  {
                     theSubject = aSubject;
                  }

   
      protected:

                  /// The subject pointer

                  SubjectImpl    *theSubject;
      };
}

#endif // if   !defined(__PROXY_HPP)

/*
   Common rcs information do not modify
   $Author: prudhomm $
   $Revision: 1.1 $
   $Date: 2000/04/23 20:43:13 $
   $Locker:  $
*/

