/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon;

import javax.xml.transform.Templates;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.sax.TemplatesHandler;
import net.sf.saxon.Configuration;
import net.sf.saxon.PreparedStyleSheet;
import net.sf.saxon.event.CommentStripper;
import net.sf.saxon.event.ContentEmitter;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.style.StyleNodeFactory;
import net.sf.saxon.style.StylesheetStripper;
import net.sf.saxon.tree.DocumentImpl;
import net.sf.saxon.tree.TreeBuilder;

public class TemplatesHandlerImpl
extends ContentEmitter
implements TemplatesHandler {
    private Configuration config;
    private TreeBuilder builder;
    private StyleNodeFactory nodeFactory;
    private Templates templates;
    private String systemId;

    protected TemplatesHandlerImpl(Configuration configuration) {
        this.config = configuration;
        NamePool namePool = new NamePool();
        this.setNamePool(namePool);
        this.nodeFactory = new StyleNodeFactory(namePool, configuration.isAllowExternalFunctions());
        StylesheetStripper stylesheetStripper = new StylesheetStripper();
        stylesheetStripper.setStylesheetRules(namePool);
        this.builder = new TreeBuilder();
        this.builder.setNamePool(namePool);
        this.builder.setNodeFactory(this.nodeFactory);
        this.builder.setLineNumbering(true);
        stylesheetStripper.setUnderlyingReceiver(this.builder);
        CommentStripper commentStripper = new CommentStripper();
        commentStripper.setUnderlyingReceiver(stylesheetStripper);
        this.setReceiver(commentStripper);
    }

    public Templates getTemplates() {
        if (this.templates == null) {
            DocumentImpl documentImpl = (DocumentImpl)this.builder.getCurrentDocument();
            if (documentImpl == null) {
                return null;
            }
            PreparedStyleSheet preparedStyleSheet = new PreparedStyleSheet(this.config);
            try {
                preparedStyleSheet.setStyleSheetDocument(documentImpl, this.nodeFactory);
                this.templates = preparedStyleSheet;
            }
            catch (TransformerConfigurationException transformerConfigurationException) {
                throw new UnsupportedOperationException(transformerConfigurationException.getMessage());
            }
        }
        return this.templates;
    }

    public void setSystemId(String string) {
        this.systemId = string;
        this.builder.setSystemId(string);
    }

    public String getSystemId() {
        return this.systemId;
    }
}

