/*
 * Decompiled with CFR 0.152.
 */
package alt.jiapi.util;

import alt.jiapi.JiapiException;
import alt.jiapi.Runtime;
import alt.jiapi.instrumentor.ChainInstrumentor;
import alt.jiapi.instrumentor.Hook;
import alt.jiapi.instrumentor.InstrumentorChain;
import alt.jiapi.instrumentor.Strategy;
import alt.jiapi.util.SymbolMap;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.util.StringTokenizer;
import org.apache.log4j.Category;

public class ChainBuilder {
    private static Category log = Runtime.getLogCategory(ChainBuilder.class);
    private static final Class instrumentorClass = ChainInstrumentor.class;
    private static final Class strategyClass = Strategy.class;
    private static final Class hookClass = Hook.class;
    private SymbolMap map;

    public static void main(String[] args) throws Exception {
        SymbolMap map = new SymbolMap("alt.jiapi.instrumentor");
        ChainBuilder cb = new ChainBuilder(map);
        InstrumentorChain chain = cb.createChain(args[0]);
        System.out.println(chain);
    }

    public ChainBuilder() {
        this.map = new SymbolMap("alt.jiapi.instrumentor");
    }

    public ChainBuilder(SymbolMap map) {
        this.map = map;
    }

    public InstrumentorChain createChain(String chainSpec) throws JiapiException, ClassNotFoundException, InstantiationException {
        return this.createChain(chainSpec, this.map);
    }

    public InstrumentorChain createChain(String chainSpec, SymbolMap symbols) throws JiapiException, ClassNotFoundException, InstantiationException {
        InstrumentorChain chain = new InstrumentorChain();
        StringTokenizer st = new StringTokenizer(chainSpec, "|");
        while (st.hasMoreTokens()) {
            String instrumentorSpec = st.nextToken().trim();
            ChainInstrumentor i = this.createInstrumentor(instrumentorSpec, symbols);
            if (i == null) {
                throw new JiapiException("ChainBuilder.createInstrumentor(...) returned null");
            }
            chain.add(i);
        }
        return chain;
    }

    public ChainInstrumentor createInstrumentor(String instrumentorSpec, SymbolMap symbols) throws JiapiException, ClassNotFoundException, InstantiationException {
        String childSymbol;
        log.debug((Object)("Creating Instrumentor from spec: " + instrumentorSpec));
        ChainInstrumentor instrumentor = null;
        String instrumentorClassName = null;
        String childClassName = null;
        String childHints = null;
        StringTokenizer st = new StringTokenizer(instrumentorSpec, "#");
        if (!st.hasMoreTokens()) {
            throw new JiapiException("Illegal insrumentorSpec " + instrumentorSpec);
        }
        String instrumentorSymbol = st.nextToken().trim();
        instrumentorClassName = symbols.getSymbol(instrumentorSymbol);
        if (instrumentorClassName == null) {
            instrumentorClassName = instrumentorSymbol;
        }
        if (st.hasMoreTokens() && (childClassName = symbols.getSymbol(childSymbol = st.nextToken().trim())) == null) {
            childClassName = childSymbol;
        }
        if (st.hasMoreTokens()) {
            childHints = st.nextToken().trim();
        }
        Class<?> instrumentorClass = null;
        Class<?> childClass = null;
        Object child = null;
        instrumentorClass = Class.forName(instrumentorClassName);
        if (childClassName != null) {
            try {
                childClass = Class.forName(childClassName);
                child = this.createChild(childClass, childHints);
            }
            catch (ClassNotFoundException e) {
                child = childClassName;
            }
        }
        instrumentor = this.createInstrumentor(instrumentorClass, child);
        log.info((Object)("Created instrumentor: " + instrumentor));
        return instrumentor;
    }

    private Object createChild(Class child, String childHint) throws InstantiationException {
        System.out.println("Creating child : " + child);
        Object childObject = null;
        log.debug((Object)("Creating child: " + child.getName() + ", hints " + childHint));
        if (childHint == null) {
            try {
                childObject = child.newInstance();
            }
            catch (IllegalAccessException iae) {
                throw new InstantiationException("Illegal access: " + iae.getMessage());
            }
        }
        Field hintField = null;
        try {
            hintField = child.getField(childHint);
        }
        catch (Exception e) {
            log.debug((Object)("Exception occured: " + e.getMessage()));
        }
        if (hintField != null) {
            log.debug((Object)("hint field: " + hintField));
            Class[] parameterTypes = new Class[]{hintField.getType()};
            try {
                Constructor c = child.getConstructor(parameterTypes);
                log.debug((Object)("Child constructor: " + c));
                Object[] params = new Object[]{new Integer(hintField.getInt(null))};
                childObject = c.newInstance(params);
            }
            catch (NoSuchMethodException nsme) {
                throw new InstantiationException("No such method: " + nsme.getMessage());
            }
            catch (IllegalAccessException iae) {
                throw new InstantiationException("Illegal access: " + iae.getMessage());
            }
            catch (InvocationTargetException ite) {
                throw new InstantiationException("Exception in constructor: " + ite.getMessage());
            }
        }
        return childObject;
    }

    private ChainInstrumentor createInstrumentor(Class instrumentorClass, Object child) throws InstantiationException {
        log.debug((Object)("Creating Instrumentor: " + instrumentorClass.getName() + ", child: " + child));
        ChainInstrumentor instrumentor = null;
        if (child == null) {
            try {
                instrumentor = (ChainInstrumentor)instrumentorClass.newInstance();
            }
            catch (IllegalAccessException iae) {
                throw new InstantiationException("Illegal access: " + iae.getMessage());
            }
        }
        Class[] parameterTypes = new Class[]{instrumentorClass.isAssignableFrom(child.getClass()) ? instrumentorClass : (strategyClass.isAssignableFrom(child.getClass()) ? strategyClass : (hookClass.isAssignableFrom(child.getClass()) ? hookClass : child.getClass()))};
        try {
            Constructor c = instrumentorClass.getConstructor(parameterTypes);
            log.debug((Object)("Using constructor: " + c));
            Object[] params = new Object[]{child};
            instrumentor = (ChainInstrumentor)c.newInstance(params);
        }
        catch (NoSuchMethodException nsme) {
            throw new InstantiationException("No such method: " + nsme.getMessage());
        }
        catch (IllegalAccessException iae) {
            throw new InstantiationException("Illegal access: " + iae.getMessage());
        }
        catch (InvocationTargetException ite) {
            throw new InstantiationException("Exception in constructor: " + ite.getMessage());
        }
        return instrumentor;
    }
}

