; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mattr=sse2   | FileCheck %s --check-prefix=ALL --check-prefix=SSEANY --check-prefix=SSE2
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mattr=sse4.1 | FileCheck %s --check-prefix=ALL --check-prefix=SSEANY --check-prefix=SSE4
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mattr=avx    | FileCheck %s --check-prefix=ALL --check-prefix=AVX

define <4 x i32> @ins_elt_0(i32 %x, <4 x i32> %v1, <4 x i32> %v2) {
; SSE2-LABEL: ins_elt_0:
; SSE2:       # %bb.0:
; SSE2-NEXT:    movd %edi, %xmm0
; SSE2-NEXT:    movss {{.*#+}} xmm1 = xmm0[0],xmm1[1,2,3]
; SSE2-NEXT:    movaps %xmm1, %xmm0
; SSE2-NEXT:    retq
;
; SSE4-LABEL: ins_elt_0:
; SSE4:       # %bb.0:
; SSE4-NEXT:    pinsrd $0, %edi, %xmm1
; SSE4-NEXT:    movdqa %xmm1, %xmm0
; SSE4-NEXT:    retq
;
; AVX-LABEL: ins_elt_0:
; AVX:       # %bb.0:
; AVX-NEXT:    vpinsrd $0, %edi, %xmm1, %xmm0
; AVX-NEXT:    retq
  %ins = insertelement <4 x i32> %v1, i32 %x, i32 0
  %shuf = shufflevector <4 x i32> %ins, <4 x i32> %v2, <4 x i32> <i32 0, i32 5, i32 6, i32 7>
  ret <4 x i32> %shuf
}

define <4 x i32> @ins_elt_1(i32 %x, <4 x i32> %v1, <4 x i32> %v2) {
; SSE2-LABEL: ins_elt_1:
; SSE2:       # %bb.0:
; SSE2-NEXT:    movd %edi, %xmm0
; SSE2-NEXT:    shufps {{.*#+}} xmm0 = xmm0[0,0],xmm1[0,0]
; SSE2-NEXT:    shufps {{.*#+}} xmm0 = xmm0[2,0],xmm1[2,3]
; SSE2-NEXT:    retq
;
; SSE4-LABEL: ins_elt_1:
; SSE4:       # %bb.0:
; SSE4-NEXT:    pinsrd $1, %edi, %xmm1
; SSE4-NEXT:    movdqa %xmm1, %xmm0
; SSE4-NEXT:    retq
;
; AVX-LABEL: ins_elt_1:
; AVX:       # %bb.0:
; AVX-NEXT:    vpinsrd $1, %edi, %xmm1, %xmm0
; AVX-NEXT:    retq
  %ins = insertelement <4 x i32> %v1, i32 %x, i32 1
  %shuf = shufflevector <4 x i32> %ins, <4 x i32> %v2, <4 x i32> <i32 4, i32 1, i32 6, i32 7>
  ret <4 x i32> %shuf
}

; Verify that the transform still works when the insert element is the 2nd operand to the shuffle.

define <4 x i32> @ins_elt_2_commute(i32 %x, <4 x i32> %v1, <4 x i32> %v2) {
; SSE2-LABEL: ins_elt_2_commute:
; SSE2:       # %bb.0:
; SSE2-NEXT:    movd %edi, %xmm0
; SSE2-NEXT:    shufps {{.*#+}} xmm0 = xmm0[0,0],xmm1[3,0]
; SSE2-NEXT:    shufps {{.*#+}} xmm1 = xmm1[0,1],xmm0[0,2]
; SSE2-NEXT:    movaps %xmm1, %xmm0
; SSE2-NEXT:    retq
;
; SSE4-LABEL: ins_elt_2_commute:
; SSE4:       # %bb.0:
; SSE4-NEXT:    pinsrd $2, %edi, %xmm1
; SSE4-NEXT:    movdqa %xmm1, %xmm0
; SSE4-NEXT:    retq
;
; AVX-LABEL: ins_elt_2_commute:
; AVX:       # %bb.0:
; AVX-NEXT:    vpinsrd $2, %edi, %xmm1, %xmm0
; AVX-NEXT:    retq
  %ins = insertelement <4 x i32> %v1, i32 %x, i32 2
  %shuf = shufflevector <4 x i32> %v2, <4 x i32> %ins, <4 x i32> <i32 0, i32 1, i32 6, i32 3>
  ret <4 x i32> %shuf
}

define <4 x i32> @ins_elt_3_commute(i32 %x, <4 x i32> %v1, <4 x i32> %v2) {
; SSE2-LABEL: ins_elt_3_commute:
; SSE2:       # %bb.0:
; SSE2-NEXT:    movd %edi, %xmm0
; SSE2-NEXT:    shufps {{.*#+}} xmm0 = xmm0[0,0],xmm1[2,0]
; SSE2-NEXT:    shufps {{.*#+}} xmm1 = xmm1[0,1],xmm0[2,0]
; SSE2-NEXT:    movaps %xmm1, %xmm0
; SSE2-NEXT:    retq
;
; SSE4-LABEL: ins_elt_3_commute:
; SSE4:       # %bb.0:
; SSE4-NEXT:    pinsrd $3, %edi, %xmm1
; SSE4-NEXT:    movdqa %xmm1, %xmm0
; SSE4-NEXT:    retq
;
; AVX-LABEL: ins_elt_3_commute:
; AVX:       # %bb.0:
; AVX-NEXT:    vpinsrd $3, %edi, %xmm1, %xmm0
; AVX-NEXT:    retq
  %ins = insertelement <4 x i32> %v1, i32 %x, i32 3
  %shuf = shufflevector <4 x i32> %v2, <4 x i32> %ins, <4 x i32> <i32 0, i32 1, i32 2, i32 7>
  ret <4 x i32> %shuf
}

; In the next 4 tests, the shuffle moves the inserted scalar to a different position in the output vector.

define <4 x i32> @ins_elt_0_to_2(i32 %x, <4 x i32> %v1, <4 x i32> %v2) {
; SSE2-LABEL: ins_elt_0_to_2:
; SSE2:       # %bb.0:
; SSE2-NEXT:    movd %edi, %xmm0
; SSE2-NEXT:    shufps {{.*#+}} xmm0 = xmm0[0,0],xmm1[3,0]
; SSE2-NEXT:    shufps {{.*#+}} xmm1 = xmm1[0,1],xmm0[0,2]
; SSE2-NEXT:    movaps %xmm1, %xmm0
; SSE2-NEXT:    retq
;
; SSE4-LABEL: ins_elt_0_to_2:
; SSE4:       # %bb.0:
; SSE4-NEXT:    pinsrd $2, %edi, %xmm1
; SSE4-NEXT:    movdqa %xmm1, %xmm0
; SSE4-NEXT:    retq
;
; AVX-LABEL: ins_elt_0_to_2:
; AVX:       # %bb.0:
; AVX-NEXT:    vpinsrd $2, %edi, %xmm1, %xmm0
; AVX-NEXT:    retq
  %ins = insertelement <4 x i32> %v1, i32 %x, i32 0
  %shuf = shufflevector <4 x i32> %ins, <4 x i32> %v2, <4 x i32> <i32 4, i32 5, i32 0, i32 7>
  ret <4 x i32> %shuf
}

define <4 x i32> @ins_elt_1_to_0(i32 %x, <4 x i32> %v1, <4 x i32> %v2) {
; SSE2-LABEL: ins_elt_1_to_0:
; SSE2:       # %bb.0:
; SSE2-NEXT:    movd %edi, %xmm0
; SSE2-NEXT:    movss {{.*#+}} xmm1 = xmm0[0],xmm1[1,2,3]
; SSE2-NEXT:    movaps %xmm1, %xmm0
; SSE2-NEXT:    retq
;
; SSE4-LABEL: ins_elt_1_to_0:
; SSE4:       # %bb.0:
; SSE4-NEXT:    pinsrd $0, %edi, %xmm1
; SSE4-NEXT:    movdqa %xmm1, %xmm0
; SSE4-NEXT:    retq
;
; AVX-LABEL: ins_elt_1_to_0:
; AVX:       # %bb.0:
; AVX-NEXT:    vpinsrd $0, %edi, %xmm1, %xmm0
; AVX-NEXT:    retq
  %ins = insertelement <4 x i32> %v1, i32 %x, i32 1
  %shuf = shufflevector <4 x i32> %ins, <4 x i32> %v2, <4 x i32> <i32 1, i32 5, i32 6, i32 7>
  ret <4 x i32> %shuf
}

define <4 x i32> @ins_elt_2_to_3(i32 %x, <4 x i32> %v1, <4 x i32> %v2) {
; SSE2-LABEL: ins_elt_2_to_3:
; SSE2:       # %bb.0:
; SSE2-NEXT:    movd %edi, %xmm0
; SSE2-NEXT:    shufps {{.*#+}} xmm0 = xmm0[0,0],xmm1[2,0]
; SSE2-NEXT:    shufps {{.*#+}} xmm1 = xmm1[0,1],xmm0[2,0]
; SSE2-NEXT:    movaps %xmm1, %xmm0
; SSE2-NEXT:    retq
;
; SSE4-LABEL: ins_elt_2_to_3:
; SSE4:       # %bb.0:
; SSE4-NEXT:    pinsrd $3, %edi, %xmm1
; SSE4-NEXT:    movdqa %xmm1, %xmm0
; SSE4-NEXT:    retq
;
; AVX-LABEL: ins_elt_2_to_3:
; AVX:       # %bb.0:
; AVX-NEXT:    vpinsrd $3, %edi, %xmm1, %xmm0
; AVX-NEXT:    retq
  %ins = insertelement <4 x i32> %v1, i32 %x, i32 2
  %shuf = shufflevector <4 x i32> %v2, <4 x i32> %ins, <4 x i32> <i32 0, i32 1, i32 2, i32 6>
  ret <4 x i32> %shuf
}

define <4 x i32> @ins_elt_3_to_1(i32 %x, <4 x i32> %v1, <4 x i32> %v2) {
; SSE2-LABEL: ins_elt_3_to_1:
; SSE2:       # %bb.0:
; SSE2-NEXT:    movd %edi, %xmm0
; SSE2-NEXT:    shufps {{.*#+}} xmm0 = xmm0[0,0],xmm1[0,0]
; SSE2-NEXT:    shufps {{.*#+}} xmm0 = xmm0[2,0],xmm1[2,3]
; SSE2-NEXT:    retq
;
; SSE4-LABEL: ins_elt_3_to_1:
; SSE4:       # %bb.0:
; SSE4-NEXT:    pinsrd $1, %edi, %xmm1
; SSE4-NEXT:    movdqa %xmm1, %xmm0
; SSE4-NEXT:    retq
;
; AVX-LABEL: ins_elt_3_to_1:
; AVX:       # %bb.0:
; AVX-NEXT:    vpinsrd $1, %edi, %xmm1, %xmm0
; AVX-NEXT:    retq
  %ins = insertelement <4 x i32> %v1, i32 %x, i32 3
  %shuf = shufflevector <4 x i32> %v2, <4 x i32> %ins, <4 x i32> <i32 0, i32 7, i32 2, i32 3>
  ret <4 x i32> %shuf
}

