/*
 * THIS FILE IS AUTOMATICALLY GENERATED, DO NOT EDIT.
 *
 *
 * Copyright (C) 2005 Apple Computer, Inc.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY APPLE COMPUTER, INC. ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL APPLE COMPUTER, INC. OR
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY
 * OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE. 
 */


#include "config.h"
#include "SVGElementFactory.h"

#include "SVGNames.h"
#if ENABLE(DASHBOARD_SUPPORT)
#include "Document.h"
#include "Settings.h"
#endif

#include "SVGAElement.h"
#include "SVGAltGlyphElement.h"
#include "SVGAnimateElement.h"
#include "SVGAnimateColorElement.h"
#include "SVGAnimateMotionElement.h"
#include "SVGAnimateTransformElement.h"
#include "SVGCircleElement.h"
#include "SVGClipPathElement.h"
#include "SVGCursorElement.h"
#include "SVGDefinitionSrcElement.h"
#include "SVGDefsElement.h"
#include "SVGDescElement.h"
#include "SVGEllipseElement.h"
#include "SVGFEBlendElement.h"
#include "SVGFEColorMatrixElement.h"
#include "SVGFEComponentTransferElement.h"
#include "SVGFECompositeElement.h"
#include "SVGFEDiffuseLightingElement.h"
#include "SVGFEDisplacementMapElement.h"
#include "SVGFEDistantLightElement.h"
#include "SVGFEFloodElement.h"
#include "SVGFEFuncAElement.h"
#include "SVGFEFuncBElement.h"
#include "SVGFEFuncGElement.h"
#include "SVGFEFuncRElement.h"
#include "SVGFEGaussianBlurElement.h"
#include "SVGFEImageElement.h"
#include "SVGFEMergeElement.h"
#include "SVGFEMergeNodeElement.h"
#include "SVGFEOffsetElement.h"
#include "SVGFEPointLightElement.h"
#include "SVGFESpecularLightingElement.h"
#include "SVGFESpotLightElement.h"
#include "SVGFETileElement.h"
#include "SVGFETurbulenceElement.h"
#include "SVGFilterElement.h"
#include "SVGFontElement.h"
#include "SVGFontFaceElement.h"
#include "SVGFontFaceFormatElement.h"
#include "SVGFontFaceNameElement.h"
#include "SVGFontFaceSrcElement.h"
#include "SVGFontFaceUriElement.h"
#include "SVGForeignObjectElement.h"
#include "SVGGElement.h"
#include "SVGGlyphElement.h"
#include "SVGHKernElement.h"
#include "SVGImageElement.h"
#include "SVGLineElement.h"
#include "SVGLinearGradientElement.h"
#include "SVGMarkerElement.h"
#include "SVGMaskElement.h"
#include "SVGMetadataElement.h"
#include "SVGMissingGlyphElement.h"
#include "SVGMPathElement.h"
#include "SVGPathElement.h"
#include "SVGPatternElement.h"
#include "SVGPolygonElement.h"
#include "SVGPolylineElement.h"
#include "SVGRadialGradientElement.h"
#include "SVGRectElement.h"
#include "SVGScriptElement.h"
#include "SVGSetElement.h"
#include "SVGStopElement.h"
#include "SVGStyleElement.h"
#include "SVGSVGElement.h"
#include "SVGSwitchElement.h"
#include "SVGSymbolElement.h"
#include "SVGTextElement.h"
#include "SVGTextPathElement.h"
#include "SVGTitleElement.h"
#include "SVGTRefElement.h"
#include "SVGTSpanElement.h"
#include "SVGUseElement.h"
#include "SVGViewElement.h"
#include <wtf/HashMap.h>

using namespace WebCore;

typedef PassRefPtr<SVGElement> (*ConstructorFunction)(Document*, bool createdByParser);
typedef WTF::HashMap<AtomicStringImpl*, ConstructorFunction> FunctionMap;

static FunctionMap* gFunctionMap = 0;

namespace WebCore {

#if ENABLE(SVG)
static PassRefPtr<SVGElement> aConstructor(Document* doc, bool createdByParser)
{
    return new SVGAElement(SVGNames::aTag, doc);
}

static PassRefPtr<SVGElement> altGlyphConstructor(Document* doc, bool createdByParser)
{
    return new SVGAltGlyphElement(SVGNames::altGlyphTag, doc);
}

static PassRefPtr<SVGElement> animateConstructor(Document* doc, bool createdByParser)
{
    return new SVGAnimateElement(SVGNames::animateTag, doc);
}

static PassRefPtr<SVGElement> animateColorConstructor(Document* doc, bool createdByParser)
{
    return new SVGAnimateColorElement(SVGNames::animateColorTag, doc);
}

static PassRefPtr<SVGElement> animateMotionConstructor(Document* doc, bool createdByParser)
{
    return new SVGAnimateMotionElement(SVGNames::animateMotionTag, doc);
}

static PassRefPtr<SVGElement> animateTransformConstructor(Document* doc, bool createdByParser)
{
    return new SVGAnimateTransformElement(SVGNames::animateTransformTag, doc);
}

static PassRefPtr<SVGElement> circleConstructor(Document* doc, bool createdByParser)
{
    return new SVGCircleElement(SVGNames::circleTag, doc);
}

static PassRefPtr<SVGElement> clipPathConstructor(Document* doc, bool createdByParser)
{
    return new SVGClipPathElement(SVGNames::clipPathTag, doc);
}

static PassRefPtr<SVGElement> cursorConstructor(Document* doc, bool createdByParser)
{
    return new SVGCursorElement(SVGNames::cursorTag, doc);
}

static PassRefPtr<SVGElement> definition_srcConstructor(Document* doc, bool createdByParser)
{
    return new SVGDefinitionSrcElement(SVGNames::definition_srcTag, doc);
}

static PassRefPtr<SVGElement> defsConstructor(Document* doc, bool createdByParser)
{
    return new SVGDefsElement(SVGNames::defsTag, doc);
}

static PassRefPtr<SVGElement> descConstructor(Document* doc, bool createdByParser)
{
    return new SVGDescElement(SVGNames::descTag, doc);
}

static PassRefPtr<SVGElement> ellipseConstructor(Document* doc, bool createdByParser)
{
    return new SVGEllipseElement(SVGNames::ellipseTag, doc);
}

static PassRefPtr<SVGElement> feBlendConstructor(Document* doc, bool createdByParser)
{
    return new SVGFEBlendElement(SVGNames::feBlendTag, doc);
}

static PassRefPtr<SVGElement> feColorMatrixConstructor(Document* doc, bool createdByParser)
{
    return new SVGFEColorMatrixElement(SVGNames::feColorMatrixTag, doc);
}

static PassRefPtr<SVGElement> feComponentTransferConstructor(Document* doc, bool createdByParser)
{
    return new SVGFEComponentTransferElement(SVGNames::feComponentTransferTag, doc);
}

static PassRefPtr<SVGElement> feCompositeConstructor(Document* doc, bool createdByParser)
{
    return new SVGFECompositeElement(SVGNames::feCompositeTag, doc);
}

static PassRefPtr<SVGElement> feDiffuseLightingConstructor(Document* doc, bool createdByParser)
{
    return new SVGFEDiffuseLightingElement(SVGNames::feDiffuseLightingTag, doc);
}

static PassRefPtr<SVGElement> feDisplacementMapConstructor(Document* doc, bool createdByParser)
{
    return new SVGFEDisplacementMapElement(SVGNames::feDisplacementMapTag, doc);
}

static PassRefPtr<SVGElement> feDistantLightConstructor(Document* doc, bool createdByParser)
{
    return new SVGFEDistantLightElement(SVGNames::feDistantLightTag, doc);
}

static PassRefPtr<SVGElement> feFloodConstructor(Document* doc, bool createdByParser)
{
    return new SVGFEFloodElement(SVGNames::feFloodTag, doc);
}

static PassRefPtr<SVGElement> feFuncAConstructor(Document* doc, bool createdByParser)
{
    return new SVGFEFuncAElement(SVGNames::feFuncATag, doc);
}

static PassRefPtr<SVGElement> feFuncBConstructor(Document* doc, bool createdByParser)
{
    return new SVGFEFuncBElement(SVGNames::feFuncBTag, doc);
}

static PassRefPtr<SVGElement> feFuncGConstructor(Document* doc, bool createdByParser)
{
    return new SVGFEFuncGElement(SVGNames::feFuncGTag, doc);
}

static PassRefPtr<SVGElement> feFuncRConstructor(Document* doc, bool createdByParser)
{
    return new SVGFEFuncRElement(SVGNames::feFuncRTag, doc);
}

static PassRefPtr<SVGElement> feGaussianBlurConstructor(Document* doc, bool createdByParser)
{
    return new SVGFEGaussianBlurElement(SVGNames::feGaussianBlurTag, doc);
}

static PassRefPtr<SVGElement> feImageConstructor(Document* doc, bool createdByParser)
{
    return new SVGFEImageElement(SVGNames::feImageTag, doc);
}

static PassRefPtr<SVGElement> feMergeConstructor(Document* doc, bool createdByParser)
{
    return new SVGFEMergeElement(SVGNames::feMergeTag, doc);
}

static PassRefPtr<SVGElement> feMergeNodeConstructor(Document* doc, bool createdByParser)
{
    return new SVGFEMergeNodeElement(SVGNames::feMergeNodeTag, doc);
}

static PassRefPtr<SVGElement> feOffsetConstructor(Document* doc, bool createdByParser)
{
    return new SVGFEOffsetElement(SVGNames::feOffsetTag, doc);
}

static PassRefPtr<SVGElement> fePointLightConstructor(Document* doc, bool createdByParser)
{
    return new SVGFEPointLightElement(SVGNames::fePointLightTag, doc);
}

static PassRefPtr<SVGElement> feSpecularLightingConstructor(Document* doc, bool createdByParser)
{
    return new SVGFESpecularLightingElement(SVGNames::feSpecularLightingTag, doc);
}

static PassRefPtr<SVGElement> feSpotLightConstructor(Document* doc, bool createdByParser)
{
    return new SVGFESpotLightElement(SVGNames::feSpotLightTag, doc);
}

static PassRefPtr<SVGElement> feTileConstructor(Document* doc, bool createdByParser)
{
    return new SVGFETileElement(SVGNames::feTileTag, doc);
}

static PassRefPtr<SVGElement> feTurbulenceConstructor(Document* doc, bool createdByParser)
{
    return new SVGFETurbulenceElement(SVGNames::feTurbulenceTag, doc);
}

static PassRefPtr<SVGElement> filterConstructor(Document* doc, bool createdByParser)
{
    return new SVGFilterElement(SVGNames::filterTag, doc);
}

static PassRefPtr<SVGElement> fontConstructor(Document* doc, bool createdByParser)
{
    return new SVGFontElement(SVGNames::fontTag, doc);
}

static PassRefPtr<SVGElement> font_faceConstructor(Document* doc, bool createdByParser)
{
    return new SVGFontFaceElement(SVGNames::font_faceTag, doc);
}

static PassRefPtr<SVGElement> font_face_formatConstructor(Document* doc, bool createdByParser)
{
    return new SVGFontFaceFormatElement(SVGNames::font_face_formatTag, doc);
}

static PassRefPtr<SVGElement> font_face_nameConstructor(Document* doc, bool createdByParser)
{
    return new SVGFontFaceNameElement(SVGNames::font_face_nameTag, doc);
}

static PassRefPtr<SVGElement> font_face_srcConstructor(Document* doc, bool createdByParser)
{
    return new SVGFontFaceSrcElement(SVGNames::font_face_srcTag, doc);
}

static PassRefPtr<SVGElement> font_face_uriConstructor(Document* doc, bool createdByParser)
{
    return new SVGFontFaceUriElement(SVGNames::font_face_uriTag, doc);
}

static PassRefPtr<SVGElement> foreignObjectConstructor(Document* doc, bool createdByParser)
{
    return new SVGForeignObjectElement(SVGNames::foreignObjectTag, doc);
}

static PassRefPtr<SVGElement> gConstructor(Document* doc, bool createdByParser)
{
    return new SVGGElement(SVGNames::gTag, doc);
}

static PassRefPtr<SVGElement> glyphConstructor(Document* doc, bool createdByParser)
{
    return new SVGGlyphElement(SVGNames::glyphTag, doc);
}

static PassRefPtr<SVGElement> hkernConstructor(Document* doc, bool createdByParser)
{
    return new SVGHKernElement(SVGNames::hkernTag, doc);
}

static PassRefPtr<SVGElement> imageConstructor(Document* doc, bool createdByParser)
{
    return new SVGImageElement(SVGNames::imageTag, doc);
}

static PassRefPtr<SVGElement> lineConstructor(Document* doc, bool createdByParser)
{
    return new SVGLineElement(SVGNames::lineTag, doc);
}

static PassRefPtr<SVGElement> linearGradientConstructor(Document* doc, bool createdByParser)
{
    return new SVGLinearGradientElement(SVGNames::linearGradientTag, doc);
}

static PassRefPtr<SVGElement> markerConstructor(Document* doc, bool createdByParser)
{
    return new SVGMarkerElement(SVGNames::markerTag, doc);
}

static PassRefPtr<SVGElement> maskConstructor(Document* doc, bool createdByParser)
{
    return new SVGMaskElement(SVGNames::maskTag, doc);
}

static PassRefPtr<SVGElement> metadataConstructor(Document* doc, bool createdByParser)
{
    return new SVGMetadataElement(SVGNames::metadataTag, doc);
}

static PassRefPtr<SVGElement> missing_glyphConstructor(Document* doc, bool createdByParser)
{
    return new SVGMissingGlyphElement(SVGNames::missing_glyphTag, doc);
}

static PassRefPtr<SVGElement> mpathConstructor(Document* doc, bool createdByParser)
{
    return new SVGMPathElement(SVGNames::mpathTag, doc);
}

static PassRefPtr<SVGElement> pathConstructor(Document* doc, bool createdByParser)
{
    return new SVGPathElement(SVGNames::pathTag, doc);
}

static PassRefPtr<SVGElement> patternConstructor(Document* doc, bool createdByParser)
{
    return new SVGPatternElement(SVGNames::patternTag, doc);
}

static PassRefPtr<SVGElement> polygonConstructor(Document* doc, bool createdByParser)
{
    return new SVGPolygonElement(SVGNames::polygonTag, doc);
}

static PassRefPtr<SVGElement> polylineConstructor(Document* doc, bool createdByParser)
{
    return new SVGPolylineElement(SVGNames::polylineTag, doc);
}

static PassRefPtr<SVGElement> radialGradientConstructor(Document* doc, bool createdByParser)
{
    return new SVGRadialGradientElement(SVGNames::radialGradientTag, doc);
}

static PassRefPtr<SVGElement> rectConstructor(Document* doc, bool createdByParser)
{
    return new SVGRectElement(SVGNames::rectTag, doc);
}

static PassRefPtr<SVGElement> scriptConstructor(Document* doc, bool createdByParser)
{
    return new SVGScriptElement(SVGNames::scriptTag, doc, createdByParser);
}

static PassRefPtr<SVGElement> setConstructor(Document* doc, bool createdByParser)
{
    return new SVGSetElement(SVGNames::setTag, doc);
}

static PassRefPtr<SVGElement> stopConstructor(Document* doc, bool createdByParser)
{
    return new SVGStopElement(SVGNames::stopTag, doc);
}

static PassRefPtr<SVGElement> styleConstructor(Document* doc, bool createdByParser)
{
    return new SVGStyleElement(SVGNames::styleTag, doc, createdByParser);
}

static PassRefPtr<SVGElement> svgConstructor(Document* doc, bool createdByParser)
{
    return new SVGSVGElement(SVGNames::svgTag, doc);
}

static PassRefPtr<SVGElement> switchConstructor(Document* doc, bool createdByParser)
{
    return new SVGSwitchElement(SVGNames::switchTag, doc);
}

static PassRefPtr<SVGElement> symbolConstructor(Document* doc, bool createdByParser)
{
    return new SVGSymbolElement(SVGNames::symbolTag, doc);
}

static PassRefPtr<SVGElement> textConstructor(Document* doc, bool createdByParser)
{
    return new SVGTextElement(SVGNames::textTag, doc);
}

static PassRefPtr<SVGElement> textPathConstructor(Document* doc, bool createdByParser)
{
    return new SVGTextPathElement(SVGNames::textPathTag, doc);
}

static PassRefPtr<SVGElement> titleConstructor(Document* doc, bool createdByParser)
{
    return new SVGTitleElement(SVGNames::titleTag, doc);
}

static PassRefPtr<SVGElement> trefConstructor(Document* doc, bool createdByParser)
{
    return new SVGTRefElement(SVGNames::trefTag, doc);
}

static PassRefPtr<SVGElement> tspanConstructor(Document* doc, bool createdByParser)
{
    return new SVGTSpanElement(SVGNames::tspanTag, doc);
}

static PassRefPtr<SVGElement> useConstructor(Document* doc, bool createdByParser)
{
    return new SVGUseElement(SVGNames::useTag, doc);
}

static PassRefPtr<SVGElement> viewConstructor(Document* doc, bool createdByParser)
{
    return new SVGViewElement(SVGNames::viewTag, doc);
}

#endif
#if ENABLE(SVG)
static inline void createFunctionMapIfNecessary()
{
    if (gFunctionMap)
        return;
    // Create the table.
    gFunctionMap = new FunctionMap;
    
    // Populate it with constructor functions.
    gFunctionMap->set(SVGNames::aTag.localName().impl(), aConstructor);
    gFunctionMap->set(SVGNames::altGlyphTag.localName().impl(), altGlyphConstructor);
    gFunctionMap->set(SVGNames::animateTag.localName().impl(), animateConstructor);
    gFunctionMap->set(SVGNames::animateColorTag.localName().impl(), animateColorConstructor);
    gFunctionMap->set(SVGNames::animateMotionTag.localName().impl(), animateMotionConstructor);
    gFunctionMap->set(SVGNames::animateTransformTag.localName().impl(), animateTransformConstructor);
    gFunctionMap->set(SVGNames::circleTag.localName().impl(), circleConstructor);
    gFunctionMap->set(SVGNames::clipPathTag.localName().impl(), clipPathConstructor);
    gFunctionMap->set(SVGNames::cursorTag.localName().impl(), cursorConstructor);
    gFunctionMap->set(SVGNames::definition_srcTag.localName().impl(), definition_srcConstructor);
    gFunctionMap->set(SVGNames::defsTag.localName().impl(), defsConstructor);
    gFunctionMap->set(SVGNames::descTag.localName().impl(), descConstructor);
    gFunctionMap->set(SVGNames::ellipseTag.localName().impl(), ellipseConstructor);
    gFunctionMap->set(SVGNames::feBlendTag.localName().impl(), feBlendConstructor);
    gFunctionMap->set(SVGNames::feColorMatrixTag.localName().impl(), feColorMatrixConstructor);
    gFunctionMap->set(SVGNames::feComponentTransferTag.localName().impl(), feComponentTransferConstructor);
    gFunctionMap->set(SVGNames::feCompositeTag.localName().impl(), feCompositeConstructor);
    gFunctionMap->set(SVGNames::feDiffuseLightingTag.localName().impl(), feDiffuseLightingConstructor);
    gFunctionMap->set(SVGNames::feDisplacementMapTag.localName().impl(), feDisplacementMapConstructor);
    gFunctionMap->set(SVGNames::feDistantLightTag.localName().impl(), feDistantLightConstructor);
    gFunctionMap->set(SVGNames::feFloodTag.localName().impl(), feFloodConstructor);
    gFunctionMap->set(SVGNames::feFuncATag.localName().impl(), feFuncAConstructor);
    gFunctionMap->set(SVGNames::feFuncBTag.localName().impl(), feFuncBConstructor);
    gFunctionMap->set(SVGNames::feFuncGTag.localName().impl(), feFuncGConstructor);
    gFunctionMap->set(SVGNames::feFuncRTag.localName().impl(), feFuncRConstructor);
    gFunctionMap->set(SVGNames::feGaussianBlurTag.localName().impl(), feGaussianBlurConstructor);
    gFunctionMap->set(SVGNames::feImageTag.localName().impl(), feImageConstructor);
    gFunctionMap->set(SVGNames::feMergeTag.localName().impl(), feMergeConstructor);
    gFunctionMap->set(SVGNames::feMergeNodeTag.localName().impl(), feMergeNodeConstructor);
    gFunctionMap->set(SVGNames::feOffsetTag.localName().impl(), feOffsetConstructor);
    gFunctionMap->set(SVGNames::fePointLightTag.localName().impl(), fePointLightConstructor);
    gFunctionMap->set(SVGNames::feSpecularLightingTag.localName().impl(), feSpecularLightingConstructor);
    gFunctionMap->set(SVGNames::feSpotLightTag.localName().impl(), feSpotLightConstructor);
    gFunctionMap->set(SVGNames::feTileTag.localName().impl(), feTileConstructor);
    gFunctionMap->set(SVGNames::feTurbulenceTag.localName().impl(), feTurbulenceConstructor);
    gFunctionMap->set(SVGNames::filterTag.localName().impl(), filterConstructor);
    gFunctionMap->set(SVGNames::fontTag.localName().impl(), fontConstructor);
    gFunctionMap->set(SVGNames::font_faceTag.localName().impl(), font_faceConstructor);
    gFunctionMap->set(SVGNames::font_face_formatTag.localName().impl(), font_face_formatConstructor);
    gFunctionMap->set(SVGNames::font_face_nameTag.localName().impl(), font_face_nameConstructor);
    gFunctionMap->set(SVGNames::font_face_srcTag.localName().impl(), font_face_srcConstructor);
    gFunctionMap->set(SVGNames::font_face_uriTag.localName().impl(), font_face_uriConstructor);
    gFunctionMap->set(SVGNames::foreignObjectTag.localName().impl(), foreignObjectConstructor);
    gFunctionMap->set(SVGNames::gTag.localName().impl(), gConstructor);
    gFunctionMap->set(SVGNames::glyphTag.localName().impl(), glyphConstructor);
    gFunctionMap->set(SVGNames::hkernTag.localName().impl(), hkernConstructor);
    gFunctionMap->set(SVGNames::imageTag.localName().impl(), imageConstructor);
    gFunctionMap->set(SVGNames::lineTag.localName().impl(), lineConstructor);
    gFunctionMap->set(SVGNames::linearGradientTag.localName().impl(), linearGradientConstructor);
    gFunctionMap->set(SVGNames::markerTag.localName().impl(), markerConstructor);
    gFunctionMap->set(SVGNames::maskTag.localName().impl(), maskConstructor);
    gFunctionMap->set(SVGNames::metadataTag.localName().impl(), metadataConstructor);
    gFunctionMap->set(SVGNames::missing_glyphTag.localName().impl(), missing_glyphConstructor);
    gFunctionMap->set(SVGNames::mpathTag.localName().impl(), mpathConstructor);
    gFunctionMap->set(SVGNames::pathTag.localName().impl(), pathConstructor);
    gFunctionMap->set(SVGNames::patternTag.localName().impl(), patternConstructor);
    gFunctionMap->set(SVGNames::polygonTag.localName().impl(), polygonConstructor);
    gFunctionMap->set(SVGNames::polylineTag.localName().impl(), polylineConstructor);
    gFunctionMap->set(SVGNames::radialGradientTag.localName().impl(), radialGradientConstructor);
    gFunctionMap->set(SVGNames::rectTag.localName().impl(), rectConstructor);
    gFunctionMap->set(SVGNames::scriptTag.localName().impl(), scriptConstructor);
    gFunctionMap->set(SVGNames::setTag.localName().impl(), setConstructor);
    gFunctionMap->set(SVGNames::stopTag.localName().impl(), stopConstructor);
    gFunctionMap->set(SVGNames::styleTag.localName().impl(), styleConstructor);
    gFunctionMap->set(SVGNames::svgTag.localName().impl(), svgConstructor);
    gFunctionMap->set(SVGNames::switchTag.localName().impl(), switchConstructor);
    gFunctionMap->set(SVGNames::symbolTag.localName().impl(), symbolConstructor);
    gFunctionMap->set(SVGNames::textTag.localName().impl(), textConstructor);
    gFunctionMap->set(SVGNames::textPathTag.localName().impl(), textPathConstructor);
    gFunctionMap->set(SVGNames::titleTag.localName().impl(), titleConstructor);
    gFunctionMap->set(SVGNames::trefTag.localName().impl(), trefConstructor);
    gFunctionMap->set(SVGNames::tspanTag.localName().impl(), tspanConstructor);
    gFunctionMap->set(SVGNames::useTag.localName().impl(), useConstructor);
    gFunctionMap->set(SVGNames::viewTag.localName().impl(), viewConstructor);
}
#endif

PassRefPtr<SVGElement> SVGElementFactory::createSVGElement(const QualifiedName& qName, Document* doc, bool createdByParser)
{
#if ENABLE(SVG)
    // Don't make elements without a document
    if (!doc)
        return 0;

#if ENABLE(DASHBOARD_SUPPORT)
    Settings* settings = doc->settings();
    if (settings && settings->usesDashboardBackwardCompatibilityMode())
        return 0;
#endif

    createFunctionMapIfNecessary();
    ConstructorFunction func = gFunctionMap->get(qName.localName().impl());
    if (func)
        return func(doc, createdByParser);

    return new SVGElement(qName, doc);
#else
    return 0;
#endif
}

} // namespace WebCore

