/*      xmms - aRts output plugin
 *    Copyright (C) 2000      B. Heath Robinson
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 *  Contains code Copyright (C) 1998-2000 Mikael Alm, Olle Hallnas,
 *  Thomas Nillson, 4Front Technologies and Galex Yen
 */

#include "artsout.h"

aRtsConfig arts_cfg;

void artsd_init(void)
{
	ConfigFile *cfgfile;
	gchar *filename;

	memset(&arts_cfg, 0, sizeof (aRtsConfig));
	arts_cfg.buffer_size = 3000;
	arts_cfg.prebuffer = 25;

	filename = g_strconcat(g_get_home_dir(), "/.xmms/config", NULL);
	if ((cfgfile = xmms_cfg_open_file(filename)))
	{
		xmms_cfg_read_int(cfgfile, "aRts", "buffer_size", &arts_cfg.buffer_size);
		xmms_cfg_read_int(cfgfile, "aRts", "prebuffer", &arts_cfg.prebuffer);
		xmms_cfg_free(cfgfile);
	}
}
