--TEST--
strtotime() function
--SKIPIF--
<?php
if (!@putenv("TZ=Europe/Amsterdam") || getenv("TZ") != 'Europe/Amsterdam') {
	die("skip unable to change TZ enviroment variable\n");
}
?>
--FILE--
<?php
	$dates = array (
		"1999-10-13",
		"Oct 13  1999",
		"2000-01-19",
		"Jan 19  2000",
		"2001-12-21",
		"Dec 21  2001",
		"2001-12-21 12:16",
		"Dec 21 2001 12:16",
		"Dec 21  12:16",
	    "2001-10-22 21:19:58",
	    "2001-10-22 21:19:58-02",
	    "2001-10-22 21:19:58-0213",
	    "2001-10-22 21:19:58+02",
    	"2001-10-22 21:19:58+0213"
	);

	putenv ("TZ=GMT");
	foreach ($dates as $date) {
	    echo date ("Y-m-d H:i:s\n", strtotime ($date));
	}

	putenv ("TZ=Europe/Amsterdam");
	foreach ($dates as $date) {
	    echo date ("Y-m-d H:i:s\n", strtotime ($date));
	}
?>
--EXPECT--
1999-10-13 00:00:00
1999-10-13 00:00:00
2000-01-19 00:00:00
2000-01-19 00:00:00
2001-12-21 00:00:00
2001-12-21 00:00:00
2001-12-21 12:16:00
2001-12-21 12:16:00
1969-12-31 23:59:59
2001-10-22 21:19:58
2001-10-22 23:19:58
2001-10-22 23:32:58
2001-10-22 19:19:58
2001-10-22 19:06:58
1999-10-13 00:00:00
1999-10-13 00:00:00
2000-01-19 00:00:00
2000-01-19 00:00:00
2001-12-21 00:00:00
2001-12-21 00:00:00
2001-12-21 12:16:00
2001-12-21 12:16:00
1970-01-01 00:59:59
2001-10-22 21:19:58
2001-10-23 01:19:58
2001-10-23 01:32:58
2001-10-22 21:19:58
2001-10-22 21:06:58
