/*  This file is part of the KDE project
    Copyright (C) 2001-2002 Matthias Kretz <kretz@kde.org>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License version 2
    as published by the Free Software Foundation.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

*/
// $Id: kview.h,v 1.31 2002/08/25 14:38:26 mkretz Exp $

#ifndef KVIEW_H
#define KVIEW_H

#include <config.h>

#include <kapplication.h>
#include <kparts/mainwindow.h>

namespace KParts {
	class ReadWritePart;
}
namespace KImageViewer {
	class Canvas;
	class Viewer;
}
class QSize;
class QRect;
class KAction;
class KToggleAction;
class KRecentFilesAction;
class KWinModule;
class QStringList;
class KProgress;
class KPreferencesDialog;

class KView : public KParts::MainWindow
{
	Q_OBJECT
	public:
		KView();
		virtual ~KView();
		void load( const KURL & url );
		QSize sizeForCentralWidgetSize( QSize );
		KImageViewer::Viewer * viewer() const { return m_pViewer; }

	protected:
		bool queryClose();
		void saveProperties( KConfig * );
		void readProperties( KConfig * );
		void saveSettings( KConfig * );

		virtual void resizeEvent( QResizeEvent * );

	protected slots:
		void readSettings(); //KConfig * );
		void imageSizeChanged( const QSize & );
		void selectionChanged( const QRect & );
		void contextPress( const QPoint & );
		void slotOpenFile();
		void slotOpenRecent( const KURL & );
		void slotClose();
		void slotCopy();
		void slotPaste();
		void slotCrop();
		void slotToggleFullScreen();
		void slotToggleMenubar();
		void slotToggleStatusbar();
		void slotPreferences();
		void slotKeyBindings();
		void slotConfigureToolbars();
		void slotNewToolbarConfig();
		void reloadConfig();
		void enableAction( const char *, bool );
		void clipboardDataChanged();
		void jobStarted( KIO::Job * );
		void jobCompleted();
		void jobCompleted( bool );
		void jobCanceled( const QString & );
		void loadingProgress( KIO::Job *, unsigned long );
		void speedProgress( KIO::Job *, unsigned long );
		void slotSetStatusBarText( const QString & );
		void loadPlugins();

	private:
		enum BarSizeFrom { FromImageSize, FromWidgetSize };
		enum ResizeMode { ResizeWindow = 0, ResizeImage = 1, NoResize = 2 };
		enum StatusBarItem { STATUSBAR_SPEED_ID };
		void setupActions( QObject * );
		void handleResize();
		void fitWindowToImage();
		QSize barSize( int, BarSizeFrom );
		QSize maxCanvasSize();

		KImageViewer::Viewer * m_pViewer;
		KImageViewer::Canvas * m_pCanvas;
		KWinModule * m_pWinModule;

		KPreferencesDialog * m_pPreferencesDialog;

		// Actions:
		KAction * m_paOpenFile;
		KAction * m_paPaste;
		KRecentFilesAction * m_paRecent;
		KAction * m_paQuit;
		KToggleAction * m_paShowFullScreen;
		KToggleAction * m_paShowMenubar;
		KToggleAction * m_paShowStatusbar;

		int m_nResizeMode;
		bool m_bFullScreen;
		bool m_bImageSizeChangedBlocked;

		KProgress * m_pProgressBar;
};

// vim:sw=4:ts=4

#endif // KVIEW_H
