/*
**************************************************************************
                                 description
                             --------------------
    copyright            : (C) 2000-2001 by Andreas Zehender
    email                : zehender@kde.org
**************************************************************************

**************************************************************************
*                                                                        *
*  This program is free software; you can redistribute it and/or modify  *
*  it under the terms of the GNU General Public License as published by  *
*  the Free Software Foundation; either version 2 of the License, or     *
*  (at your option) any later version.                                   *
*                                                                        *
**************************************************************************/


#include "pmobjectdrag.h"
#include "pmobject.h"
#include "pmpovrayparser.h"
#include "pmxmlparser.h"
#include "pmxmlhelper.h"
#include "pmoutputdevice.h"
#include "pmdocumentformat.h"

#include <qtextstream.h>
#include <string.h>

PMObjectDrag::PMObjectDrag( PMObject* object, QWidget* dragSource,
                            const char* name )
      : QDragObject( dragSource, name )
{
   QTextStream stream( m_povrayData, IO_WriteOnly );
   PMOutputDevice dev( stream );
   object->serialize( dev );

   QTextStream s2( m_modelerData, IO_WriteOnly );
   QDomDocument doc( "KPOVMODELER" );
   QDomElement top = doc.createElement( "objects" );
   doc.appendChild( top );
   top.setAttribute( "majorFormat", c_majorDocumentFormat );
   top.setAttribute( "minorFormat", c_minorDocumentFormat );

   if( object->type( ) == PMTScene )
   {
      PMObject* o = object->firstChild( );
      for( ; o; o = o->nextSibling( ) )
      {
         QDomElement e = o->serialize( doc );
         top.appendChild( e );
      }
   }
   else
   {
      QDomElement e = object->serialize( doc );
      top.appendChild( e );
   }
   s2 << doc;
}

PMObjectDrag::PMObjectDrag( const PMObjectList& objList, QWidget* dragSource,
                            const char* name )
      : QDragObject( dragSource, name )
{
   QTextStream stream( m_povrayData, IO_WriteOnly );
   PMOutputDevice dev( stream );

   QTextStream s2( m_modelerData, IO_WriteOnly );
   QDomDocument doc( "KPOVMODELER" );
   QDomElement top = doc.createElement( "objects" );
   doc.appendChild( top );
   top.setAttribute( "majorFormat", c_majorDocumentFormat );
   top.setAttribute( "minorFormat", c_minorDocumentFormat );

   PMObjectListIterator it( objList );
   for( ; it.current( ); ++it )
   {
      it.current( )->serialize( dev );

      if( it.current( )->type( ) == PMTScene )
      {
         PMObject* o = it.current( )->firstChild( );
         for( ; o; o = o->nextSibling( ) )
         {
            QDomElement e = o->serialize( doc );
            top.appendChild( e );
         }
      }
      else
      {
         QDomElement e = it.current( )->serialize( doc );
         top.appendChild( e );
      }
   }
   
   s2 << doc;
}

PMObjectDrag::~PMObjectDrag( )
{
}

QByteArray PMObjectDrag::encodedData( const char* format ) const
{
   QString tmp( format );
   if( tmp == "text/plain" )
      return m_povrayData;
   else if( tmp == "application/kpovmodeler" )
      return m_modelerData;
   QByteArray empty;
   return empty;
}

const char* PMObjectDrag::format( int i /*=0*/ ) const
{
   if( i == 0 )
      return "text/plain";
   else if( i == 1 )
      return "application/kpovmodeler";
   return 0;
}

bool PMObjectDrag::canDecode( const QMimeSource* e )
{
   return ( e->provides( "text/plain" ) ||
            e->provides( "application/kpovmodeler" ) );
      
}

PMParser* PMObjectDrag::newParser( const QMimeSource* e, PMPart* part )
{
   bool stop = false;
   int i = 0;
   bool kpm = false, text = false;
   const char* f;
   
   for( i = 0; !stop && !kpm; ++i )
   {
      f = e->format(i);
      if( f )
      {
         if( strcmp( f, "application/kpovmodeler" ) == 0 )
            kpm = true;
         else if( strcmp( f, "text/plain" ) == 0 )
            text = true;
      }
      else
         stop = true;
   }
   
   if( kpm )
      return new PMXMLParser( part, e->encodedData( "application/kpovmodeler" ) );
   else if( text )
      return new PMPovrayParser( part, e->encodedData( "text/plain" ) );
   
   return 0;
}

/*
bool PMObjectDrag::decode( const QMimeSource* e, PMObjectList* list,
                           PMParser* parser, const PMObject* parent )
{
   if( e->provides( "application/kpovmodeler" ) )
   {
      parser->parse( e->encodedData( "application/kpovmodeler" ), true,
                     list, parent );
      return ( !parser->errors( ) && !parser->warnings( ) );
   }
   else if( e->provides( "text/plain" ) )
   {
      parser->parse( e->encodedData( "text/plain" ), false,
                     list, parent );
      return ( !parser->errors( ) && !parser->warnings( ) );
   }
   
   return false;
}
*/
