/*     
 **********************************************************************
 *     icardwav.h
 *     Copyright 1999, 2000 Creative Labs, Inc. 
 * 
 ********************************************************************** 
 * 
 *     Date                 Author          Summary of changes 
 *     ----                 ------          ------------------ 
 *     October 20, 1999     Bertrand Lee    base code release 
 * 
 ********************************************************************** 
 * 
 *     This program is free software; you can redistribute it and/or 
 *     modify it under the terms of the GNU General Public License as 
 *     published by the Free Software Foundation; either version 2 of 
 *     the License, or (at your option) any later version. 
 * 
 *     This program is distributed in the hope that it will be useful, 
 *     but WITHOUT ANY WARRANTY; without even the implied warranty of 
 *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the 
 *     GNU General Public License for more details. 
 * 
 *     You should have received a copy of the GNU General Public 
 *     License along with this program; if not, write to the Free 
 *     Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, 
 *     USA. 
 * 
 ********************************************************************** 
 */

#ifndef _ICARDWAV_H
#define _ICARDWAV_H

#define MAX_CARDWAVE_DESC   80

struct wave_caps 
{
	u32 product_id;
	u32 caps;
	u32 controls;
	u32 maxchannels;
	u32 minrate, maxrate;
	char wavedesc[MAX_CARDWAVE_DESC];
};

#define CARDWAVE_OUT                0x0001
#define CARDWAVE_IN                 0x0002
#define CARDWAVE_ALLOW_DIRECTXFER   0x0004
#define CARDWAVE_CONTINUOUS_RATE    0x0008
#define CARDWAVE_ALLOW_3D           0x0010

#define CARDWAVE_CONTROL_VOLUME     0x0001
#define CARDWAVE_CONTROL_MUTE       0x0002
#define CARDWAVE_CONTROL_PAN        0x0004
#define CARDWAVE_CONTROL_RATE       0x0008
#define CARDWAVE_CONTROL_XFERPOS    0x1000
#define CARDWAVE_CONTROL_LOOPING    0x2000

#define CARDWAVE_PLAY_LOOPING       0x00000001

struct wave_format 
{
	u32 samplingrate;
	u32 bitspersample;
	u32 channels;		/* 1 = Mono, 2 = Stereo */
	int isinput;
	u32 flags;
};

#define CARDWAVE_FORMAT_NORMAL              0x0000
#define CARDWAVE_FORMAT_NOCONVERT_RATE      0x0001
#define CARDWAVE_FORMAT_NOCONVERT_BITS      0x0002
#define CARDWAVE_FORMAT_NOCONVERT_CHANNEL   0x0004
#define CARDWAVE_FORMAT_NOCONVERT_ALL       (CARDWAVE_FORMAT_NOCONVERT_RATE | CARDWAVE_FORMAT_NOCONVERT_BITS | CARDWAVE_FORMAT_CHANNEL )
#define CARDWAVE_FORMAT_DIRECTSOUND         0x2000
#define CARDWAVE_FORMAT_DUP_BUFFER          0x4000
#define CARDWAVE_FORMAT_DO_DIRECTXFER       0x8000
#define CARDWAVE_FORMAT_3D_BUFFER           0x0100
#define CARDWAVE_FORMAT_SOFTSYNTH           0x0200
#define CARDWAVE_FORMAT_PRIMARY_BUFFER      0x0400

/* Flags for QueryFormat */
#define CARDWAVE_QF_RATE        0x00000001
#define CARDWAVE_QF_BITS        0x00000002
#define CARDWAVE_QF_CHANNEL     0x00000004
#define CARDWAVE_QF_ALL         (CARDWAVE_QF_RATE | CARDWAVE_QF_BITS | CARDWAVE_QF_CHANNEL)
#define CARDWAVE_QF_DIRECTXFER  0x40000000
#define CARDWAVE_QF_PHYSICAL    0x80000000

/* Buffer type */
#define CARDWAVE_DMA_BUFFER     0x0001
#define CARDWAVE_LINEAR_BUFFER  0x0002

/* Event definitions */
#define CARDWAVE_EVENT_CALLBACKSIZEREACHED  0x00000000
#define CARDWAVE_EVENT_TIMER                0x00000002

#endif /* _ICARDWAV_H */
