#!python
# Copyright 2010 Google Inc.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#      http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# DO NOT EDIT. This is an ETW event descriptor file generated by
# sawbuck/py/generate_descriptor.py. It contains event descriptions for
# MOF GUID {3d6fa8d3-fe05-11d0-9dda-00c04fd7ba7c}.

from etw.descriptors import event, field


class Event(object):
  GUID = '{3d6fa8d3-fe05-11d0-9dda-00c04fd7ba7c}'
  TransitionFault = (GUID, 10)
  DemandZeroFault = (GUID, 11)
  CopyOnWrite = (GUID, 12)
  GuardPageFault = (GUID, 13)
  HardPageFault = (GUID, 14)
  AccessViolation = (GUID, 15)
  HardFault = (GUID, 32)
  VirtualAlloc = (GUID, 98)
  VirtualFree = (GUID, 99)
  HRRundown = (GUID, 100)
  HRCreate = (GUID, 101)
  HRReserve = (GUID, 102)
  HRRelease = (GUID, 103)
  HRDestroy = (GUID, 104)
  ImageLoadBacked = (GUID, 105)


class PageFault_V2(event.EventCategory):
  GUID = Event.GUID
  VERSION = 2

  class PageFault_HardFault(event.EventClass):
    _event_types_ = [32]
    _fields_ = [('InitialTime', field.UInt64),
                ('ReadOffset', field.UInt64),
                ('VirtualAddress', field.Pointer),
                ('FileObject', field.Pointer),
                ('TThreadId', field.UInt32),
                ('ByteCount', field.UInt32)]

  class PageFault_VirtualAlloc(event.EventClass):
    _event_types_ = [98, 99]
    _fields_ = [('BaseAddress', field.Pointer),
                ('RegionSize', field.Int32),
                ('ProcessId', field.UInt32),
                ('Flags', field.UInt32)]

  class PageFault_HeapRangeRundown_V2(event.EventClass):
    _event_types_ = [100]
    _fields_ = [('HeapHandle', field.Pointer),
                ('HRFlags', field.UInt32),
                ('HRPid', field.UInt32),
                ('HRRangeCount', field.UInt32)]

  class PageFault_HeapRangeDestroy(event.EventClass):
    _event_types_ = [104]
    _fields_ = [('HeapHandle', field.Pointer)]

  class PageFault_TypeGroup1(event.EventClass):
    _event_types_ = [10, 11, 12, 13, 14, 15]
    _fields_ = [('VirtualAddress', field.Pointer),
                ('ProgramCounter', field.Pointer)]

  class PageFault_ImageLoadBacked(event.EventClass):
    _event_types_ = [105]
    _fields_ = [('FileObject', field.Pointer),
                ('DeviceChar', field.UInt32),
                ('FileChar', field.UInt16),
                ('LoadFlags', field.UInt16)]

  class PageFault_HeapRangeTypeGroup(event.EventClass):
    _event_types_ = [102, 103]
    _fields_ = [('HeapHandle', field.Pointer),
                ('HRAddress', field.Pointer),
                ('HRSize', field.Int32)]

  class PageFault_HeapRangeCreate(event.EventClass):
    _event_types_ = [101]
    _fields_ = [('HeapHandle', field.Pointer),
                ('FirstRangeSize', field.Int32),
                ('HRCreateFlags', field.UInt32)]


class PageFault(event.EventCategory):
  GUID = Event.GUID
  VERSION = 3

  class PageFault_HeapRangeRundown(event.EventClass):
    _event_types_ = [100]
    _fields_ = [('HeapHandle', field.Pointer),
                ('HRFlags', field.UInt32),
                ('HRPid', field.UInt32),
                ('HRRangeCount', field.UInt32),
                ('Reserved', field.UInt32)]
