//
// Book:      OpenGL(R) ES 2.0 Programming Guide
// Authors:   Aaftab Munshi, Dan Ginsburg, Dave Shreiner
// ISBN-10:   0321502795
// ISBN-13:   9780321502797
// Publisher: Addison-Wesley Professional
// URLs:      http://safari.informit.com/9780321563835
//            http://www.opengles-book.com
//

#ifndef SIMPLE_VERTEX_SHADER_H
#define SIMPLE_VERTEX_SHADER_H

#include "esUtil.h"

#ifdef __cplusplus
extern "C" {
#endif  // __cplusplus

typedef struct
{
   // Handle to a program object
   GLuint programObject;

   // Attribute locations
   GLint  positionLoc;

   // Uniform locations
   GLint  mvpLoc;
   
   // Vertex data
   int    numIndices;
   GLuint vboIds[2];

   // Rotation angle
   GLfloat   angle;

   // MVP matrix
   ESMatrix  mvpMatrix;
} SVSUserData;

extern int svsInit ( ESContext *esContext );

extern void svsUpdate ( ESContext *esContext, float deltaTime );

extern void svsDraw ( ESContext *esContext );

extern void svsShutDown ( ESContext *esContext );

#ifdef __cplusplus
}
#endif  // __cplusplus
#endif  // SIMPLE_VERTEX_SHADER_H
