/*
 * This file is autogenerated with bcop:
 * The Compiz option code generator
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 */

#ifndef _ATLANTIS_OPTIONS_H
#define _ATLANTIS_OPTIONS_H

#include <compiz-common.h>

COMPIZ_BEGIN_DECLS

CompPluginVTable * getCompPluginInfo (void);

typedef enum
{
    AtlantisDisplayOptionNum
} AtlantisDisplayOptions;

typedef void (*atlantisDisplayOptionChangeNotifyProc) (CompDisplay *display, CompOption *opt, AtlantisDisplayOptions num);

CompOption *atlantisGetDisplayOption (CompDisplay *d, AtlantisDisplayOptions num);

typedef enum
{
    AtlantisScreenOptionShowWater,
    AtlantisScreenOptionShowWaterWire,
    AtlantisScreenOptionShowGround,
    AtlantisScreenOptionWaterHeight,
    AtlantisScreenOptionWaterColor,
    AtlantisScreenOptionGridQuality,
    AtlantisScreenOptionRenderWaves,
    AtlantisScreenOptionWaveAmplitude,
    AtlantisScreenOptionWaveFrequency,
    AtlantisScreenOptionWaveSpeed,
    AtlantisScreenOptionSmallWaveAmplitude,
    AtlantisScreenOptionSmallWaveFrequency,
    AtlantisScreenOptionSmallWaveSpeed,
    AtlantisScreenOptionNumFish,
    AtlantisScreenOptionColors,
    AtlantisScreenOptionFishSize,
    AtlantisScreenOptionSharkSize,
    AtlantisScreenOptionDolphinSize,
    AtlantisScreenOptionWhaleSize,
    AtlantisScreenOptionNum
} AtlantisScreenOptions;

typedef void (*atlantisScreenOptionChangeNotifyProc) (CompScreen *screen, CompOption *opt, AtlantisScreenOptions num);

CompOption *atlantisGetScreenOption (CompScreen *s, AtlantisScreenOptions num);

Bool             atlantisGetShowWater (CompScreen *s);
CompOption *     atlantisGetShowWaterOption (CompScreen *s);
void             atlantisSetShowWaterNotify (CompScreen *s, atlantisScreenOptionChangeNotifyProc notify);

Bool             atlantisGetShowWaterWire (CompScreen *s);
CompOption *     atlantisGetShowWaterWireOption (CompScreen *s);
void             atlantisSetShowWaterWireNotify (CompScreen *s, atlantisScreenOptionChangeNotifyProc notify);

Bool             atlantisGetShowGround (CompScreen *s);
CompOption *     atlantisGetShowGroundOption (CompScreen *s);
void             atlantisSetShowGroundNotify (CompScreen *s, atlantisScreenOptionChangeNotifyProc notify);

float            atlantisGetWaterHeight (CompScreen *s);
CompOption *     atlantisGetWaterHeightOption (CompScreen *s);
void             atlantisSetWaterHeightNotify (CompScreen *s, atlantisScreenOptionChangeNotifyProc notify);

unsigned short * atlantisGetWaterColor (CompScreen *s);
unsigned short   atlantisGetWaterColorRed (CompScreen *s);
unsigned short   atlantisGetWaterColorGreen (CompScreen *s);
unsigned short   atlantisGetWaterColorBlue (CompScreen *s);
unsigned short   atlantisGetWaterColorAlpha (CompScreen *s);
CompOption *     atlantisGetWaterColorOption (CompScreen *s);
void             atlantisSetWaterColorNotify (CompScreen *s, atlantisScreenOptionChangeNotifyProc notify);

int              atlantisGetGridQuality (CompScreen *s);
CompOption *     atlantisGetGridQualityOption (CompScreen *s);
void             atlantisSetGridQualityNotify (CompScreen *s, atlantisScreenOptionChangeNotifyProc notify);

Bool             atlantisGetRenderWaves (CompScreen *s);
CompOption *     atlantisGetRenderWavesOption (CompScreen *s);
void             atlantisSetRenderWavesNotify (CompScreen *s, atlantisScreenOptionChangeNotifyProc notify);

float            atlantisGetWaveAmplitude (CompScreen *s);
CompOption *     atlantisGetWaveAmplitudeOption (CompScreen *s);
void             atlantisSetWaveAmplitudeNotify (CompScreen *s, atlantisScreenOptionChangeNotifyProc notify);

float            atlantisGetWaveFrequency (CompScreen *s);
CompOption *     atlantisGetWaveFrequencyOption (CompScreen *s);
void             atlantisSetWaveFrequencyNotify (CompScreen *s, atlantisScreenOptionChangeNotifyProc notify);

float            atlantisGetWaveSpeed (CompScreen *s);
CompOption *     atlantisGetWaveSpeedOption (CompScreen *s);
void             atlantisSetWaveSpeedNotify (CompScreen *s, atlantisScreenOptionChangeNotifyProc notify);

float            atlantisGetSmallWaveAmplitude (CompScreen *s);
CompOption *     atlantisGetSmallWaveAmplitudeOption (CompScreen *s);
void             atlantisSetSmallWaveAmplitudeNotify (CompScreen *s, atlantisScreenOptionChangeNotifyProc notify);

float            atlantisGetSmallWaveFrequency (CompScreen *s);
CompOption *     atlantisGetSmallWaveFrequencyOption (CompScreen *s);
void             atlantisSetSmallWaveFrequencyNotify (CompScreen *s, atlantisScreenOptionChangeNotifyProc notify);

float            atlantisGetSmallWaveSpeed (CompScreen *s);
CompOption *     atlantisGetSmallWaveSpeedOption (CompScreen *s);
void             atlantisSetSmallWaveSpeedNotify (CompScreen *s, atlantisScreenOptionChangeNotifyProc notify);

int              atlantisGetNumFish (CompScreen *s);
CompOption *     atlantisGetNumFishOption (CompScreen *s);
void             atlantisSetNumFishNotify (CompScreen *s, atlantisScreenOptionChangeNotifyProc notify);

Bool             atlantisGetColors (CompScreen *s);
CompOption *     atlantisGetColorsOption (CompScreen *s);
void             atlantisSetColorsNotify (CompScreen *s, atlantisScreenOptionChangeNotifyProc notify);

int              atlantisGetFishSize (CompScreen *s);
CompOption *     atlantisGetFishSizeOption (CompScreen *s);
void             atlantisSetFishSizeNotify (CompScreen *s, atlantisScreenOptionChangeNotifyProc notify);

int              atlantisGetSharkSize (CompScreen *s);
CompOption *     atlantisGetSharkSizeOption (CompScreen *s);
void             atlantisSetSharkSizeNotify (CompScreen *s, atlantisScreenOptionChangeNotifyProc notify);

int              atlantisGetDolphinSize (CompScreen *s);
CompOption *     atlantisGetDolphinSizeOption (CompScreen *s);
void             atlantisSetDolphinSizeNotify (CompScreen *s, atlantisScreenOptionChangeNotifyProc notify);

int              atlantisGetWhaleSize (CompScreen *s);
CompOption *     atlantisGetWhaleSizeOption (CompScreen *s);
void             atlantisSetWhaleSizeNotify (CompScreen *s, atlantisScreenOptionChangeNotifyProc notify);

#ifndef GENERIC_PRIVATE_DEFINES
#define GENERIC_PRIVATE_DEFINES

#define GET_PLUGIN_CORE(object, plugin) \
    ((plugin##Core *) (object)->base.privates[plugin##CorePrivateIndex].ptr)
#define PLUGIN_CORE(object, plugin, prefix) \
    plugin##Core * prefix##c = GET_PLUGIN_CORE (object, plugin)

#define GET_PLUGIN_DISPLAY(object, plugin) \
    ((plugin##Display *) \
	(object)->base.privates[plugin##DisplayPrivateIndex].ptr)
#define PLUGIN_DISPLAY(object, plugin, prefix) \
    plugin##Display * prefix##d = GET_PLUGIN_DISPLAY (object, plugin)

#define GET_PLUGIN_SCREEN(object, parent, plugin) \
    ((plugin##Screen *) \
	(object)->base.privates[(parent)->screenPrivateIndex].ptr)
#define PLUGIN_SCREEN(object, plugin, prefix) \
    plugin##Screen * prefix##s = \
	GET_PLUGIN_SCREEN (object, \
	GET_PLUGIN_DISPLAY ((object)->display, plugin), plugin)

#define GET_PLUGIN_WINDOW(object, parent, plugin) \
    ((plugin##Window *) \
	(object)->base.privates[(parent)->windowPrivateIndex].ptr)
#define PLUGIN_WINDOW(object, plugin, prefix) \
    plugin##Window * prefix##w = \
	GET_PLUGIN_WINDOW  (object, \
	GET_PLUGIN_SCREEN  ((object)->screen, \
	GET_PLUGIN_DISPLAY ((object)->screen->display, plugin), plugin), plugin)

#endif

COMPIZ_END_DECLS

#endif
