/*
 * This file is autogenerated with bcop:
 * The Compiz option code generator
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include <compiz-core.h>

#include "shelf_options.h"

static int ShelfOptionsDisplayPrivateIndex;

static CompMetadata shelfOptionsMetadata;

static CompPluginVTable *shelfPluginVTable = NULL;
CompPluginVTable shelfOptionsVTable;

#define SHELF_OPTIONS_DISPLAY(d) PLUGIN_DISPLAY(d, ShelfOptions, o)
#define SHELF_OPTIONS_SCREEN(s) PLUGIN_SCREEN(s, ShelfOptions, o)

typedef struct _ShelfOptionsDisplay
{
    int screenPrivateIndex;

    CompOption opt[ShelfDisplayOptionNum];
    shelfDisplayOptionChangeNotifyProc notify[ShelfDisplayOptionNum];
} ShelfOptionsDisplay;

typedef struct _ShelfOptionsScreen
{
} ShelfOptionsScreen;

CompAction * shelfGetTriggerKey (CompDisplay *d)
{
    SHELF_OPTIONS_DISPLAY(d);
    return &od->opt[ShelfDisplayOptionTriggerKey].value.action;
}

void shelfSetTriggerKeyInitiate (CompDisplay *d, CompActionCallBackProc init)
{
    SHELF_OPTIONS_DISPLAY(d);
    od->opt[ShelfDisplayOptionTriggerKey].value.action.initiate = init;
}

void shelfSetTriggerKeyTerminate (CompDisplay *d, CompActionCallBackProc term)
{
    SHELF_OPTIONS_DISPLAY(d);
    od->opt[ShelfDisplayOptionTriggerKey].value.action.terminate = term;
}

CompOption * shelfGetTriggerKeyOption (CompDisplay *d)
{
    SHELF_OPTIONS_DISPLAY(d);
    return &od->opt[ShelfDisplayOptionTriggerKey];
}

void shelfSetTriggerKeyNotify (CompDisplay *d, shelfDisplayOptionChangeNotifyProc notify)
{
    SHELF_OPTIONS_DISPLAY(d);
    od->notify[ShelfDisplayOptionTriggerKey] = notify;
}

CompAction * shelfGetResetKey (CompDisplay *d)
{
    SHELF_OPTIONS_DISPLAY(d);
    return &od->opt[ShelfDisplayOptionResetKey].value.action;
}

void shelfSetResetKeyInitiate (CompDisplay *d, CompActionCallBackProc init)
{
    SHELF_OPTIONS_DISPLAY(d);
    od->opt[ShelfDisplayOptionResetKey].value.action.initiate = init;
}

void shelfSetResetKeyTerminate (CompDisplay *d, CompActionCallBackProc term)
{
    SHELF_OPTIONS_DISPLAY(d);
    od->opt[ShelfDisplayOptionResetKey].value.action.terminate = term;
}

CompOption * shelfGetResetKeyOption (CompDisplay *d)
{
    SHELF_OPTIONS_DISPLAY(d);
    return &od->opt[ShelfDisplayOptionResetKey];
}

void shelfSetResetKeyNotify (CompDisplay *d, shelfDisplayOptionChangeNotifyProc notify)
{
    SHELF_OPTIONS_DISPLAY(d);
    od->notify[ShelfDisplayOptionResetKey] = notify;
}

CompAction * shelfGetTriggerscreenKey (CompDisplay *d)
{
    SHELF_OPTIONS_DISPLAY(d);
    return &od->opt[ShelfDisplayOptionTriggerscreenKey].value.action;
}

void shelfSetTriggerscreenKeyInitiate (CompDisplay *d, CompActionCallBackProc init)
{
    SHELF_OPTIONS_DISPLAY(d);
    od->opt[ShelfDisplayOptionTriggerscreenKey].value.action.initiate = init;
}

void shelfSetTriggerscreenKeyTerminate (CompDisplay *d, CompActionCallBackProc term)
{
    SHELF_OPTIONS_DISPLAY(d);
    od->opt[ShelfDisplayOptionTriggerscreenKey].value.action.terminate = term;
}

CompOption * shelfGetTriggerscreenKeyOption (CompDisplay *d)
{
    SHELF_OPTIONS_DISPLAY(d);
    return &od->opt[ShelfDisplayOptionTriggerscreenKey];
}

void shelfSetTriggerscreenKeyNotify (CompDisplay *d, shelfDisplayOptionChangeNotifyProc notify)
{
    SHELF_OPTIONS_DISPLAY(d);
    od->notify[ShelfDisplayOptionTriggerscreenKey] = notify;
}

CompAction * shelfGetDecButton (CompDisplay *d)
{
    SHELF_OPTIONS_DISPLAY(d);
    return &od->opt[ShelfDisplayOptionDecButton].value.action;
}

void shelfSetDecButtonInitiate (CompDisplay *d, CompActionCallBackProc init)
{
    SHELF_OPTIONS_DISPLAY(d);
    od->opt[ShelfDisplayOptionDecButton].value.action.initiate = init;
}

void shelfSetDecButtonTerminate (CompDisplay *d, CompActionCallBackProc term)
{
    SHELF_OPTIONS_DISPLAY(d);
    od->opt[ShelfDisplayOptionDecButton].value.action.terminate = term;
}

CompOption * shelfGetDecButtonOption (CompDisplay *d)
{
    SHELF_OPTIONS_DISPLAY(d);
    return &od->opt[ShelfDisplayOptionDecButton];
}

void shelfSetDecButtonNotify (CompDisplay *d, shelfDisplayOptionChangeNotifyProc notify)
{
    SHELF_OPTIONS_DISPLAY(d);
    od->notify[ShelfDisplayOptionDecButton] = notify;
}

CompAction * shelfGetIncButton (CompDisplay *d)
{
    SHELF_OPTIONS_DISPLAY(d);
    return &od->opt[ShelfDisplayOptionIncButton].value.action;
}

void shelfSetIncButtonInitiate (CompDisplay *d, CompActionCallBackProc init)
{
    SHELF_OPTIONS_DISPLAY(d);
    od->opt[ShelfDisplayOptionIncButton].value.action.initiate = init;
}

void shelfSetIncButtonTerminate (CompDisplay *d, CompActionCallBackProc term)
{
    SHELF_OPTIONS_DISPLAY(d);
    od->opt[ShelfDisplayOptionIncButton].value.action.terminate = term;
}

CompOption * shelfGetIncButtonOption (CompDisplay *d)
{
    SHELF_OPTIONS_DISPLAY(d);
    return &od->opt[ShelfDisplayOptionIncButton];
}

void shelfSetIncButtonNotify (CompDisplay *d, shelfDisplayOptionChangeNotifyProc notify)
{
    SHELF_OPTIONS_DISPLAY(d);
    od->notify[ShelfDisplayOptionIncButton] = notify;
}

int shelfGetAnimtime (CompDisplay *d)
{
    SHELF_OPTIONS_DISPLAY(d);
    return od->opt[ShelfDisplayOptionAnimtime].value.i;
}

CompOption * shelfGetAnimtimeOption (CompDisplay *d)
{
    SHELF_OPTIONS_DISPLAY(d);
    return &od->opt[ShelfDisplayOptionAnimtime];
}

void shelfSetAnimtimeNotify (CompDisplay *d, shelfDisplayOptionChangeNotifyProc notify)
{
    SHELF_OPTIONS_DISPLAY(d);
    od->notify[ShelfDisplayOptionAnimtime] = notify;
}

float shelfGetInterval (CompDisplay *d)
{
    SHELF_OPTIONS_DISPLAY(d);
    return od->opt[ShelfDisplayOptionInterval].value.f;
}

CompOption * shelfGetIntervalOption (CompDisplay *d)
{
    SHELF_OPTIONS_DISPLAY(d);
    return &od->opt[ShelfDisplayOptionInterval];
}

void shelfSetIntervalNotify (CompDisplay *d, shelfDisplayOptionChangeNotifyProc notify)
{
    SHELF_OPTIONS_DISPLAY(d);
    od->notify[ShelfDisplayOptionInterval] = notify;
}

CompOption * shelfGetDisplayOption (CompDisplay *d, ShelfDisplayOptions num)
{
    SHELF_OPTIONS_DISPLAY(d);
    return &od->opt[num];
}

static const CompMetadataOptionInfo shelfOptionsDisplayOptionInfo[] = {
    { "trigger_key", "key", 0, 0, 0 },
    { "reset_key", "key", 0, 0, 0 },
    { "triggerscreen_key", "key", 0, 0, 0 },
    { "dec_button", "button", 0, 0, 0 },
    { "inc_button", "button", 0, 0, 0 },
    { "animtime", "int", "<min>1</min><max>10000</max>", 0, 0 },
    { "interval", "float", "<min>0.100</min><max>0.999</max>", 0, 0 },
};

static Bool shelfOptionsSetDisplayOption (CompPlugin *plugin, CompDisplay *d, const char *name, CompOptionValue *value)
{
    SHELF_OPTIONS_DISPLAY(d);
    CompOption *o;
    int        index;

    o = compFindOption (od->opt, ShelfDisplayOptionNum, name, &index);

    if (!o)
        return FALSE;

    switch (index)
    {
     case ShelfDisplayOptionTriggerKey:
        if (compSetDisplayOption (d, o, value))
        {
            if (od->notify[ShelfDisplayOptionTriggerKey])
                (*od->notify[ShelfDisplayOptionTriggerKey]) (d, o, ShelfDisplayOptionTriggerKey);
            return TRUE;
        }
        break;
     case ShelfDisplayOptionResetKey:
        if (compSetDisplayOption (d, o, value))
        {
            if (od->notify[ShelfDisplayOptionResetKey])
                (*od->notify[ShelfDisplayOptionResetKey]) (d, o, ShelfDisplayOptionResetKey);
            return TRUE;
        }
        break;
     case ShelfDisplayOptionTriggerscreenKey:
        if (compSetDisplayOption (d, o, value))
        {
            if (od->notify[ShelfDisplayOptionTriggerscreenKey])
                (*od->notify[ShelfDisplayOptionTriggerscreenKey]) (d, o, ShelfDisplayOptionTriggerscreenKey);
            return TRUE;
        }
        break;
     case ShelfDisplayOptionDecButton:
        if (compSetDisplayOption (d, o, value))
        {
            if (od->notify[ShelfDisplayOptionDecButton])
                (*od->notify[ShelfDisplayOptionDecButton]) (d, o, ShelfDisplayOptionDecButton);
            return TRUE;
        }
        break;
     case ShelfDisplayOptionIncButton:
        if (compSetDisplayOption (d, o, value))
        {
            if (od->notify[ShelfDisplayOptionIncButton])
                (*od->notify[ShelfDisplayOptionIncButton]) (d, o, ShelfDisplayOptionIncButton);
            return TRUE;
        }
        break;
     case ShelfDisplayOptionAnimtime:
        if (compSetDisplayOption (d, o, value))
        {
            if (od->notify[ShelfDisplayOptionAnimtime])
                (*od->notify[ShelfDisplayOptionAnimtime]) (d, o, ShelfDisplayOptionAnimtime);
            return TRUE;
        }
        break;
     case ShelfDisplayOptionInterval:
        if (compSetDisplayOption (d, o, value))
        {
            if (od->notify[ShelfDisplayOptionInterval])
                (*od->notify[ShelfDisplayOptionInterval]) (d, o, ShelfDisplayOptionInterval);
            return TRUE;
        }
        break;
    default:
        break;
    }
    return FALSE;
}

static CompOption * shelfOptionsGetDisplayOptions (CompPlugin *plugin, CompDisplay *d, int *count)
{
    SHELF_OPTIONS_DISPLAY(d);
    *count = ShelfDisplayOptionNum;
    return od->opt;
}

static Bool shelfOptionsInitScreen (CompPlugin *p, CompScreen *s)
{
    ShelfOptionsScreen *os;
    
    SHELF_OPTIONS_DISPLAY (s->display);

    os = calloc (1, sizeof(ShelfOptionsScreen));
    if (!os)
        return FALSE;

    s->base.privates[od->screenPrivateIndex].ptr = os;

    
    return TRUE;
}

static void shelfOptionsFiniScreen (CompPlugin *p, CompScreen *s)
{
    SHELF_OPTIONS_SCREEN (s);

    free (os);
}

static Bool shelfOptionsInitDisplay (CompPlugin *p, CompDisplay *d)
{
    ShelfOptionsDisplay *od;
   
    
    od = calloc (1, sizeof(ShelfOptionsDisplay));
    if (!od)
        return FALSE;

    od->screenPrivateIndex = allocateScreenPrivateIndex(d);
    if (od->screenPrivateIndex < 0)
    {
        free(od);
        return FALSE;
    }

    d->base.privates[ShelfOptionsDisplayPrivateIndex].ptr = od;

    if (!compInitDisplayOptionsFromMetadata (d, &shelfOptionsMetadata, shelfOptionsDisplayOptionInfo, od->opt, ShelfDisplayOptionNum))
    {
        free (od);
        return FALSE;
    }

    return TRUE;
}

static void shelfOptionsFiniDisplay (CompPlugin *p, CompDisplay *d)
{
    SHELF_OPTIONS_DISPLAY (d);

    freeScreenPrivateIndex(d, od->screenPrivateIndex);

    compFiniDisplayOptions (d, od->opt, ShelfDisplayOptionNum);

    free (od);
}

static Bool shelfOptionsInit (CompPlugin *p)
{
    ShelfOptionsDisplayPrivateIndex = allocateDisplayPrivateIndex();
    if (ShelfOptionsDisplayPrivateIndex < 0)
        return FALSE;

    if (!compInitPluginMetadataFromInfo (&shelfOptionsMetadata, "shelf",shelfOptionsDisplayOptionInfo, ShelfDisplayOptionNum, 0, 0))
        return FALSE;

    compAddMetadataFromFile (&shelfOptionsMetadata, "shelf");
    if (shelfPluginVTable && shelfPluginVTable->init)
        return shelfPluginVTable->init (p);
    return TRUE;
}

static void shelfOptionsFini (CompPlugin *p)
{
    if (shelfPluginVTable && shelfPluginVTable->fini)
        shelfPluginVTable->fini (p);

    if (ShelfOptionsDisplayPrivateIndex >= 0)
        freeDisplayPrivateIndex (ShelfOptionsDisplayPrivateIndex);

    compFiniMetadata (&shelfOptionsMetadata);
}

static CompBool shelfOptionsInitObject (CompPlugin *p, CompObject *o)
{
    static InitPluginObjectProc dispTab[] = {
        (InitPluginObjectProc) 0,
        (InitPluginObjectProc) shelfOptionsInitDisplay,
        (InitPluginObjectProc) shelfOptionsInitScreen
    };

    RETURN_DISPATCH (o, dispTab, ARRAY_SIZE (dispTab), TRUE, (p, o));
}

static void shelfOptionsFiniObject (CompPlugin *p, CompObject *o)
{
    static FiniPluginObjectProc dispTab[] = {
        (FiniPluginObjectProc) 0,
        (FiniPluginObjectProc) shelfOptionsFiniDisplay,
        (FiniPluginObjectProc) shelfOptionsFiniScreen
    };

    DISPATCH (o, dispTab, ARRAY_SIZE (dispTab), (p, o));
}

static CompBool shelfOptionsInitObjectWrapper (CompPlugin *p, CompObject *o)
{
    CompBool rv = TRUE;
    rv = shelfOptionsInitObject (p, o);
    if (shelfPluginVTable->initObject)
        rv &= shelfPluginVTable->initObject (p, o);
    return rv;
}

static void shelfOptionsFiniObjectWrapper (CompPlugin *p, CompObject *o)
{
    if (shelfPluginVTable->finiObject)
        shelfPluginVTable->finiObject (p, o);
    shelfOptionsFiniObject (p, o);
}

static CompOption * shelfOptionsGetObjectOptions (CompPlugin *p, CompObject *o, int *count)
{
    static GetPluginObjectOptionsProc dispTab[] = {
        (GetPluginObjectOptionsProc) 0,
            (GetPluginObjectOptionsProc) shelfOptionsGetDisplayOptions,
    };

    *count = 0;
    RETURN_DISPATCH (o, dispTab, ARRAY_SIZE (dispTab),
		     NULL, (p, o, count));
}

static CompBool shelfOptionsSetObjectOption (CompPlugin *p, CompObject *o, const char *name, CompOptionValue *value)
{
    static SetPluginObjectOptionProc dispTab[] = {
        (SetPluginObjectOptionProc) 0,
        (SetPluginObjectOptionProc) shelfOptionsSetDisplayOption,
    };

    RETURN_DISPATCH (o, dispTab, ARRAY_SIZE (dispTab), FALSE,
		     (p, o, name, value));
}

static CompMetadata *
shelfOptionsGetMetadata (CompPlugin *plugin)
{
    return &shelfOptionsMetadata;
}

CompPluginVTable *getCompPluginInfo20070830 (void)
{
    if (!shelfPluginVTable)
    {
        shelfPluginVTable = getCompPluginInfo ();
        memcpy(&shelfOptionsVTable, shelfPluginVTable, sizeof(CompPluginVTable));
        shelfOptionsVTable.getMetadata = shelfOptionsGetMetadata;
        shelfOptionsVTable.init = shelfOptionsInit;
        shelfOptionsVTable.fini = shelfOptionsFini;
        shelfOptionsVTable.initObject = shelfOptionsInitObjectWrapper;
        shelfOptionsVTable.finiObject = shelfOptionsFiniObjectWrapper;
        shelfOptionsVTable.getObjectOptions = shelfOptionsGetObjectOptions;
	shelfOptionsVTable.setObjectOption = shelfOptionsSetObjectOption;
	
    }
    return &shelfOptionsVTable;
}

