/*
 * This file is autogenerated with bcop:
 * The Compiz option code generator
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include <compiz-core.h>

#include "scalefilter_options.h"

static int ScalefilterOptionsDisplayPrivateIndex;

static CompMetadata scalefilterOptionsMetadata;

static CompPluginVTable *scalefilterPluginVTable = NULL;
CompPluginVTable scalefilterOptionsVTable;

#define SCALEFILTER_OPTIONS_DISPLAY(d) PLUGIN_DISPLAY(d, ScalefilterOptions, o)
#define SCALEFILTER_OPTIONS_SCREEN(s) PLUGIN_SCREEN(s, ScalefilterOptions, o)

typedef struct _ScalefilterOptionsDisplay
{
    int screenPrivateIndex;

} ScalefilterOptionsDisplay;

typedef struct _ScalefilterOptionsScreen
{
    CompOption opt[ScalefilterScreenOptionNum];
    scalefilterScreenOptionChangeNotifyProc notify[ScalefilterScreenOptionNum];
} ScalefilterOptionsScreen;

int scalefilterGetTimeout (CompScreen *s)
{
    SCALEFILTER_OPTIONS_SCREEN(s);
    return os->opt[ScalefilterScreenOptionTimeout].value.i;
}

CompOption * scalefilterGetTimeoutOption (CompScreen *s)
{
    SCALEFILTER_OPTIONS_SCREEN(s);
    return &os->opt[ScalefilterScreenOptionTimeout];
}

void scalefilterSetTimeoutNotify (CompScreen *s, scalefilterScreenOptionChangeNotifyProc notify)
{
    SCALEFILTER_OPTIONS_SCREEN(s);
    os->notify[ScalefilterScreenOptionTimeout] = notify;
}

Bool scalefilterGetFilterCaseInsensitive (CompScreen *s)
{
    SCALEFILTER_OPTIONS_SCREEN(s);
    return os->opt[ScalefilterScreenOptionFilterCaseInsensitive].value.b;
}

CompOption * scalefilterGetFilterCaseInsensitiveOption (CompScreen *s)
{
    SCALEFILTER_OPTIONS_SCREEN(s);
    return &os->opt[ScalefilterScreenOptionFilterCaseInsensitive];
}

void scalefilterSetFilterCaseInsensitiveNotify (CompScreen *s, scalefilterScreenOptionChangeNotifyProc notify)
{
    SCALEFILTER_OPTIONS_SCREEN(s);
    os->notify[ScalefilterScreenOptionFilterCaseInsensitive] = notify;
}

Bool scalefilterGetFilterDisplay (CompScreen *s)
{
    SCALEFILTER_OPTIONS_SCREEN(s);
    return os->opt[ScalefilterScreenOptionFilterDisplay].value.b;
}

CompOption * scalefilterGetFilterDisplayOption (CompScreen *s)
{
    SCALEFILTER_OPTIONS_SCREEN(s);
    return &os->opt[ScalefilterScreenOptionFilterDisplay];
}

void scalefilterSetFilterDisplayNotify (CompScreen *s, scalefilterScreenOptionChangeNotifyProc notify)
{
    SCALEFILTER_OPTIONS_SCREEN(s);
    os->notify[ScalefilterScreenOptionFilterDisplay] = notify;
}

Bool scalefilterGetFontBold (CompScreen *s)
{
    SCALEFILTER_OPTIONS_SCREEN(s);
    return os->opt[ScalefilterScreenOptionFontBold].value.b;
}

CompOption * scalefilterGetFontBoldOption (CompScreen *s)
{
    SCALEFILTER_OPTIONS_SCREEN(s);
    return &os->opt[ScalefilterScreenOptionFontBold];
}

void scalefilterSetFontBoldNotify (CompScreen *s, scalefilterScreenOptionChangeNotifyProc notify)
{
    SCALEFILTER_OPTIONS_SCREEN(s);
    os->notify[ScalefilterScreenOptionFontBold] = notify;
}

int scalefilterGetFontSize (CompScreen *s)
{
    SCALEFILTER_OPTIONS_SCREEN(s);
    return os->opt[ScalefilterScreenOptionFontSize].value.i;
}

CompOption * scalefilterGetFontSizeOption (CompScreen *s)
{
    SCALEFILTER_OPTIONS_SCREEN(s);
    return &os->opt[ScalefilterScreenOptionFontSize];
}

void scalefilterSetFontSizeNotify (CompScreen *s, scalefilterScreenOptionChangeNotifyProc notify)
{
    SCALEFILTER_OPTIONS_SCREEN(s);
    os->notify[ScalefilterScreenOptionFontSize] = notify;
}

int scalefilterGetBorderSize (CompScreen *s)
{
    SCALEFILTER_OPTIONS_SCREEN(s);
    return os->opt[ScalefilterScreenOptionBorderSize].value.i;
}

CompOption * scalefilterGetBorderSizeOption (CompScreen *s)
{
    SCALEFILTER_OPTIONS_SCREEN(s);
    return &os->opt[ScalefilterScreenOptionBorderSize];
}

void scalefilterSetBorderSizeNotify (CompScreen *s, scalefilterScreenOptionChangeNotifyProc notify)
{
    SCALEFILTER_OPTIONS_SCREEN(s);
    os->notify[ScalefilterScreenOptionBorderSize] = notify;
}

unsigned short * scalefilterGetFontColor (CompScreen *s)
{
    SCALEFILTER_OPTIONS_SCREEN(s);
    return os->opt[ScalefilterScreenOptionFontColor].value.c;
}

unsigned short scalefilterGetFontColorRed (CompScreen *s)
{
    SCALEFILTER_OPTIONS_SCREEN(s);
    return os->opt[ScalefilterScreenOptionFontColor].value.c[0];
}

unsigned short scalefilterGetFontColorGreen (CompScreen *s)
{
    SCALEFILTER_OPTIONS_SCREEN(s);
    return os->opt[ScalefilterScreenOptionFontColor].value.c[1];
}

unsigned short scalefilterGetFontColorBlue (CompScreen *s)
{
    SCALEFILTER_OPTIONS_SCREEN(s);
    return os->opt[ScalefilterScreenOptionFontColor].value.c[2];
}

unsigned short scalefilterGetFontColorAlpha (CompScreen *s)
{
    SCALEFILTER_OPTIONS_SCREEN(s);
    return os->opt[ScalefilterScreenOptionFontColor].value.c[3];
}

CompOption * scalefilterGetFontColorOption (CompScreen *s)
{
    SCALEFILTER_OPTIONS_SCREEN(s);
    return &os->opt[ScalefilterScreenOptionFontColor];
}

void scalefilterSetFontColorNotify (CompScreen *s, scalefilterScreenOptionChangeNotifyProc notify)
{
    SCALEFILTER_OPTIONS_SCREEN(s);
    os->notify[ScalefilterScreenOptionFontColor] = notify;
}

unsigned short * scalefilterGetBackColor (CompScreen *s)
{
    SCALEFILTER_OPTIONS_SCREEN(s);
    return os->opt[ScalefilterScreenOptionBackColor].value.c;
}

unsigned short scalefilterGetBackColorRed (CompScreen *s)
{
    SCALEFILTER_OPTIONS_SCREEN(s);
    return os->opt[ScalefilterScreenOptionBackColor].value.c[0];
}

unsigned short scalefilterGetBackColorGreen (CompScreen *s)
{
    SCALEFILTER_OPTIONS_SCREEN(s);
    return os->opt[ScalefilterScreenOptionBackColor].value.c[1];
}

unsigned short scalefilterGetBackColorBlue (CompScreen *s)
{
    SCALEFILTER_OPTIONS_SCREEN(s);
    return os->opt[ScalefilterScreenOptionBackColor].value.c[2];
}

unsigned short scalefilterGetBackColorAlpha (CompScreen *s)
{
    SCALEFILTER_OPTIONS_SCREEN(s);
    return os->opt[ScalefilterScreenOptionBackColor].value.c[3];
}

CompOption * scalefilterGetBackColorOption (CompScreen *s)
{
    SCALEFILTER_OPTIONS_SCREEN(s);
    return &os->opt[ScalefilterScreenOptionBackColor];
}

void scalefilterSetBackColorNotify (CompScreen *s, scalefilterScreenOptionChangeNotifyProc notify)
{
    SCALEFILTER_OPTIONS_SCREEN(s);
    os->notify[ScalefilterScreenOptionBackColor] = notify;
}

CompOption * scalefilterGetScreenOption (CompScreen *s, ScalefilterScreenOptions num)
{
    SCALEFILTER_OPTIONS_SCREEN(s);
    return &os->opt[num];
}

static const CompMetadataOptionInfo scalefilterOptionsScreenOptionInfo[] = {
    { "timeout", "int", "<min>0</min><max>10000</max>", 0, 0 },
    { "filter_case_insensitive", "bool", 0, 0, 0 },
    { "filter_display", "bool", 0, 0, 0 },
    { "font_bold", "bool", 0, 0, 0 },
    { "font_size", "int", "<min>6</min><max>48</max>", 0, 0 },
    { "border_size", "int", "<min>1</min><max>20</max>", 0, 0 },
    { "font_color", "color", 0, 0, 0 },
    { "back_color", "color", 0, 0, 0 },
};

static Bool scalefilterOptionsSetScreenOption (CompPlugin *plugin, CompScreen *s, const char *name, CompOptionValue *value)
{
    SCALEFILTER_OPTIONS_SCREEN(s);
    CompOption *o;
    int        index;

    o = compFindOption (os->opt, ScalefilterScreenOptionNum, name, &index);

    if (!o)
        return FALSE;

    switch (index)
    {
     case ScalefilterScreenOptionTimeout:
        if (compSetScreenOption (s, o, value))
        {
            if (os->notify[ScalefilterScreenOptionTimeout])
                (*os->notify[ScalefilterScreenOptionTimeout]) (s, o, ScalefilterScreenOptionTimeout);
            return TRUE;
        }
        break;
     case ScalefilterScreenOptionFilterCaseInsensitive:
        if (compSetScreenOption (s, o, value))
        {
            if (os->notify[ScalefilterScreenOptionFilterCaseInsensitive])
                (*os->notify[ScalefilterScreenOptionFilterCaseInsensitive]) (s, o, ScalefilterScreenOptionFilterCaseInsensitive);
            return TRUE;
        }
        break;
     case ScalefilterScreenOptionFilterDisplay:
        if (compSetScreenOption (s, o, value))
        {
            if (os->notify[ScalefilterScreenOptionFilterDisplay])
                (*os->notify[ScalefilterScreenOptionFilterDisplay]) (s, o, ScalefilterScreenOptionFilterDisplay);
            return TRUE;
        }
        break;
     case ScalefilterScreenOptionFontBold:
        if (compSetScreenOption (s, o, value))
        {
            if (os->notify[ScalefilterScreenOptionFontBold])
                (*os->notify[ScalefilterScreenOptionFontBold]) (s, o, ScalefilterScreenOptionFontBold);
            return TRUE;
        }
        break;
     case ScalefilterScreenOptionFontSize:
        if (compSetScreenOption (s, o, value))
        {
            if (os->notify[ScalefilterScreenOptionFontSize])
                (*os->notify[ScalefilterScreenOptionFontSize]) (s, o, ScalefilterScreenOptionFontSize);
            return TRUE;
        }
        break;
     case ScalefilterScreenOptionBorderSize:
        if (compSetScreenOption (s, o, value))
        {
            if (os->notify[ScalefilterScreenOptionBorderSize])
                (*os->notify[ScalefilterScreenOptionBorderSize]) (s, o, ScalefilterScreenOptionBorderSize);
            return TRUE;
        }
        break;
     case ScalefilterScreenOptionFontColor:
        if (compSetScreenOption (s, o, value))
        {
            if (os->notify[ScalefilterScreenOptionFontColor])
                (*os->notify[ScalefilterScreenOptionFontColor]) (s, o, ScalefilterScreenOptionFontColor);
            return TRUE;
        }
        break;
     case ScalefilterScreenOptionBackColor:
        if (compSetScreenOption (s, o, value))
        {
            if (os->notify[ScalefilterScreenOptionBackColor])
                (*os->notify[ScalefilterScreenOptionBackColor]) (s, o, ScalefilterScreenOptionBackColor);
            return TRUE;
        }
        break;
    default:
        break;
    }
    return FALSE;
}

static CompOption * scalefilterOptionsGetScreenOptions (CompPlugin *plugin, CompScreen *s, int *count)
{
    SCALEFILTER_OPTIONS_SCREEN(s);
    *count = ScalefilterScreenOptionNum;
    return os->opt;
}

static Bool scalefilterOptionsInitScreen (CompPlugin *p, CompScreen *s)
{
    ScalefilterOptionsScreen *os;
    
    SCALEFILTER_OPTIONS_DISPLAY (s->display);

    os = calloc (1, sizeof(ScalefilterOptionsScreen));
    if (!os)
        return FALSE;

    s->base.privates[od->screenPrivateIndex].ptr = os;

    if (!compInitScreenOptionsFromMetadata (s, &scalefilterOptionsMetadata, scalefilterOptionsScreenOptionInfo, os->opt, ScalefilterScreenOptionNum))
    {
        free (os);
        return FALSE;
    }

    return TRUE;
}

static void scalefilterOptionsFiniScreen (CompPlugin *p, CompScreen *s)
{
    SCALEFILTER_OPTIONS_SCREEN (s);


    compFiniScreenOptions (s, os->opt, ScalefilterScreenOptionNum);

    free (os);
}

static Bool scalefilterOptionsInitDisplay (CompPlugin *p, CompDisplay *d)
{
    ScalefilterOptionsDisplay *od;
   
    
    od = calloc (1, sizeof(ScalefilterOptionsDisplay));
    if (!od)
        return FALSE;

    od->screenPrivateIndex = allocateScreenPrivateIndex(d);
    if (od->screenPrivateIndex < 0)
    {
        free(od);
        return FALSE;
    }

    d->base.privates[ScalefilterOptionsDisplayPrivateIndex].ptr = od;

    
    return TRUE;
}

static void scalefilterOptionsFiniDisplay (CompPlugin *p, CompDisplay *d)
{
    SCALEFILTER_OPTIONS_DISPLAY (d);

    freeScreenPrivateIndex(d, od->screenPrivateIndex);
    free (od);
}

static Bool scalefilterOptionsInit (CompPlugin *p)
{
    ScalefilterOptionsDisplayPrivateIndex = allocateDisplayPrivateIndex();
    if (ScalefilterOptionsDisplayPrivateIndex < 0)
        return FALSE;

    if (!compInitPluginMetadataFromInfo (&scalefilterOptionsMetadata, "scalefilter",0, 0, scalefilterOptionsScreenOptionInfo, ScalefilterScreenOptionNum))
        return FALSE;

    compAddMetadataFromFile (&scalefilterOptionsMetadata, "scalefilter");
    if (scalefilterPluginVTable && scalefilterPluginVTable->init)
        return scalefilterPluginVTable->init (p);
    return TRUE;
}

static void scalefilterOptionsFini (CompPlugin *p)
{
    if (scalefilterPluginVTable && scalefilterPluginVTable->fini)
        scalefilterPluginVTable->fini (p);

    if (ScalefilterOptionsDisplayPrivateIndex >= 0)
        freeDisplayPrivateIndex (ScalefilterOptionsDisplayPrivateIndex);

    compFiniMetadata (&scalefilterOptionsMetadata);
}

static CompBool scalefilterOptionsInitObject (CompPlugin *p, CompObject *o)
{
    static InitPluginObjectProc dispTab[] = {
        (InitPluginObjectProc) 0,
        (InitPluginObjectProc) scalefilterOptionsInitDisplay,
        (InitPluginObjectProc) scalefilterOptionsInitScreen
    };

    RETURN_DISPATCH (o, dispTab, ARRAY_SIZE (dispTab), TRUE, (p, o));
}

static void scalefilterOptionsFiniObject (CompPlugin *p, CompObject *o)
{
    static FiniPluginObjectProc dispTab[] = {
        (FiniPluginObjectProc) 0,
        (FiniPluginObjectProc) scalefilterOptionsFiniDisplay,
        (FiniPluginObjectProc) scalefilterOptionsFiniScreen
    };

    DISPATCH (o, dispTab, ARRAY_SIZE (dispTab), (p, o));
}

static CompBool scalefilterOptionsInitObjectWrapper (CompPlugin *p, CompObject *o)
{
    CompBool rv = TRUE;
    rv = scalefilterOptionsInitObject (p, o);
    if (scalefilterPluginVTable->initObject)
        rv &= scalefilterPluginVTable->initObject (p, o);
    return rv;
}

static void scalefilterOptionsFiniObjectWrapper (CompPlugin *p, CompObject *o)
{
    if (scalefilterPluginVTable->finiObject)
        scalefilterPluginVTable->finiObject (p, o);
    scalefilterOptionsFiniObject (p, o);
}

static CompOption * scalefilterOptionsGetObjectOptions (CompPlugin *p, CompObject *o, int *count)
{
    static GetPluginObjectOptionsProc dispTab[] = {
        (GetPluginObjectOptionsProc) 0,
            (GetPluginObjectOptionsProc) 0,
        (GetPluginObjectOptionsProc) scalefilterOptionsGetScreenOptions
    };

    *count = 0;
    RETURN_DISPATCH (o, dispTab, ARRAY_SIZE (dispTab),
		     NULL, (p, o, count));
}

static CompBool scalefilterOptionsSetObjectOption (CompPlugin *p, CompObject *o, const char *name, CompOptionValue *value)
{
    static SetPluginObjectOptionProc dispTab[] = {
        (SetPluginObjectOptionProc) 0,
        (SetPluginObjectOptionProc) 0,
        (SetPluginObjectOptionProc) scalefilterOptionsSetScreenOption
    };

    RETURN_DISPATCH (o, dispTab, ARRAY_SIZE (dispTab), FALSE,
		     (p, o, name, value));
}

static CompMetadata *
scalefilterOptionsGetMetadata (CompPlugin *plugin)
{
    return &scalefilterOptionsMetadata;
}

CompPluginVTable *getCompPluginInfo20070830 (void)
{
    if (!scalefilterPluginVTable)
    {
        scalefilterPluginVTable = getCompPluginInfo ();
        memcpy(&scalefilterOptionsVTable, scalefilterPluginVTable, sizeof(CompPluginVTable));
        scalefilterOptionsVTable.getMetadata = scalefilterOptionsGetMetadata;
        scalefilterOptionsVTable.init = scalefilterOptionsInit;
        scalefilterOptionsVTable.fini = scalefilterOptionsFini;
        scalefilterOptionsVTable.initObject = scalefilterOptionsInitObjectWrapper;
        scalefilterOptionsVTable.finiObject = scalefilterOptionsFiniObjectWrapper;
        scalefilterOptionsVTable.getObjectOptions = scalefilterOptionsGetObjectOptions;
	scalefilterOptionsVTable.setObjectOption = scalefilterOptionsSetObjectOption;
	
    }
    return &scalefilterOptionsVTable;
}

