/*
 * This file is autogenerated with bcop:
 * The Compiz option code generator
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include <compiz-core.h>

#include "reflex_options.h"

static int ReflexOptionsDisplayPrivateIndex;

static CompMetadata reflexOptionsMetadata;

static CompPluginVTable *reflexPluginVTable = NULL;
CompPluginVTable reflexOptionsVTable;

#define REFLEX_OPTIONS_DISPLAY(d) PLUGIN_DISPLAY(d, ReflexOptions, o)
#define REFLEX_OPTIONS_SCREEN(s) PLUGIN_SCREEN(s, ReflexOptions, o)

typedef struct _ReflexOptionsDisplay
{
    int screenPrivateIndex;

} ReflexOptionsDisplay;

typedef struct _ReflexOptionsScreen
{
    CompOption opt[ReflexScreenOptionNum];
    reflexScreenOptionChangeNotifyProc notify[ReflexScreenOptionNum];
} ReflexOptionsScreen;

char * reflexGetFile (CompScreen *s)
{
    REFLEX_OPTIONS_SCREEN(s);
    return os->opt[ReflexScreenOptionFile].value.s;
}

CompOption * reflexGetFileOption (CompScreen *s)
{
    REFLEX_OPTIONS_SCREEN(s);
    return &os->opt[ReflexScreenOptionFile];
}

void reflexSetFileNotify (CompScreen *s, reflexScreenOptionChangeNotifyProc notify)
{
    REFLEX_OPTIONS_SCREEN(s);
    os->notify[ReflexScreenOptionFile] = notify;
}

CompMatch * reflexGetMatch (CompScreen *s)
{
    REFLEX_OPTIONS_SCREEN(s);
    return &os->opt[ReflexScreenOptionMatch].value.match;
}

CompOption * reflexGetMatchOption (CompScreen *s)
{
    REFLEX_OPTIONS_SCREEN(s);
    return &os->opt[ReflexScreenOptionMatch];
}

void reflexSetMatchNotify (CompScreen *s, reflexScreenOptionChangeNotifyProc notify)
{
    REFLEX_OPTIONS_SCREEN(s);
    os->notify[ReflexScreenOptionMatch] = notify;
}

Bool reflexGetWindow (CompScreen *s)
{
    REFLEX_OPTIONS_SCREEN(s);
    return os->opt[ReflexScreenOptionWindow].value.b;
}

CompOption * reflexGetWindowOption (CompScreen *s)
{
    REFLEX_OPTIONS_SCREEN(s);
    return &os->opt[ReflexScreenOptionWindow];
}

void reflexSetWindowNotify (CompScreen *s, reflexScreenOptionChangeNotifyProc notify)
{
    REFLEX_OPTIONS_SCREEN(s);
    os->notify[ReflexScreenOptionWindow] = notify;
}

Bool reflexGetDecoration (CompScreen *s)
{
    REFLEX_OPTIONS_SCREEN(s);
    return os->opt[ReflexScreenOptionDecoration].value.b;
}

CompOption * reflexGetDecorationOption (CompScreen *s)
{
    REFLEX_OPTIONS_SCREEN(s);
    return &os->opt[ReflexScreenOptionDecoration];
}

void reflexSetDecorationNotify (CompScreen *s, reflexScreenOptionChangeNotifyProc notify)
{
    REFLEX_OPTIONS_SCREEN(s);
    os->notify[ReflexScreenOptionDecoration] = notify;
}

int reflexGetThreshold (CompScreen *s)
{
    REFLEX_OPTIONS_SCREEN(s);
    return os->opt[ReflexScreenOptionThreshold].value.i;
}

CompOption * reflexGetThresholdOption (CompScreen *s)
{
    REFLEX_OPTIONS_SCREEN(s);
    return &os->opt[ReflexScreenOptionThreshold];
}

void reflexSetThresholdNotify (CompScreen *s, reflexScreenOptionChangeNotifyProc notify)
{
    REFLEX_OPTIONS_SCREEN(s);
    os->notify[ReflexScreenOptionThreshold] = notify;
}

Bool reflexGetMoving (CompScreen *s)
{
    REFLEX_OPTIONS_SCREEN(s);
    return os->opt[ReflexScreenOptionMoving].value.b;
}

CompOption * reflexGetMovingOption (CompScreen *s)
{
    REFLEX_OPTIONS_SCREEN(s);
    return &os->opt[ReflexScreenOptionMoving];
}

void reflexSetMovingNotify (CompScreen *s, reflexScreenOptionChangeNotifyProc notify)
{
    REFLEX_OPTIONS_SCREEN(s);
    os->notify[ReflexScreenOptionMoving] = notify;
}

CompOption * reflexGetScreenOption (CompScreen *s, ReflexScreenOptions num)
{
    REFLEX_OPTIONS_SCREEN(s);
    return &os->opt[num];
}

static const CompMetadataOptionInfo reflexOptionsScreenOptionInfo[] = {
    { "file", "string", 0, 0, 0 },
    { "match", "match", 0, 0, 0 },
    { "window", "bool", 0, 0, 0 },
    { "decoration", "bool", 0, 0, 0 },
    { "threshold", "int", "<min>1</min><max>10</max>", 0, 0 },
    { "moving", "bool", 0, 0, 0 },
};

static Bool reflexOptionsSetScreenOption (CompPlugin *plugin, CompScreen *s, const char *name, CompOptionValue *value)
{
    REFLEX_OPTIONS_SCREEN(s);
    CompOption *o;
    int        index;

    o = compFindOption (os->opt, ReflexScreenOptionNum, name, &index);

    if (!o)
        return FALSE;

    switch (index)
    {
     case ReflexScreenOptionFile:
        if (compSetScreenOption (s, o, value))
        {
            if (os->notify[ReflexScreenOptionFile])
                (*os->notify[ReflexScreenOptionFile]) (s, o, ReflexScreenOptionFile);
            return TRUE;
        }
        break;
     case ReflexScreenOptionMatch:
        if (compSetScreenOption (s, o, value))
        {
            if (os->notify[ReflexScreenOptionMatch])
                (*os->notify[ReflexScreenOptionMatch]) (s, o, ReflexScreenOptionMatch);
            return TRUE;
        }
        break;
     case ReflexScreenOptionWindow:
        if (compSetScreenOption (s, o, value))
        {
            if (os->notify[ReflexScreenOptionWindow])
                (*os->notify[ReflexScreenOptionWindow]) (s, o, ReflexScreenOptionWindow);
            return TRUE;
        }
        break;
     case ReflexScreenOptionDecoration:
        if (compSetScreenOption (s, o, value))
        {
            if (os->notify[ReflexScreenOptionDecoration])
                (*os->notify[ReflexScreenOptionDecoration]) (s, o, ReflexScreenOptionDecoration);
            return TRUE;
        }
        break;
     case ReflexScreenOptionThreshold:
        if (compSetScreenOption (s, o, value))
        {
            if (os->notify[ReflexScreenOptionThreshold])
                (*os->notify[ReflexScreenOptionThreshold]) (s, o, ReflexScreenOptionThreshold);
            return TRUE;
        }
        break;
     case ReflexScreenOptionMoving:
        if (compSetScreenOption (s, o, value))
        {
            if (os->notify[ReflexScreenOptionMoving])
                (*os->notify[ReflexScreenOptionMoving]) (s, o, ReflexScreenOptionMoving);
            return TRUE;
        }
        break;
    default:
        break;
    }
    return FALSE;
}

static CompOption * reflexOptionsGetScreenOptions (CompPlugin *plugin, CompScreen *s, int *count)
{
    REFLEX_OPTIONS_SCREEN(s);
    *count = ReflexScreenOptionNum;
    return os->opt;
}

static Bool reflexOptionsInitScreen (CompPlugin *p, CompScreen *s)
{
    ReflexOptionsScreen *os;
    
    REFLEX_OPTIONS_DISPLAY (s->display);

    os = calloc (1, sizeof(ReflexOptionsScreen));
    if (!os)
        return FALSE;

    s->base.privates[od->screenPrivateIndex].ptr = os;

    if (!compInitScreenOptionsFromMetadata (s, &reflexOptionsMetadata, reflexOptionsScreenOptionInfo, os->opt, ReflexScreenOptionNum))
    {
        free (os);
        return FALSE;
    }

    return TRUE;
}

static void reflexOptionsFiniScreen (CompPlugin *p, CompScreen *s)
{
    REFLEX_OPTIONS_SCREEN (s);


    compFiniScreenOptions (s, os->opt, ReflexScreenOptionNum);

    free (os);
}

static Bool reflexOptionsInitDisplay (CompPlugin *p, CompDisplay *d)
{
    ReflexOptionsDisplay *od;
   
    
    od = calloc (1, sizeof(ReflexOptionsDisplay));
    if (!od)
        return FALSE;

    od->screenPrivateIndex = allocateScreenPrivateIndex(d);
    if (od->screenPrivateIndex < 0)
    {
        free(od);
        return FALSE;
    }

    d->base.privates[ReflexOptionsDisplayPrivateIndex].ptr = od;

    
    return TRUE;
}

static void reflexOptionsFiniDisplay (CompPlugin *p, CompDisplay *d)
{
    REFLEX_OPTIONS_DISPLAY (d);

    freeScreenPrivateIndex(d, od->screenPrivateIndex);
    free (od);
}

static Bool reflexOptionsInit (CompPlugin *p)
{
    ReflexOptionsDisplayPrivateIndex = allocateDisplayPrivateIndex();
    if (ReflexOptionsDisplayPrivateIndex < 0)
        return FALSE;

    if (!compInitPluginMetadataFromInfo (&reflexOptionsMetadata, "reflex",0, 0, reflexOptionsScreenOptionInfo, ReflexScreenOptionNum))
        return FALSE;

    compAddMetadataFromFile (&reflexOptionsMetadata, "reflex");
    if (reflexPluginVTable && reflexPluginVTable->init)
        return reflexPluginVTable->init (p);
    return TRUE;
}

static void reflexOptionsFini (CompPlugin *p)
{
    if (reflexPluginVTable && reflexPluginVTable->fini)
        reflexPluginVTable->fini (p);

    if (ReflexOptionsDisplayPrivateIndex >= 0)
        freeDisplayPrivateIndex (ReflexOptionsDisplayPrivateIndex);

    compFiniMetadata (&reflexOptionsMetadata);
}

static CompBool reflexOptionsInitObject (CompPlugin *p, CompObject *o)
{
    static InitPluginObjectProc dispTab[] = {
        (InitPluginObjectProc) 0,
        (InitPluginObjectProc) reflexOptionsInitDisplay,
        (InitPluginObjectProc) reflexOptionsInitScreen
    };

    RETURN_DISPATCH (o, dispTab, ARRAY_SIZE (dispTab), TRUE, (p, o));
}

static void reflexOptionsFiniObject (CompPlugin *p, CompObject *o)
{
    static FiniPluginObjectProc dispTab[] = {
        (FiniPluginObjectProc) 0,
        (FiniPluginObjectProc) reflexOptionsFiniDisplay,
        (FiniPluginObjectProc) reflexOptionsFiniScreen
    };

    DISPATCH (o, dispTab, ARRAY_SIZE (dispTab), (p, o));
}

static CompBool reflexOptionsInitObjectWrapper (CompPlugin *p, CompObject *o)
{
    CompBool rv = TRUE;
    rv = reflexOptionsInitObject (p, o);
    if (reflexPluginVTable->initObject)
        rv &= reflexPluginVTable->initObject (p, o);
    return rv;
}

static void reflexOptionsFiniObjectWrapper (CompPlugin *p, CompObject *o)
{
    if (reflexPluginVTable->finiObject)
        reflexPluginVTable->finiObject (p, o);
    reflexOptionsFiniObject (p, o);
}

static CompOption * reflexOptionsGetObjectOptions (CompPlugin *p, CompObject *o, int *count)
{
    static GetPluginObjectOptionsProc dispTab[] = {
        (GetPluginObjectOptionsProc) 0,
            (GetPluginObjectOptionsProc) 0,
        (GetPluginObjectOptionsProc) reflexOptionsGetScreenOptions
    };

    *count = 0;
    RETURN_DISPATCH (o, dispTab, ARRAY_SIZE (dispTab),
		     NULL, (p, o, count));
}

static CompBool reflexOptionsSetObjectOption (CompPlugin *p, CompObject *o, const char *name, CompOptionValue *value)
{
    static SetPluginObjectOptionProc dispTab[] = {
        (SetPluginObjectOptionProc) 0,
        (SetPluginObjectOptionProc) 0,
        (SetPluginObjectOptionProc) reflexOptionsSetScreenOption
    };

    RETURN_DISPATCH (o, dispTab, ARRAY_SIZE (dispTab), FALSE,
		     (p, o, name, value));
}

static CompMetadata *
reflexOptionsGetMetadata (CompPlugin *plugin)
{
    return &reflexOptionsMetadata;
}

CompPluginVTable *getCompPluginInfo20070830 (void)
{
    if (!reflexPluginVTable)
    {
        reflexPluginVTable = getCompPluginInfo ();
        memcpy(&reflexOptionsVTable, reflexPluginVTable, sizeof(CompPluginVTable));
        reflexOptionsVTable.getMetadata = reflexOptionsGetMetadata;
        reflexOptionsVTable.init = reflexOptionsInit;
        reflexOptionsVTable.fini = reflexOptionsFini;
        reflexOptionsVTable.initObject = reflexOptionsInitObjectWrapper;
        reflexOptionsVTable.finiObject = reflexOptionsFiniObjectWrapper;
        reflexOptionsVTable.getObjectOptions = reflexOptionsGetObjectOptions;
	reflexOptionsVTable.setObjectOption = reflexOptionsSetObjectOption;
	
    }
    return &reflexOptionsVTable;
}

