/*
 * super.c - NILFS v1 tool inspector, read NILFS superblock
 *
 * Copyright (C) 2005, 2006 Nippon Telegraph and Telephone Corporation.
 *
 * This file is part of NILFS.
 *
 * NILFS is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * NILFS is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with NILFS; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *
 * super.c,v 1.12 2006/03/09 05:51:24 amagai Exp
 *
 * Written by Amagai Yoshiji <amagai@osrg.net>
 */

#include "inspect.h"

struct nilfs_super_block superblock;
struct nilfs_sb_info sb_info;
struct nilfs_seg_info seg_info;

int
nilfs_fill_super()
{
	int r;
	struct nilfs_sb_info *sbi = &sb_info;
	sbi->s_super = &sbi->sb;
	sbi->s_super->sbi = sbi;

	r = readstruct(&superblock, sizeof(struct nilfs_super_block), NILFS_SB_OFFSET_BYTES);
	if (r < 0)
		return -1;

	sbi->s_rev_level = __le32_to_cpu(superblock.s_rev_level);
	sbi->s_minor_rev_level = __le16_to_cpu(superblock.s_minor_rev_level);
	sbi->s_last_pseg = __le64_to_cpu(superblock.s_last_segment);
	sbi->s_nsegment = __le32_to_cpu(superblock.s_nsegment);
	sbi->s_crc_seed = __le32_to_cpu(superblock.s_crc_seed);
	sbi->s_blocks_per_segment = __le32_to_cpu(superblock.s_blocks_per_segment);
	sbi->s_first_data_block = __le64_to_cpu(superblock.s_first_data_block);
	sbi->s_mount_state = __le16_to_cpu(superblock.s_state);

	blksperseg = __le32_to_cpu(superblock.s_blocks_per_segment);
	blocksize = 1024LL << __le64_to_cpu(superblock.s_log_block_size);
	sbi->s_super->s_blocksize = blocksize;

	return 0;
}

/* Local Variables:	*/
/* eval: (c-set-style "linux")	*/
/* End:			*/
