/*
 * kern_feature.h - Kernel-version dependent features definition for NILFS
 *
 * Copyright (C) 2006 Nippon Telegraph and Telephone Corporation.
 *
 * This file is part of NILFS.
 *
 * NILFS is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * NILFS is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with NILFS; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *
 * kern_feature.h,v 1.14 2006/07/12 07:50:22 ryusuke Exp
 */

#ifndef NILFS_KERN_FEATURE_H
#define NILFS_KERN_FEATURE_H

#include <linux/version.h>

/*
 * Please define as 0/1 here if you want to override
 */

/*
 * defaults dependent to kernel versions
 */

#ifdef LINUX_VERSION_CODE
/*
 * find_trylock_page will be deprecated in linux-2.6.17
 */
#ifndef NEED_FIND_TRYLOCK_PAGE
# define NEED_FIND_TRYLOCK_PAGE	\
	(LINUX_VERSION_CODE > KERNEL_VERSION(2,6,16))
#endif
/*
 * A return value of sync_page() disappeared in linux-2.6.17
 */
#ifndef NEED_SYNC_PAGE_RETVAL
# define NEED_SYNC_PAGE_RETVAL	\
	(LINUX_VERSION_CODE < KERNEL_VERSION(2,6,17))
#endif
/*
 * bd_mount_mutex replaced semaphore counterpart in linux-2.6.17
 */
#ifndef NEED_MOUNT_SEMAPHORE
# define NEED_MOUNT_SEMAPHORE		\
	(LINUX_VERSION_CODE < KERNEL_VERSION(2,6,17))
#endif
/*
 * get_blocks_t was unified to get_block_t in linux-2.6.17
 */
#ifndef NEED_GET_BLOCKS_T
# define NEED_GET_BLOCKS_T	\
	(LINUX_VERSION_CODE < KERNEL_VERSION(2,6,17))
#endif
/*
 * A return value of invalidatepage() was done away with linux-2.6.17
 */
#ifndef NEED_INVALIDATEPAGE_RETVAL
# define NEED_INVALIDATEPAGE_RETVAL	\
	(LINUX_VERSION_CODE < KERNEL_VERSION(2,6,17))
#endif
/*
 * A measure against a buffer overrun problem around sysfs write 
 * for linux-2.6.16 and older versions.
 */
#ifndef NEED_SYSFS_TERMINATOR_CHECK
# define NEED_SYSFS_TERMINATOR_CHECK	\
	(LINUX_VERSION_CODE < KERNEL_VERSION(2,6,17))
#endif
/*
 * mutex replaced semaphore since linux-2.6.16
 */
#ifndef NEED_INODE_SEMAPHORE
# define NEED_INODE_SEMAPHORE		\
	(LINUX_VERSION_CODE < KERNEL_VERSION(2,6,16))
#endif
/*
 * attribute argument was removed from kobject_uevent since linux-2.6.16
 */
#ifndef NEED_KOBJECT_UEVENT_ATTRIBUTE_ARG
# define NEED_KOBJECT_UEVENT_ATTRIBUTE_ARG		\
	(LINUX_VERSION_CODE < KERNEL_VERSION(2,6,16))
#endif
/*
 * s_old_blocksize was removed since linux-2.6.16
 */
#ifndef NEED_S_OLD_BLOCKSIZE
# define NEED_S_OLD_BLOCKSIZE				\
	(LINUX_VERSION_CODE < KERNEL_VERSION(2,6,16))
#endif
/*
 * typedef gfp_t included since linux-2.6.15
 */
#ifndef NEED_GFP_T
# define NEED_GFP_T					\
	(LINUX_VERSION_CODE < KERNEL_VERSION(2,6,15))
#endif
/*
 * truncate_inode_pages() should be called in each fs since linux-2.6.14.
 */
#ifndef NEED_TRUNCATE_INODE_PAGES
# define NEED_TRUNCATE_INODE_PAGES			\
	(LINUX_VERSION_CODE > KERNEL_VERSION(2,6,13))
#endif
/*
 * refrigerator() have no arguments since linux-2.6.13.
 */
#ifndef NEED_REFRIGERATOR_ARGS
# define NEED_REFRIGERATOR_ARGS				\
	(LINUX_VERSION_CODE < KERNEL_VERSION(2,6,13))
#endif
/*
 * r/w spinlock is used for standard radix-tree since linux-2.6.12.
 */
#ifndef NEED_RWLOCK_FOR_PAGECACHE_LOCK
# define NEED_RWLOCK_FOR_PAGECACHE_LOCK			\
	(LINUX_VERSION_CODE > KERNEL_VERSION(2,6,11))
#endif
/*
 * atomic counter no longer used for truncate_count since linux-2.6.11.
 */
#ifndef NEED_ATOMIC_COUNTER_FOR_TRUNCATE_COUNT
# define NEED_ATOMIC_COUNTER_FOR_TRUNCATE_COUNT		\
	(LINUX_VERSION_CODE < KERNEL_VERSION(2,6,11))
#endif
/*
 * MS_ONE_SECOND mount flag deleted since linux-2.6.11.
 */
#ifndef NEED_MS_ONE_SECOND
# define NEED_MS_ONE_SECOND				\
	(LINUX_VERSION_CODE < KERNEL_VERSION(2,6,11))
#endif
/*
 * write_inode_now() has return val since linux-2.6.11
 */
#ifndef NEED_VOID_WRITE_INODE_NOW
# define NEED_VOID_WRITE_INODE_NOW			\
	(LINUX_VERSION_CODE < KERNEL_VERSION(2,6,11))
#endif

/*
 *  function timespec_trunc (kernel/time.c) was introduced at 2.6.11
 */
#ifndef NEED_TIMESPEC_TRUNC
# define NEED_TIMESPEC_TRUNC			\
	(LINUX_VERSION_CODE < KERNEL_VERSION(2,6,11))
#endif

#endif /* LINUX_VERSION_CODE */

/*
 * definitions dependent to above macros
 */
#if NEED_GFP_T
#define gfp_t int
#define GFP_T unsigned int
#else
#define GFP_T gfp_t
#endif

#if NEED_TIMESPEC_TRUNC
#define timespec_trunc(x, y) (x)
#endif

#endif /* NILFS_KERN_FEATURE_H */

/* Local Variables:	*/
/* eval: (c-set-style "linux")	*/
/* End:			*/
