/***************************************************************************
 *   Copyright (C) 2005 Novell, Inc.                                       *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA           *
 ***************************************************************************/

#ifndef KERRYAPP_H
#define KERRYAPP_H

#include <kuniqueapplication.h>
#include <ksystemtray.h>
#include <kglobalaccel.h>

#define kerryApp ((KerryApplication*)qApp)
#define MAX_HISTORY_ITEMS 10

class kerry;
class KCmdLineArgs;
class SearchDlg;
class KHelpMenu;
class KAboutData;
class KProcess;

class KerryApplication : public KUniqueApplication
{
    Q_OBJECT

  public:
    KerryApplication();
    ~KerryApplication();
    void init(const KAboutData* about);
    int newInstance();
    void search(const QString&);

  protected:
    SearchDlg* hitListWindow;
    KSystemTray* sysTrayIcon;

  protected slots:
    void searchPrimarySelection();
    void clearHistory();
    void configure();
    void aboutToShowSysTrayMenu();
    void historySelected(int);
    void quitKerry();
    void gotAvailableBackends(KProcess*, char *buffer, int len);
    void checkBeagleBuildIndex();

  private:
    void readIndexConfig(bool &indexHomeDir, bool &indexOnBattery, QStringList &roots, QStringList &excludeTypes, QStringList &excludeValues);
    bool saveIndexConfig(bool indexHomeDir, bool indexOnBattery, QStringList roots, QStringList excludeTypes, QStringList excludeValues);

    QStringList readDisabledBackends();
    bool saveDisabledBackends(QStringList disabledBackends);

    QStringList m_availableBackends;
    KGlobalAccel *globalKeys;
};

#endif // KERRYAPP_H
