/***************************************************************************
 *   Copyright (C) 2005 Novell, Inc.                                       *
 *   Copyright (C) 2006 Debajyoti Bera                                     *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA           *
 ***************************************************************************/

#ifndef CONFIGDIALOG_H
#define CONFIGDIALOG_H

#include <qcheckbox.h>
#include <qevent.h>
#include <qgroupbox.h>
#include <qheader.h>
#include <qradiobutton.h>
#include <qvbox.h>
#include <qspinbox.h>
#include <qcombobox.h>

#include <kdialogbase.h>
#include <keditlistbox.h>
#include <kkeydialog.h>
#include <klistview.h>

class KGlobalAccel;
class KKeyChooser;
class KListView;
class QPushButton;
class QDialog;
class ConfigDialog;
class QTextEdit;

class SearchWidget : public QVBox
{
    Q_OBJECT

    friend class ConfigDialog;

public:
    SearchWidget( QWidget *parent, KGlobalAccel *accel, const char *name );
    ~SearchWidget();

private:
    QSpinBox *maxResultsDisplayed;
    QComboBox* combo_order;
    KKeyChooser *keysWidget;
};

class IndexingWidget : public QVBox
{
    Q_OBJECT

    friend class ConfigDialog;

public:
    IndexingWidget( QWidget *parent, const char *name );
    ~IndexingWidget();

private slots:
    void slotAddSearch();
    void slotRemoveSearch();
    void slotSearchSelectionChanged(QListViewItem*);
    void slotAddPrivacy();
    void slotRemovePrivacy();
    void slotPrivacySelectionChanged(QListViewItem*);

private:
    QCheckBox *startBeagle;
    QCheckBox *indexOnBattery;
    QCheckBox *indexHome;
    KListView* index_list, *privacy_list;
    QPushButton* remove_index, *remove_privacy;
};

class BackendsWidget : public QVBox
{
    Q_OBJECT

    friend class ConfigDialog;

public:
    BackendsWidget( QWidget *parent, const char *name );
    ~BackendsWidget();

private:
    KListView* listview;
};

class StatusWidget : public QVBox
{
    Q_OBJECT

    friend class ConfigDialog;

public:
    StatusWidget( QWidget *parent, const char *name );
    ~StatusWidget();

private slots:
    void refreshStatus ();
    void controlPressed ();
    void verifyStatus ();

private:
    bool refreshDaemonStatus ();
    bool stopBeagle ();
    bool startBeagle ();

    QLabel *label_control;
    KPushButton *pb_control, *pb_refresh;
    QLabel *version_label;
    QTextEdit *status_area, *index_info_box;
    QGroupBox *status_box;
    bool last_status;
};

class ConfigDialog : public KDialogBase
{
    Q_OBJECT

public:
    ConfigDialog( KGlobalAccel *accel );
    ~ConfigDialog();

    bool getStartBeagle() const;
    void setStartBeagle(bool);

    bool getIndexOnBattery() const;
    void setIndexOnBattery(bool);

    int getDefaultSortOrder() const;
    void setDefaultSortOrder(int);

    int getMaxResultsDisplayed() const;
    void setMaxResultsDisplayed(int);

    void commitShortcuts();

    bool getIndexHome() const;
    void setIndexHome(bool);

    QStringList getRoots() const;
    void setRoots(QStringList);

    QStringList getTypes() const;
    QStringList getValues() const;
    void setExcludes(QStringList types, QStringList values);

    void addAvailableBackends(QStringList availableBackends);
    void setDisabledBackends(QStringList disabledBackends);
    QStringList getDisabledBackends();

private:
    SearchWidget *searchWidget;
    IndexingWidget *indexingWidget;
    BackendsWidget *backendsWidget;
    StatusWidget *statusWidget;
};

#endif // CONFIGDIALOG_H
