/*
 *  Copyright (C) 2005 Kouji TAKAO <kouji@netlab.jp>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef __GPASS_HELPER_H__
#define __GPASS_HELPER_H__

#include <glib/gerror.h>
#include <gtk/gtkmessagedialog.h>

G_BEGIN_DECLS

void gpass_helper_message(GtkMessageType type, const char *fmt, ...);
void gpass_helper_shutdown_main_loop(GMainLoop *main_loop);
void gpass_helper_error(GError *error, const gchar *file, gint line);

#define gpass_helper_error(error) \
    (gpass_helper_error(error, __FILE__, __LINE__))

G_END_DECLS

#endif /* #ifndef __GPASS_HELPER_H__ */
